/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.demo.AlignmentTab;
import com.jgoodies.looks.demo.ComboBoxTab;
import com.jgoodies.looks.demo.DesktopTab;
import com.jgoodies.looks.demo.DialogsTab;
import com.jgoodies.looks.demo.HtmlTab;
import com.jgoodies.looks.demo.MenuBarView;
import com.jgoodies.looks.demo.NarrowTab;
import com.jgoodies.looks.demo.Settings;
import com.jgoodies.looks.demo.SplitTab;
import com.jgoodies.looks.demo.StateTab;
import com.jgoodies.looks.demo.TabTestTab;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DemoFrame
extends JFrame {
    protected static final Dimension PREFERRED_SIZE = LookUtils.IS_LOW_RESOLUTION ? new Dimension(650, 510) : new Dimension(730, 560);
    private static final String COPYRIGHT = "\u00a9 2001-2009 JGoodies Karsten Lentzsch. All Rights Reserved.";
    private final Settings settings;

    protected DemoFrame(Settings settings) {
        this.settings = settings;
        this.configureUI();
        this.build();
        this.setDefaultCloseOperation(2);
    }

    public static void main(String[] args) {
        Settings settings = DemoFrame.createDefaultSettings();
        if (args.length > 0) {
            String lafShortName = args[0];
            String lafClassName = "Windows".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.windows.WindowsLookAndFeel" : ("Plastic".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.plastic.PlasticLookAndFeel" : ("Plastic3D".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.plastic.Plastic3DLookAndFeel" : ("PlasticXP".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.plastic.PlasticXPLookAndFeel" : lafShortName)));
            System.out.println("L&f chosen: " + lafClassName);
            settings.setSelectedLookAndFeel(lafClassName);
        }
        DemoFrame instance = new DemoFrame(settings);
        instance.setSize(PREFERRED_SIZE);
        instance.locateOnScreen(instance);
        instance.setVisible(true);
    }

    private static Settings createDefaultSettings() {
        Settings settings = Settings.createDefault();
        return settings;
    }

    private void configureUI() {
        Options.setDefaultIconSize(new Dimension(18, 18));
        Options.setUseNarrowButtons(this.settings.isUseNarrowButtons());
        Options.setTabIconsEnabled(this.settings.isTabIconsEnabled());
        UIManager.put("jgoodies.popupDropShadowEnabled", this.settings.isPopupDropShadowEnabled());
        LookAndFeel selectedLaf = this.settings.getSelectedLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme(this.settings.getSelectedTheme());
            PlasticLookAndFeel.setTabStyle(this.settings.getPlasticTabStyle());
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled(this.settings.isPlasticHighContrastFocusEnabled());
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        try {
            UIManager.setLookAndFeel(selectedLaf);
        }
        catch (Exception e) {
            System.out.println("Can't change L&F: " + e);
        }
    }

    private void build() {
        this.setContentPane(this.buildContentPane());
        this.setTitle(this.getWindowTitle());
        this.setJMenuBar(this.createMenuBuilder().buildMenuBar(this.settings, this.createHelpActionListener(), this.createAboutActionListener()));
        this.setIconImage(DemoFrame.readImageIcon("eye_16x16.gif").getImage());
    }

    protected MenuBarView createMenuBuilder() {
        return new MenuBarView();
    }

    private JComponent buildContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildToolBar(), "North");
        panel.add(this.buildMainPanel(), "Center");
        return panel;
    }

    private Component buildToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(true);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.putClientProperty("jgoodies.headerStyle", this.settings.getToolBarHeaderStyle());
        toolBar.putClientProperty("Plastic.borderStyle", this.settings.getToolBarPlasticBorderStyle());
        toolBar.putClientProperty("jgoodies.windows.borderStyle", this.settings.getToolBarWindowsBorderStyle());
        toolBar.putClientProperty("Plastic.is3D", this.settings.getToolBar3DHint());
        toolBar.add(this.createToolBarButton("backward.gif", "Back"));
        AbstractButton button = this.createToolBarButton("forward.gif", "Next");
        button.setEnabled(false);
        toolBar.add(button);
        toolBar.add(this.createToolBarButton("home.gif", "Home"));
        toolBar.addSeparator();
        OpenFileActionListener openAction = new OpenFileActionListener();
        button = this.createToolBarButton("open.gif", "Open", openAction, KeyStroke.getKeyStroke(79, 128));
        button.addActionListener(openAction);
        toolBar.add(button);
        toolBar.add(this.createToolBarButton("print.gif", "Print"));
        toolBar.add(this.createToolBarButton("refresh.gif", "Update"));
        toolBar.addSeparator();
        ButtonGroup group = new ButtonGroup();
        button = this.createToolBarRadioButton("pie_mode.png", "Pie Chart");
        button.setSelectedIcon(DemoFrame.readImageIcon("pie_mode_selected.gif"));
        group.add(button);
        button.setSelected(true);
        toolBar.add(button);
        button = this.createToolBarRadioButton("bar_mode.png", "Bar Chart");
        button.setSelectedIcon(DemoFrame.readImageIcon("bar_mode_selected.gif"));
        group.add(button);
        toolBar.add(button);
        button = this.createToolBarRadioButton("table_mode.png", "Table");
        button.setSelectedIcon(DemoFrame.readImageIcon("table_mode_selected.gif"));
        group.add(button);
        toolBar.add(button);
        toolBar.addSeparator();
        button = this.createToolBarButton("help.gif", "Open Help");
        button.addActionListener(this.createHelpActionListener());
        toolBar.add(button);
        return toolBar;
    }

    protected AbstractButton createToolBarButton(String iconName, String toolTipText) {
        JButton button = new JButton(DemoFrame.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    private AbstractButton createToolBarButton(String iconName, String toolTipText, ActionListener action, KeyStroke keyStroke) {
        AbstractButton button = this.createToolBarButton(iconName, toolTipText);
        button.registerKeyboardAction(action, keyStroke, 2);
        return button;
    }

    protected AbstractButton createToolBarRadioButton(String iconName, String toolTipText) {
        JToggleButton button = new JToggleButton(DemoFrame.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    private Component buildMainPanel() {
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.addTabs(tabbedPane);
        tabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        return tabbedPane;
    }

    private void addTabs(JTabbedPane tabbedPane) {
        tabbedPane.addTab("State", new StateTab().build());
        tabbedPane.addTab("Align", new AlignmentTab().build());
        tabbedPane.addTab("Tab", new TabTestTab().build());
        tabbedPane.addTab("Split", new SplitTab().build());
        tabbedPane.addTab("Combo", new ComboBoxTab().build());
        tabbedPane.addTab("HTML", new HtmlTab().build());
        tabbedPane.addTab("Dialog", new DialogsTab().build(tabbedPane));
        tabbedPane.addTab("Desktop", new DesktopTab().build());
        tabbedPane.addTab("Narrow", new NarrowTab().build());
    }

    protected String getWindowTitle() {
        return "Simple Looks Demo";
    }

    protected static ImageIcon readImageIcon(String filename) {
        URL url = DemoFrame.class.getResource("resources/images/" + filename);
        return new ImageIcon(url);
    }

    protected void locateOnScreen(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    protected ActionListener createHelpActionListener() {
        return null;
    }

    protected ActionListener createAboutActionListener() {
        return new AboutActionListener();
    }

    private final class OpenFileActionListener
    implements ActionListener {
        private OpenFileActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new JFileChooser().showOpenDialog(DemoFrame.this);
        }
    }

    private final class AboutActionListener
    implements ActionListener {
        private AboutActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(DemoFrame.this, "The simple Looks Demo Application\n\n\u00a9 2001-2009 JGoodies Karsten Lentzsch. All Rights Reserved.\n\n");
        }
    }
}

