/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.caucho.hessian;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;

import mx4j.tools.remote.AbstractJMXConnectorServer;
import mx4j.tools.remote.ConnectionManager;
import mx4j.tools.remote.http.HTTPConnectionManager;
import mx4j.tools.remote.http.HTTPConnectorServer;

/**
 * A JSR 160 implementation of a JMXConnectorServer over Caucho's Hessian protocol
 * (http://www.caucho.com/hessian).
 * <br/>
 * IMPORTANT NOTE: <br/>
 * This JMXConnectorServer is still in experimental status, so compatibility with
 * newer version may broke, especially regarding hessian serialization of JMX classes.
 *
 * @version $Revision: 1.4 $
 * @see mx4j.tools.remote.caucho.burlap.BurlapConnectorServer
 */
public class HessianConnectorServer extends HTTPConnectorServer
{
   public HessianConnectorServer(JMXServiceURL url, Map environment, MBeanServer server)
   {
      super(url, environment, server);
   }

   protected ConnectionManager createConnectionManager(AbstractJMXConnectorServer server, Map environment)
   {
      return new HTTPConnectionManager(server, "hessian", environment);
   }
}
