/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.html.parser.model;

import org.netbeans.modules.html.editor.lib.api.model.NamedCharRef;

/**
 *
 * @author marekfukala
 */
public enum NamedCharacterReference implements NamedCharRef {

    //generated code>>>
    //NOI18N
    AElig("AElig", 0x000C6),
    AMP("AMP", 0x00026),
    Aacute("Aacute", 0x000C1),
    Abreve("Abreve", 0x00102),
    Acirc("Acirc", 0x000C2),
    Acy("Acy", 0x00410),
    Afr("Afr", 0x1D504),
    Agrave("Agrave", 0x000C0),
    Alpha("Alpha", 0x00391),
    Amacr("Amacr", 0x00100),
    And("And", 0x02A53),
    Aogon("Aogon", 0x00104),
    Aopf("Aopf", 0x1D538),
    ApplyFunction("ApplyFunction", 0x02061),
    Aring("Aring", 0x000C5),
    Ascr("Ascr", 0x1D49C),
    Assign("Assign", 0x02254),
    Atilde("Atilde", 0x000C3),
    Auml("Auml", 0x000C4),
    Backslash("Backslash", 0x02216),
    Barv("Barv", 0x02AE7),
    Barwed("Barwed", 0x02306),
    Bcy("Bcy", 0x00411),
    Because("Because", 0x02235),
    Bernoullis("Bernoullis", 0x0212C),
    Beta("Beta", 0x00392),
    Bfr("Bfr", 0x1D505),
    Bopf("Bopf", 0x1D539),
    Breve("Breve", 0x002D8),
    Bscr("Bscr", 0x0212C),
    Bumpeq("Bumpeq", 0x0224E),
    CHcy("CHcy", 0x00427),
    COPY("COPY", 0x000A9),
    Cacute("Cacute", 0x00106),
    Cap("Cap", 0x022D2),
    CapitalDifferentialD("CapitalDifferentialD", 0x02145),
    Cayleys("Cayleys", 0x0212D),
    Ccaron("Ccaron", 0x0010C),
    Ccedil("Ccedil", 0x000C7),
    Ccirc("Ccirc", 0x00108),
    Cconint("Cconint", 0x02230),
    Cdot("Cdot", 0x0010A),
    Cedilla("Cedilla", 0x000B8),
    CenterDot("CenterDot", 0x000B7),
    Cfr("Cfr", 0x0212D),
    Chi("Chi", 0x003A7),
    CircleDot("CircleDot", 0x02299),
    CircleMinus("CircleMinus", 0x02296),
    CirclePlus("CirclePlus", 0x02295),
    CircleTimes("CircleTimes", 0x02297),
    ClockwiseContourIntegral("ClockwiseContourIntegral", 0x02232),
    CloseCurlyDoubleQuote("CloseCurlyDoubleQuote", 0x0201D),
    CloseCurlyQuote("CloseCurlyQuote", 0x02019),
    Colon("Colon", 0x02237),
    Colone("Colone", 0x02A74),
    Congruent("Congruent", 0x02261),
    Conint("Conint", 0x0222F),
    ContourIntegral("ContourIntegral", 0x0222E),
    Copf("Copf", 0x02102),
    Coproduct("Coproduct", 0x02210),
    CounterClockwiseContourIntegral("CounterClockwiseContourIntegral", 0x02233),
    Cross("Cross", 0x02A2F),
    Cscr("Cscr", 0x1D49E),
    Cup("Cup", 0x022D3),
    CupCap("CupCap", 0x0224D),
    DD("DD", 0x02145),
    DDotrahd("DDotrahd", 0x02911),
    DJcy("DJcy", 0x00402),
    DScy("DScy", 0x00405),
    DZcy("DZcy", 0x0040F),
    Dagger("Dagger", 0x02021),
    Darr("Darr", 0x021A1),
    Dashv("Dashv", 0x02AE4),
    Dcaron("Dcaron", 0x0010E),
    Dcy("Dcy", 0x00414),
    Del("Del", 0x02207),
    Delta("Delta", 0x00394),
    Dfr("Dfr", 0x1D507),
    DiacriticalAcute("DiacriticalAcute", 0x000B4),
    DiacriticalDot("DiacriticalDot", 0x002D9),
    DiacriticalDoubleAcute("DiacriticalDoubleAcute", 0x002DD),
    DiacriticalGrave("DiacriticalGrave", 0x00060),
    DiacriticalTilde("DiacriticalTilde", 0x002DC),
    Diamond("Diamond", 0x022C4),
    DifferentialD("DifferentialD", 0x02146),
    Dopf("Dopf", 0x1D53B),
    Dot("Dot", 0x000A8),
    DotDot("DotDot", 0x020DC),
    DotEqual("DotEqual", 0x02250),
    DoubleContourIntegral("DoubleContourIntegral", 0x0222F),
    DoubleDot("DoubleDot", 0x000A8),
    DoubleDownArrow("DoubleDownArrow", 0x021D3),
    DoubleLeftArrow("DoubleLeftArrow", 0x021D0),
    DoubleLeftRightArrow("DoubleLeftRightArrow", 0x021D4),
    DoubleLeftTee("DoubleLeftTee", 0x02AE4),
    DoubleLongLeftArrow("DoubleLongLeftArrow", 0x027F8),
    DoubleLongLeftRightArrow("DoubleLongLeftRightArrow", 0x027FA),
    DoubleLongRightArrow("DoubleLongRightArrow", 0x027F9),
    DoubleRightArrow("DoubleRightArrow", 0x021D2),
    DoubleRightTee("DoubleRightTee", 0x022A8),
    DoubleUpArrow("DoubleUpArrow", 0x021D1),
    DoubleUpDownArrow("DoubleUpDownArrow", 0x021D5),
    DoubleVerticalBar("DoubleVerticalBar", 0x02225),
    DownArrow("DownArrow", 0x02193),
    DownArrowBar("DownArrowBar", 0x02913),
    DownArrowUpArrow("DownArrowUpArrow", 0x021F5),
    DownBreve("DownBreve", 0x00311),
    DownLeftRightVector("DownLeftRightVector", 0x02950),
    DownLeftTeeVector("DownLeftTeeVector", 0x0295E),
    DownLeftVector("DownLeftVector", 0x021BD),
    DownLeftVectorBar("DownLeftVectorBar", 0x02956),
    DownRightTeeVector("DownRightTeeVector", 0x0295F),
    DownRightVector("DownRightVector", 0x021C1),
    DownRightVectorBar("DownRightVectorBar", 0x02957),
    DownTee("DownTee", 0x022A4),
    DownTeeArrow("DownTeeArrow", 0x021A7),
    Downarrow("Downarrow", 0x021D3),
    Dscr("Dscr", 0x1D49F),
    Dstrok("Dstrok", 0x00110),
    ENG("ENG", 0x0014A),
    ETH("ETH", 0x000D0),
    Eacute("Eacute", 0x000C9),
    Ecaron("Ecaron", 0x0011A),
    Ecirc("Ecirc", 0x000CA),
    Ecy("Ecy", 0x0042D),
    Edot("Edot", 0x00116),
    Efr("Efr", 0x1D508),
    Egrave("Egrave", 0x000C8),
    Element("Element", 0x02208),
    Emacr("Emacr", 0x00112),
    EmptySmallSquare("EmptySmallSquare", 0x025FB),
    EmptyVerySmallSquare("EmptyVerySmallSquare", 0x025AB),
    Eogon("Eogon", 0x00118),
    Eopf("Eopf", 0x1D53C),
    Epsilon("Epsilon", 0x00395),
    Equal("Equal", 0x02A75),
    EqualTilde("EqualTilde", 0x02242),
    Equilibrium("Equilibrium", 0x021CC),
    Escr("Escr", 0x02130),
    Esim("Esim", 0x02A73),
    Eta("Eta", 0x00397),
    Euml("Euml", 0x000CB),
    Exists("Exists", 0x02203),
    ExponentialE("ExponentialE", 0x02147),
    Fcy("Fcy", 0x00424),
    Ffr("Ffr", 0x1D509),
    FilledSmallSquare("FilledSmallSquare", 0x025FC),
    FilledVerySmallSquare("FilledVerySmallSquare", 0x025AA),
    Fopf("Fopf", 0x1D53D),
    ForAll("ForAll", 0x02200),
    Fouriertrf("Fouriertrf", 0x02131),
    Fscr("Fscr", 0x02131),
    GJcy("GJcy", 0x00403),
    GT("GT", 0x0003E),
    Gamma("Gamma", 0x00393),
    Gammad("Gammad", 0x003DC),
    Gbreve("Gbreve", 0x0011E),
    Gcedil("Gcedil", 0x00122),
    Gcirc("Gcirc", 0x0011C),
    Gcy("Gcy", 0x00413),
    Gdot("Gdot", 0x00120),
    Gfr("Gfr", 0x1D50A),
    Gg("Gg", 0x022D9),
    Gopf("Gopf", 0x1D53E),
    GreaterEqual("GreaterEqual", 0x02265),
    GreaterEqualLess("GreaterEqualLess", 0x022DB),
    GreaterFullEqual("GreaterFullEqual", 0x02267),
    GreaterGreater("GreaterGreater", 0x02AA2),
    GreaterLess("GreaterLess", 0x02277),
    GreaterSlantEqual("GreaterSlantEqual", 0x02A7E),
    GreaterTilde("GreaterTilde", 0x02273),
    Gscr("Gscr", 0x1D4A2),
    Gt("Gt", 0x0226B),
    HARDcy("HARDcy", 0x0042A),
    Hacek("Hacek", 0x002C7),
    Hat("Hat", 0x0005E),
    Hcirc("Hcirc", 0x00124),
    Hfr("Hfr", 0x0210C),
    HilbertSpace("HilbertSpace", 0x0210B),
    Hopf("Hopf", 0x0210D),
    HorizontalLine("HorizontalLine", 0x02500),
    Hscr("Hscr", 0x0210B),
    Hstrok("Hstrok", 0x00126),
    HumpDownHump("HumpDownHump", 0x0224E),
    HumpEqual("HumpEqual", 0x0224F),
    IEcy("IEcy", 0x00415),
    IJlig("IJlig", 0x00132),
    IOcy("IOcy", 0x00401),
    Iacute("Iacute", 0x000CD),
    Icirc("Icirc", 0x000CE),
    Icy("Icy", 0x00418),
    Idot("Idot", 0x00130),
    Ifr("Ifr", 0x02111),
    Igrave("Igrave", 0x000CC),
    Im("Im", 0x02111),
    Imacr("Imacr", 0x0012A),
    ImaginaryI("ImaginaryI", 0x02148),
    Implies("Implies", 0x021D2),
    Int("Int", 0x0222C),
    Integral("Integral", 0x0222B),
    Intersection("Intersection", 0x022C2),
    InvisibleComma("InvisibleComma", 0x02063),
    InvisibleTimes("InvisibleTimes", 0x02062),
    Iogon("Iogon", 0x0012E),
    Iopf("Iopf", 0x1D540),
    Iota("Iota", 0x00399),
    Iscr("Iscr", 0x02110),
    Itilde("Itilde", 0x00128),
    Iukcy("Iukcy", 0x00406),
    Iuml("Iuml", 0x000CF),
    Jcirc("Jcirc", 0x00134),
    Jcy("Jcy", 0x00419),
    Jfr("Jfr", 0x1D50D),
    Jopf("Jopf", 0x1D541),
    Jscr("Jscr", 0x1D4A5),
    Jsercy("Jsercy", 0x00408),
    Jukcy("Jukcy", 0x00404),
    KHcy("KHcy", 0x00425),
    KJcy("KJcy", 0x0040C),
    Kappa("Kappa", 0x0039A),
    Kcedil("Kcedil", 0x00136),
    Kcy("Kcy", 0x0041A),
    Kfr("Kfr", 0x1D50E),
    Kopf("Kopf", 0x1D542),
    Kscr("Kscr", 0x1D4A6),
    LJcy("LJcy", 0x00409),
    LT("LT", 0x0003C),
    Lacute("Lacute", 0x00139),
    Lambda("Lambda", 0x0039B),
    Lang("Lang", 0x027EA),
    Laplacetrf("Laplacetrf", 0x02112),
    Larr("Larr", 0x0219E),
    Lcaron("Lcaron", 0x0013D),
    Lcedil("Lcedil", 0x0013B),
    Lcy("Lcy", 0x0041B),
    LeftAngleBracket("LeftAngleBracket", 0x027E8),
    LeftArrow("LeftArrow", 0x02190),
    LeftArrowBar("LeftArrowBar", 0x021E4),
    LeftArrowRightArrow("LeftArrowRightArrow", 0x021C6),
    LeftCeiling("LeftCeiling", 0x02308),
    LeftDoubleBracket("LeftDoubleBracket", 0x027E6),
    LeftDownTeeVector("LeftDownTeeVector", 0x02961),
    LeftDownVector("LeftDownVector", 0x021C3),
    LeftDownVectorBar("LeftDownVectorBar", 0x02959),
    LeftFloor("LeftFloor", 0x0230A),
    LeftRightArrow("LeftRightArrow", 0x02194),
    LeftRightVector("LeftRightVector", 0x0294E),
    LeftTee("LeftTee", 0x022A3),
    LeftTeeArrow("LeftTeeArrow", 0x021A4),
    LeftTeeVector("LeftTeeVector", 0x0295A),
    LeftTriangle("LeftTriangle", 0x022B2),
    LeftTriangleBar("LeftTriangleBar", 0x029CF),
    LeftTriangleEqual("LeftTriangleEqual", 0x022B4),
    LeftUpDownVector("LeftUpDownVector", 0x02951),
    LeftUpTeeVector("LeftUpTeeVector", 0x02960),
    LeftUpVector("LeftUpVector", 0x021BF),
    LeftUpVectorBar("LeftUpVectorBar", 0x02958),
    LeftVector("LeftVector", 0x021BC),
    LeftVectorBar("LeftVectorBar", 0x02952),
    Leftarrow("Leftarrow", 0x021D0),
    Leftrightarrow("Leftrightarrow", 0x021D4),
    LessEqualGreater("LessEqualGreater", 0x022DA),
    LessFullEqual("LessFullEqual", 0x02266),
    LessGreater("LessGreater", 0x02276),
    LessLess("LessLess", 0x02AA1),
    LessSlantEqual("LessSlantEqual", 0x02A7D),
    LessTilde("LessTilde", 0x02272),
    Lfr("Lfr", 0x1D50F),
    Ll("Ll", 0x022D8),
    Lleftarrow("Lleftarrow", 0x021DA),
    Lmidot("Lmidot", 0x0013F),
    LongLeftArrow("LongLeftArrow", 0x027F5),
    LongLeftRightArrow("LongLeftRightArrow", 0x027F7),
    LongRightArrow("LongRightArrow", 0x027F6),
    Longleftarrow("Longleftarrow", 0x027F8),
    Longleftrightarrow("Longleftrightarrow", 0x027FA),
    Longrightarrow("Longrightarrow", 0x027F9),
    Lopf("Lopf", 0x1D543),
    LowerLeftArrow("LowerLeftArrow", 0x02199),
    LowerRightArrow("LowerRightArrow", 0x02198),
    Lscr("Lscr", 0x02112),
    Lsh("Lsh", 0x021B0),
    Lstrok("Lstrok", 0x00141),
    Lt("Lt", 0x0226A),
    Map("Map", 0x02905),
    Mcy("Mcy", 0x0041C),
    MediumSpace("MediumSpace", 0x0205F),
    Mellintrf("Mellintrf", 0x02133),
    Mfr("Mfr", 0x1D510),
    MinusPlus("MinusPlus", 0x02213),
    Mopf("Mopf", 0x1D544),
    Mscr("Mscr", 0x02133),
    Mu("Mu", 0x0039C),
    NJcy("NJcy", 0x0040A),
    Nacute("Nacute", 0x00143),
    Ncaron("Ncaron", 0x00147),
    Ncedil("Ncedil", 0x00145),
    Ncy("Ncy", 0x0041D),
    NegativeMediumSpace("NegativeMediumSpace", 0x0200B),
    NegativeThickSpace("NegativeThickSpace", 0x0200B),
    NegativeThinSpace("NegativeThinSpace", 0x0200B),
    NegativeVeryThinSpace("NegativeVeryThinSpace", 0x0200B),
    NestedGreaterGreater("NestedGreaterGreater", 0x0226B),
    NestedLessLess("NestedLessLess", 0x0226A),
    NewLine("NewLine", 0x0000A),
    Nfr("Nfr", 0x1D511),
    NoBreak("NoBreak", 0x02060),
    NonBreakingSpace("NonBreakingSpace", 0x000A0),
    Nopf("Nopf", 0x02115),
    Not("Not", 0x02AEC),
    NotCongruent("NotCongruent", 0x02262),
    NotCupCap("NotCupCap", 0x0226D),
    NotDoubleVerticalBar("NotDoubleVerticalBar", 0x02226),
    NotElement("NotElement", 0x02209),
    NotEqual("NotEqual", 0x02260),
    NotExists("NotExists", 0x02204),
    NotGreater("NotGreater", 0x0226F),
    NotGreaterEqual("NotGreaterEqual", 0x02271),
    NotGreaterLess("NotGreaterLess", 0x02279),
    NotGreaterTilde("NotGreaterTilde", 0x02275),
    NotLeftTriangle("NotLeftTriangle", 0x022EA),
    NotLeftTriangleEqual("NotLeftTriangleEqual", 0x022EC),
    NotLess("NotLess", 0x0226E),
    NotLessEqual("NotLessEqual", 0x02270),
    NotLessGreater("NotLessGreater", 0x02278),
    NotLessTilde("NotLessTilde", 0x02274),
    NotPrecedes("NotPrecedes", 0x02280),
    NotPrecedesSlantEqual("NotPrecedesSlantEqual", 0x022E0),
    NotReverseElement("NotReverseElement", 0x0220C),
    NotRightTriangle("NotRightTriangle", 0x022EB),
    NotRightTriangleEqual("NotRightTriangleEqual", 0x022ED),
    NotSquareSubsetEqual("NotSquareSubsetEqual", 0x022E2),
    NotSquareSupersetEqual("NotSquareSupersetEqual", 0x022E3),
    NotSubsetEqual("NotSubsetEqual", 0x02288),
    NotSucceeds("NotSucceeds", 0x02281),
    NotSucceedsSlantEqual("NotSucceedsSlantEqual", 0x022E1),
    NotSupersetEqual("NotSupersetEqual", 0x02289),
    NotTilde("NotTilde", 0x02241),
    NotTildeEqual("NotTildeEqual", 0x02244),
    NotTildeFullEqual("NotTildeFullEqual", 0x02247),
    NotTildeTilde("NotTildeTilde", 0x02249),
    NotVerticalBar("NotVerticalBar", 0x02224),
    Nscr("Nscr", 0x1D4A9),
    Ntilde("Ntilde", 0x000D1),
    Nu("Nu", 0x0039D),
    OElig("OElig", 0x00152),
    Oacute("Oacute", 0x000D3),
    Ocirc("Ocirc", 0x000D4),
    Ocy("Ocy", 0x0041E),
    Odblac("Odblac", 0x00150),
    Ofr("Ofr", 0x1D512),
    Ograve("Ograve", 0x000D2),
    Omacr("Omacr", 0x0014C),
    Omega("Omega", 0x003A9),
    Omicron("Omicron", 0x0039F),
    Oopf("Oopf", 0x1D546),
    OpenCurlyDoubleQuote("OpenCurlyDoubleQuote", 0x0201C),
    OpenCurlyQuote("OpenCurlyQuote", 0x02018),
    Or("Or", 0x02A54),
    Oscr("Oscr", 0x1D4AA),
    Oslash("Oslash", 0x000D8),
    Otilde("Otilde", 0x000D5),
    Otimes("Otimes", 0x02A37),
    Ouml("Ouml", 0x000D6),
    OverBar("OverBar", 0x0203E),
    OverBrace("OverBrace", 0x023DE),
    OverBracket("OverBracket", 0x023B4),
    OverParenthesis("OverParenthesis", 0x023DC),
    PartialD("PartialD", 0x02202),
    Pcy("Pcy", 0x0041F),
    Pfr("Pfr", 0x1D513),
    Phi("Phi", 0x003A6),
    Pi("Pi", 0x003A0),
    PlusMinus("PlusMinus", 0x000B1),
    Poincareplane("Poincareplane", 0x0210C),
    Popf("Popf", 0x02119),
    Pr("Pr", 0x02ABB),
    Precedes("Precedes", 0x0227A),
    PrecedesEqual("PrecedesEqual", 0x02AAF),
    PrecedesSlantEqual("PrecedesSlantEqual", 0x0227C),
    PrecedesTilde("PrecedesTilde", 0x0227E),
    Prime("Prime", 0x02033),
    Product("Product", 0x0220F),
    Proportion("Proportion", 0x02237),
    Proportional("Proportional", 0x0221D),
    Pscr("Pscr", 0x1D4AB),
    Psi("Psi", 0x003A8),
    QUOT("QUOT", 0x00022),
    Qfr("Qfr", 0x1D514),
    Qopf("Qopf", 0x0211A),
    Qscr("Qscr", 0x1D4AC),
    RBarr("RBarr", 0x02910),
    REG("REG", 0x000AE),
    Racute("Racute", 0x00154),
    Rang("Rang", 0x027EB),
    Rarr("Rarr", 0x021A0),
    Rarrtl("Rarrtl", 0x02916),
    Rcaron("Rcaron", 0x00158),
    Rcedil("Rcedil", 0x00156),
    Rcy("Rcy", 0x00420),
    Re("Re", 0x0211C),
    ReverseElement("ReverseElement", 0x0220B),
    ReverseEquilibrium("ReverseEquilibrium", 0x021CB),
    ReverseUpEquilibrium("ReverseUpEquilibrium", 0x0296F),
    Rfr("Rfr", 0x0211C),
    Rho("Rho", 0x003A1),
    RightAngleBracket("RightAngleBracket", 0x027E9),
    RightArrow("RightArrow", 0x02192),
    RightArrowBar("RightArrowBar", 0x021E5),
    RightArrowLeftArrow("RightArrowLeftArrow", 0x021C4),
    RightCeiling("RightCeiling", 0x02309),
    RightDoubleBracket("RightDoubleBracket", 0x027E7),
    RightDownTeeVector("RightDownTeeVector", 0x0295D),
    RightDownVector("RightDownVector", 0x021C2),
    RightDownVectorBar("RightDownVectorBar", 0x02955),
    RightFloor("RightFloor", 0x0230B),
    RightTee("RightTee", 0x022A2),
    RightTeeArrow("RightTeeArrow", 0x021A6),
    RightTeeVector("RightTeeVector", 0x0295B),
    RightTriangle("RightTriangle", 0x022B3),
    RightTriangleBar("RightTriangleBar", 0x029D0),
    RightTriangleEqual("RightTriangleEqual", 0x022B5),
    RightUpDownVector("RightUpDownVector", 0x0294F),
    RightUpTeeVector("RightUpTeeVector", 0x0295C),
    RightUpVector("RightUpVector", 0x021BE),
    RightUpVectorBar("RightUpVectorBar", 0x02954),
    RightVector("RightVector", 0x021C0),
    RightVectorBar("RightVectorBar", 0x02953),
    Rightarrow("Rightarrow", 0x021D2),
    Ropf("Ropf", 0x0211D),
    RoundImplies("RoundImplies", 0x02970),
    Rrightarrow("Rrightarrow", 0x021DB),
    Rscr("Rscr", 0x0211B),
    Rsh("Rsh", 0x021B1),
    RuleDelayed("RuleDelayed", 0x029F4),
    SHCHcy("SHCHcy", 0x00429),
    SHcy("SHcy", 0x00428),
    SOFTcy("SOFTcy", 0x0042C),
    Sacute("Sacute", 0x0015A),
    Sc("Sc", 0x02ABC),
    Scaron("Scaron", 0x00160),
    Scedil("Scedil", 0x0015E),
    Scirc("Scirc", 0x0015C),
    Scy("Scy", 0x00421),
    Sfr("Sfr", 0x1D516),
    ShortDownArrow("ShortDownArrow", 0x02193),
    ShortLeftArrow("ShortLeftArrow", 0x02190),
    ShortRightArrow("ShortRightArrow", 0x02192),
    ShortUpArrow("ShortUpArrow", 0x02191),
    Sigma("Sigma", 0x003A3),
    SmallCircle("SmallCircle", 0x02218),
    Sopf("Sopf", 0x1D54A),
    Sqrt("Sqrt", 0x0221A),
    Square("Square", 0x025A1),
    SquareIntersection("SquareIntersection", 0x02293),
    SquareSubset("SquareSubset", 0x0228F),
    SquareSubsetEqual("SquareSubsetEqual", 0x02291),
    SquareSuperset("SquareSuperset", 0x02290),
    SquareSupersetEqual("SquareSupersetEqual", 0x02292),
    SquareUnion("SquareUnion", 0x02294),
    Sscr("Sscr", 0x1D4AE),
    Star("Star", 0x022C6),
    Sub("Sub", 0x022D0),
    Subset("Subset", 0x022D0),
    SubsetEqual("SubsetEqual", 0x02286),
    Succeeds("Succeeds", 0x0227B),
    SucceedsEqual("SucceedsEqual", 0x02AB0),
    SucceedsSlantEqual("SucceedsSlantEqual", 0x0227D),
    SucceedsTilde("SucceedsTilde", 0x0227F),
    SuchThat("SuchThat", 0x0220B),
    Sum("Sum", 0x02211),
    Sup("Sup", 0x022D1),
    Superset("Superset", 0x02283),
    SupersetEqual("SupersetEqual", 0x02287),
    Supset("Supset", 0x022D1),
    THORN("THORN", 0x000DE),
    TRADE("TRADE", 0x02122),
    TSHcy("TSHcy", 0x0040B),
    TScy("TScy", 0x00426),
    Tab("Tab", 0x00009),
    Tau("Tau", 0x003A4),
    Tcaron("Tcaron", 0x00164),
    Tcedil("Tcedil", 0x00162),
    Tcy("Tcy", 0x00422),
    Tfr("Tfr", 0x1D517),
    Therefore("Therefore", 0x02234),
    Theta("Theta", 0x00398),
    ThinSpace("ThinSpace", 0x02009),
    Tilde("Tilde", 0x0223C),
    TildeEqual("TildeEqual", 0x02243),
    TildeFullEqual("TildeFullEqual", 0x02245),
    TildeTilde("TildeTilde", 0x02248),
    Topf("Topf", 0x1D54B),
    TripleDot("TripleDot", 0x020DB),
    Tscr("Tscr", 0x1D4AF),
    Tstrok("Tstrok", 0x00166),
    Uacute("Uacute", 0x000DA),
    Uarr("Uarr", 0x0219F),
    Uarrocir("Uarrocir", 0x02949),
    Ubrcy("Ubrcy", 0x0040E),
    Ubreve("Ubreve", 0x0016C),
    Ucirc("Ucirc", 0x000DB),
    Ucy("Ucy", 0x00423),
    Udblac("Udblac", 0x00170),
    Ufr("Ufr", 0x1D518),
    Ugrave("Ugrave", 0x000D9),
    Umacr("Umacr", 0x0016A),
    UnderBar("UnderBar", 0x0005F),
    UnderBrace("UnderBrace", 0x023DF),
    UnderBracket("UnderBracket", 0x023B5),
    UnderParenthesis("UnderParenthesis", 0x023DD),
    Union("Union", 0x022C3),
    UnionPlus("UnionPlus", 0x0228E),
    Uogon("Uogon", 0x00172),
    Uopf("Uopf", 0x1D54C),
    UpArrow("UpArrow", 0x02191),
    UpArrowBar("UpArrowBar", 0x02912),
    UpArrowDownArrow("UpArrowDownArrow", 0x021C5),
    UpDownArrow("UpDownArrow", 0x02195),
    UpEquilibrium("UpEquilibrium", 0x0296E),
    UpTee("UpTee", 0x022A5),
    UpTeeArrow("UpTeeArrow", 0x021A5),
    Uparrow("Uparrow", 0x021D1),
    Updownarrow("Updownarrow", 0x021D5),
    UpperLeftArrow("UpperLeftArrow", 0x02196),
    UpperRightArrow("UpperRightArrow", 0x02197),
    Upsi("Upsi", 0x003D2),
    Upsilon("Upsilon", 0x003A5),
    Uring("Uring", 0x0016E),
    Uscr("Uscr", 0x1D4B0),
    Utilde("Utilde", 0x00168),
    Uuml("Uuml", 0x000DC),
    VDash("VDash", 0x022AB),
    Vbar("Vbar", 0x02AEB),
    Vcy("Vcy", 0x00412),
    Vdash("Vdash", 0x022A9),
    Vdashl("Vdashl", 0x02AE6),
    Vee("Vee", 0x022C1),
    Verbar("Verbar", 0x02016),
    Vert("Vert", 0x02016),
    VerticalBar("VerticalBar", 0x02223),
    VerticalLine("VerticalLine", 0x0007C),
    VerticalSeparator("VerticalSeparator", 0x02758),
    VerticalTilde("VerticalTilde", 0x02240),
    VeryThinSpace("VeryThinSpace", 0x0200A),
    Vfr("Vfr", 0x1D519),
    Vopf("Vopf", 0x1D54D),
    Vscr("Vscr", 0x1D4B1),
    Vvdash("Vvdash", 0x022AA),
    Wcirc("Wcirc", 0x00174),
    Wedge("Wedge", 0x022C0),
    Wfr("Wfr", 0x1D51A),
    Wopf("Wopf", 0x1D54E),
    Wscr("Wscr", 0x1D4B2),
    Xfr("Xfr", 0x1D51B),
    Xi("Xi", 0x0039E),
    Xopf("Xopf", 0x1D54F),
    Xscr("Xscr", 0x1D4B3),
    YAcy("YAcy", 0x0042F),
    YIcy("YIcy", 0x00407),
    YUcy("YUcy", 0x0042E),
    Yacute("Yacute", 0x000DD),
    Ycirc("Ycirc", 0x00176),
    Ycy("Ycy", 0x0042B),
    Yfr("Yfr", 0x1D51C),
    Yopf("Yopf", 0x1D550),
    Yscr("Yscr", 0x1D4B4),
    Yuml("Yuml", 0x00178),
    ZHcy("ZHcy", 0x00416),
    Zacute("Zacute", 0x00179),
    Zcaron("Zcaron", 0x0017D),
    Zcy("Zcy", 0x00417),
    Zdot("Zdot", 0x0017B),
    ZeroWidthSpace("ZeroWidthSpace", 0x0200B),
    Zeta("Zeta", 0x00396),
    Zfr("Zfr", 0x02128),
    Zopf("Zopf", 0x02124),
    Zscr("Zscr", 0x1D4B5),
    aacute("aacute", 0x000E1),
    abreve("abreve", 0x00103),
    ac("ac", 0x0223E),
    acd("acd", 0x0223F),
    acirc("acirc", 0x000E2),
    acute("acute", 0x000B4),
    acy("acy", 0x00430),
    aelig("aelig", 0x000E6),
    af("af", 0x02061),
    afr("afr", 0x1D51E),
    agrave("agrave", 0x000E0),
    alefsym("alefsym", 0x02135),
    aleph("aleph", 0x02135),
    alpha("alpha", 0x003B1),
    amacr("amacr", 0x00101),
    amalg("amalg", 0x02A3F),
    amp("amp", 0x00026),
    and("and", 0x02227),
    andand("andand", 0x02A55),
    andd("andd", 0x02A5C),
    andslope("andslope", 0x02A58),
    andv("andv", 0x02A5A),
    ang("ang", 0x02220),
    ange("ange", 0x029A4),
    angle("angle", 0x02220),
    angmsd("angmsd", 0x02221),
    angmsdaa("angmsdaa", 0x029A8),
    angmsdab("angmsdab", 0x029A9),
    angmsdac("angmsdac", 0x029AA),
    angmsdad("angmsdad", 0x029AB),
    angmsdae("angmsdae", 0x029AC),
    angmsdaf("angmsdaf", 0x029AD),
    angmsdag("angmsdag", 0x029AE),
    angmsdah("angmsdah", 0x029AF),
    angrt("angrt", 0x0221F),
    angrtvb("angrtvb", 0x022BE),
    angrtvbd("angrtvbd", 0x0299D),
    angsph("angsph", 0x02222),
    angst("angst", 0x000C5),
    angzarr("angzarr", 0x0237C),
    aogon("aogon", 0x00105),
    aopf("aopf", 0x1D552),
    ap("ap", 0x02248),
    apE("apE", 0x02A70),
    apacir("apacir", 0x02A6F),
    ape("ape", 0x0224A),
    apid("apid", 0x0224B),
    apos("apos", 0x00027),
    approx("approx", 0x02248),
    approxeq("approxeq", 0x0224A),
    aring("aring", 0x000E5),
    ascr("ascr", 0x1D4B6),
    ast("ast", 0x0002A),
    asymp("asymp", 0x02248),
    asympeq("asympeq", 0x0224D),
    atilde("atilde", 0x000E3),
    auml("auml", 0x000E4),
    awconint("awconint", 0x02233),
    awint("awint", 0x02A11),
    bNot("bNot", 0x02AED),
    backcong("backcong", 0x0224C),
    backepsilon("backepsilon", 0x003F6),
    backprime("backprime", 0x02035),
    backsim("backsim", 0x0223D),
    backsimeq("backsimeq", 0x022CD),
    barvee("barvee", 0x022BD),
    barwed("barwed", 0x02305),
    barwedge("barwedge", 0x02305),
    bbrk("bbrk", 0x023B5),
    bbrktbrk("bbrktbrk", 0x023B6),
    bcong("bcong", 0x0224C),
    bcy("bcy", 0x00431),
    bdquo("bdquo", 0x0201E),
    becaus("becaus", 0x02235),
    because("because", 0x02235),
    bemptyv("bemptyv", 0x029B0),
    bepsi("bepsi", 0x003F6),
    bernou("bernou", 0x0212C),
    beta("beta", 0x003B2),
    beth("beth", 0x02136),
    between("between", 0x0226C),
    bfr("bfr", 0x1D51F),
    bigcap("bigcap", 0x022C2),
    bigcirc("bigcirc", 0x025EF),
    bigcup("bigcup", 0x022C3),
    bigodot("bigodot", 0x02A00),
    bigoplus("bigoplus", 0x02A01),
    bigotimes("bigotimes", 0x02A02),
    bigsqcup("bigsqcup", 0x02A06),
    bigstar("bigstar", 0x02605),
    bigtriangledown("bigtriangledown", 0x025BD),
    bigtriangleup("bigtriangleup", 0x025B3),
    biguplus("biguplus", 0x02A04),
    bigvee("bigvee", 0x022C1),
    bigwedge("bigwedge", 0x022C0),
    bkarow("bkarow", 0x0290D),
    blacklozenge("blacklozenge", 0x029EB),
    blacksquare("blacksquare", 0x025AA),
    blacktriangle("blacktriangle", 0x025B4),
    blacktriangledown("blacktriangledown", 0x025BE),
    blacktriangleleft("blacktriangleleft", 0x025C2),
    blacktriangleright("blacktriangleright", 0x025B8),
    blank("blank", 0x02423),
    blk12("blk12", 0x02592),
    blk14("blk14", 0x02591),
    blk34("blk34", 0x02593),
    block("block", 0x02588),
    bnot("bnot", 0x02310),
    bopf("bopf", 0x1D553),
    bot("bot", 0x022A5),
    bottom("bottom", 0x022A5),
    bowtie("bowtie", 0x022C8),
    boxDL("boxDL", 0x02557),
    boxDR("boxDR", 0x02554),
    boxDl("boxDl", 0x02556),
    boxDr("boxDr", 0x02553),
    boxH("boxH", 0x02550),
    boxHD("boxHD", 0x02566),
    boxHU("boxHU", 0x02569),
    boxHd("boxHd", 0x02564),
    boxHu("boxHu", 0x02567),
    boxUL("boxUL", 0x0255D),
    boxUR("boxUR", 0x0255A),
    boxUl("boxUl", 0x0255C),
    boxUr("boxUr", 0x02559),
    boxV("boxV", 0x02551),
    boxVH("boxVH", 0x0256C),
    boxVL("boxVL", 0x02563),
    boxVR("boxVR", 0x02560),
    boxVh("boxVh", 0x0256B),
    boxVl("boxVl", 0x02562),
    boxVr("boxVr", 0x0255F),
    boxbox("boxbox", 0x029C9),
    boxdL("boxdL", 0x02555),
    boxdR("boxdR", 0x02552),
    boxdl("boxdl", 0x02510),
    boxdr("boxdr", 0x0250C),
    boxh("boxh", 0x02500),
    boxhD("boxhD", 0x02565),
    boxhU("boxhU", 0x02568),
    boxhd("boxhd", 0x0252C),
    boxhu("boxhu", 0x02534),
    boxminus("boxminus", 0x0229F),
    boxplus("boxplus", 0x0229E),
    boxtimes("boxtimes", 0x022A0),
    boxuL("boxuL", 0x0255B),
    boxuR("boxuR", 0x02558),
    boxul("boxul", 0x02518),
    boxur("boxur", 0x02514),
    boxv("boxv", 0x02502),
    boxvH("boxvH", 0x0256A),
    boxvL("boxvL", 0x02561),
    boxvR("boxvR", 0x0255E),
    boxvh("boxvh", 0x0253C),
    boxvl("boxvl", 0x02524),
    boxvr("boxvr", 0x0251C),
    bprime("bprime", 0x02035),
    breve("breve", 0x002D8),
    brvbar("brvbar", 0x000A6),
    bscr("bscr", 0x1D4B7),
    bsemi("bsemi", 0x0204F),
    bsim("bsim", 0x0223D),
    bsime("bsime", 0x022CD),
    bsol("bsol", 0x0005C),
    bsolb("bsolb", 0x029C5),
    bsolhsub("bsolhsub", 0x027C8),
    bull("bull", 0x02022),
    bullet("bullet", 0x02022),
    bump("bump", 0x0224E),
    bumpE("bumpE", 0x02AAE),
    bumpe("bumpe", 0x0224F),
    bumpeq("bumpeq", 0x0224F),
    cacute("cacute", 0x00107),
    cap("cap", 0x02229),
    capand("capand", 0x02A44),
    capbrcup("capbrcup", 0x02A49),
    capcap("capcap", 0x02A4B),
    capcup("capcup", 0x02A47),
    capdot("capdot", 0x02A40),
    caret("caret", 0x02041),
    caron("caron", 0x002C7),
    ccaps("ccaps", 0x02A4D),
    ccaron("ccaron", 0x0010D),
    ccedil("ccedil", 0x000E7),
    ccirc("ccirc", 0x00109),
    ccups("ccups", 0x02A4C),
    ccupssm("ccupssm", 0x02A50),
    cdot("cdot", 0x0010B),
    cedil("cedil", 0x000B8),
    cemptyv("cemptyv", 0x029B2),
    cent("cent", 0x000A2),
    centerdot("centerdot", 0x000B7),
    cfr("cfr", 0x1D520),
    chcy("chcy", 0x00447),
    check("check", 0x02713),
    checkmark("checkmark", 0x02713),
    chi("chi", 0x003C7),
    cir("cir", 0x025CB),
    cirE("cirE", 0x029C3),
    circ("circ", 0x002C6),
    circeq("circeq", 0x02257),
    circlearrowleft("circlearrowleft", 0x021BA),
    circlearrowright("circlearrowright", 0x021BB),
    circledR("circledR", 0x000AE),
    circledS("circledS", 0x024C8),
    circledast("circledast", 0x0229B),
    circledcirc("circledcirc", 0x0229A),
    circleddash("circleddash", 0x0229D),
    cire("cire", 0x02257),
    cirfnint("cirfnint", 0x02A10),
    cirmid("cirmid", 0x02AEF),
    cirscir("cirscir", 0x029C2),
    clubs("clubs", 0x02663),
    clubsuit("clubsuit", 0x02663),
    colon("colon", 0x0003A),
    colone("colone", 0x02254),
    coloneq("coloneq", 0x02254),
    comma("comma", 0x0002C),
    commat("commat", 0x00040),
    comp("comp", 0x02201),
    compfn("compfn", 0x02218),
    complement("complement", 0x02201),
    complexes("complexes", 0x02102),
    cong("cong", 0x02245),
    congdot("congdot", 0x02A6D),
    conint("conint", 0x0222E),
    copf("copf", 0x1D554),
    coprod("coprod", 0x02210),
    copy("copy", 0x000A9),
    copysr("copysr", 0x02117),
    crarr("crarr", 0x021B5),
    cross("cross", 0x02717),
    cscr("cscr", 0x1D4B8),
    csub("csub", 0x02ACF),
    csube("csube", 0x02AD1),
    csup("csup", 0x02AD0),
    csupe("csupe", 0x02AD2),
    ctdot("ctdot", 0x022EF),
    cudarrl("cudarrl", 0x02938),
    cudarrr("cudarrr", 0x02935),
    cuepr("cuepr", 0x022DE),
    cuesc("cuesc", 0x022DF),
    cularr("cularr", 0x021B6),
    cularrp("cularrp", 0x0293D),
    cup("cup", 0x0222A),
    cupbrcap("cupbrcap", 0x02A48),
    cupcap("cupcap", 0x02A46),
    cupcup("cupcup", 0x02A4A),
    cupdot("cupdot", 0x0228D),
    cupor("cupor", 0x02A45),
    curarr("curarr", 0x021B7),
    curarrm("curarrm", 0x0293C),
    curlyeqprec("curlyeqprec", 0x022DE),
    curlyeqsucc("curlyeqsucc", 0x022DF),
    curlyvee("curlyvee", 0x022CE),
    curlywedge("curlywedge", 0x022CF),
    curren("curren", 0x000A4),
    curvearrowleft("curvearrowleft", 0x021B6),
    curvearrowright("curvearrowright", 0x021B7),
    cuvee("cuvee", 0x022CE),
    cuwed("cuwed", 0x022CF),
    cwconint("cwconint", 0x02232),
    cwint("cwint", 0x02231),
    cylcty("cylcty", 0x0232D),
    dArr("dArr", 0x021D3),
    dHar("dHar", 0x02965),
    dagger("dagger", 0x02020),
    daleth("daleth", 0x02138),
    darr("darr", 0x02193),
    dash("dash", 0x02010),
    dashv("dashv", 0x022A3),
    dbkarow("dbkarow", 0x0290F),
    dblac("dblac", 0x002DD),
    dcaron("dcaron", 0x0010F),
    dcy("dcy", 0x00434),
    dd("dd", 0x02146),
    ddagger("ddagger", 0x02021),
    ddarr("ddarr", 0x021CA),
    ddotseq("ddotseq", 0x02A77),
    deg("deg", 0x000B0),
    delta("delta", 0x003B4),
    demptyv("demptyv", 0x029B1),
    dfisht("dfisht", 0x0297F),
    dfr("dfr", 0x1D521),
    dharl("dharl", 0x021C3),
    dharr("dharr", 0x021C2),
    diam("diam", 0x022C4),
    diamond("diamond", 0x022C4),
    diamondsuit("diamondsuit", 0x02666),
    diams("diams", 0x02666),
    die("die", 0x000A8),
    digamma("digamma", 0x003DD),
    disin("disin", 0x022F2),
    div("div", 0x000F7),
    divide("divide", 0x000F7),
    divideontimes("divideontimes", 0x022C7),
    divonx("divonx", 0x022C7),
    djcy("djcy", 0x00452),
    dlcorn("dlcorn", 0x0231E),
    dlcrop("dlcrop", 0x0230D),
    dollar("dollar", 0x00024),
    dopf("dopf", 0x1D555),
    dot("dot", 0x002D9),
    doteq("doteq", 0x02250),
    doteqdot("doteqdot", 0x02251),
    dotminus("dotminus", 0x02238),
    dotplus("dotplus", 0x02214),
    dotsquare("dotsquare", 0x022A1),
    doublebarwedge("doublebarwedge", 0x02306),
    downarrow("downarrow", 0x02193),
    downdownarrows("downdownarrows", 0x021CA),
    downharpoonleft("downharpoonleft", 0x021C3),
    downharpoonright("downharpoonright", 0x021C2),
    drbkarow("drbkarow", 0x02910),
    drcorn("drcorn", 0x0231F),
    drcrop("drcrop", 0x0230C),
    dscr("dscr", 0x1D4B9),
    dscy("dscy", 0x00455),
    dsol("dsol", 0x029F6),
    dstrok("dstrok", 0x00111),
    dtdot("dtdot", 0x022F1),
    dtri("dtri", 0x025BF),
    dtrif("dtrif", 0x025BE),
    duarr("duarr", 0x021F5),
    duhar("duhar", 0x0296F),
    dwangle("dwangle", 0x029A6),
    dzcy("dzcy", 0x0045F),
    dzigrarr("dzigrarr", 0x027FF),
    eDDot("eDDot", 0x02A77),
    eDot("eDot", 0x02251),
    eacute("eacute", 0x000E9),
    easter("easter", 0x02A6E),
    ecaron("ecaron", 0x0011B),
    ecir("ecir", 0x02256),
    ecirc("ecirc", 0x000EA),
    ecolon("ecolon", 0x02255),
    ecy("ecy", 0x0044D),
    edot("edot", 0x00117),
    ee("ee", 0x02147),
    efDot("efDot", 0x02252),
    efr("efr", 0x1D522),
    eg("eg", 0x02A9A),
    egrave("egrave", 0x000E8),
    egs("egs", 0x02A96),
    egsdot("egsdot", 0x02A98),
    el("el", 0x02A99),
    elinters("elinters", 0x023E7),
    ell("ell", 0x02113),
    els("els", 0x02A95),
    elsdot("elsdot", 0x02A97),
    emacr("emacr", 0x00113),
    empty("empty", 0x02205),
    emptyset("emptyset", 0x02205),
    emptyv("emptyv", 0x02205),
    emsp13("emsp13", 0x02004),
    emsp14("emsp14", 0x02005),
    emsp("emsp", 0x02003),
    eng("eng", 0x0014B),
    ensp("ensp", 0x02002),
    eogon("eogon", 0x00119),
    eopf("eopf", 0x1D556),
    epar("epar", 0x022D5),
    eparsl("eparsl", 0x029E3),
    eplus("eplus", 0x02A71),
    epsi("epsi", 0x003B5),
    epsilon("epsilon", 0x003B5),
    epsiv("epsiv", 0x003F5),
    eqcirc("eqcirc", 0x02256),
    eqcolon("eqcolon", 0x02255),
    eqsim("eqsim", 0x02242),
    eqslantgtr("eqslantgtr", 0x02A96),
    eqslantless("eqslantless", 0x02A95),
    equals("equals", 0x0003D),
    equest("equest", 0x0225F),
    equiv("equiv", 0x02261),
    equivDD("equivDD", 0x02A78),
    eqvparsl("eqvparsl", 0x029E5),
    erDot("erDot", 0x02253),
    erarr("erarr", 0x02971),
    escr("escr", 0x0212F),
    esdot("esdot", 0x02250),
    esim("esim", 0x02242),
    eta("eta", 0x003B7),
    eth("eth", 0x000F0),
    euml("euml", 0x000EB),
    euro("euro", 0x020AC),
    excl("excl", 0x00021),
    exist("exist", 0x02203),
    expectation("expectation", 0x02130),
    exponentiale("exponentiale", 0x02147),
    fallingdotseq("fallingdotseq", 0x02252),
    fcy("fcy", 0x00444),
    female("female", 0x02640),
    ffilig("ffilig", 0x0FB03),
    fflig("fflig", 0x0FB00),
    ffllig("ffllig", 0x0FB04),
    ffr("ffr", 0x1D523),
    filig("filig", 0x0FB01),
    flat("flat", 0x0266D),
    fllig("fllig", 0x0FB02),
    fltns("fltns", 0x025B1),
    fnof("fnof", 0x00192),
    fopf("fopf", 0x1D557),
    forall("forall", 0x02200),
    fork("fork", 0x022D4),
    forkv("forkv", 0x02AD9),
    fpartint("fpartint", 0x02A0D),
    frac12("frac12", 0x000BD),
    frac13("frac13", 0x02153),
    frac14("frac14", 0x000BC),
    frac15("frac15", 0x02155),
    frac16("frac16", 0x02159),
    frac18("frac18", 0x0215B),
    frac23("frac23", 0x02154),
    frac25("frac25", 0x02156),
    frac34("frac34", 0x000BE),
    frac35("frac35", 0x02157),
    frac38("frac38", 0x0215C),
    frac45("frac45", 0x02158),
    frac56("frac56", 0x0215A),
    frac58("frac58", 0x0215D),
    frac78("frac78", 0x0215E),
    frasl("frasl", 0x02044),
    frown("frown", 0x02322),
    fscr("fscr", 0x1D4BB),
    gE("gE", 0x02267),
    gEl("gEl", 0x02A8C),
    gacute("gacute", 0x001F5),
    gamma("gamma", 0x003B3),
    gammad("gammad", 0x003DD),
    gap("gap", 0x02A86),
    gbreve("gbreve", 0x0011F),
    gcirc("gcirc", 0x0011D),
    gcy("gcy", 0x00433),
    gdot("gdot", 0x00121),
    ge("ge", 0x02265),
    gel("gel", 0x022DB),
    geq("geq", 0x02265),
    geqq("geqq", 0x02267),
    geqslant("geqslant", 0x02A7E),
    ges("ges", 0x02A7E),
    gescc("gescc", 0x02AA9),
    gesdot("gesdot", 0x02A80),
    gesdoto("gesdoto", 0x02A82),
    gesdotol("gesdotol", 0x02A84),
    gesles("gesles", 0x02A94),
    gfr("gfr", 0x1D524),
    gg("gg", 0x0226B),
    ggg("ggg", 0x022D9),
    gimel("gimel", 0x02137),
    gjcy("gjcy", 0x00453),
    gl("gl", 0x02277),
    glE("glE", 0x02A92),
    gla("gla", 0x02AA5),
    glj("glj", 0x02AA4),
    gnE("gnE", 0x02269),
    gnap("gnap", 0x02A8A),
    gnapprox("gnapprox", 0x02A8A),
    gne("gne", 0x02A88),
    gneq("gneq", 0x02A88),
    gneqq("gneqq", 0x02269),
    gnsim("gnsim", 0x022E7),
    gopf("gopf", 0x1D558),
    grave("grave", 0x00060),
    gscr("gscr", 0x0210A),
    gsim("gsim", 0x02273),
    gsime("gsime", 0x02A8E),
    gsiml("gsiml", 0x02A90),
    gt("gt", 0x0003E),
    gtcc("gtcc", 0x02AA7),
    gtcir("gtcir", 0x02A7A),
    gtdot("gtdot", 0x022D7),
    gtlPar("gtlPar", 0x02995),
    gtquest("gtquest", 0x02A7C),
    gtrapprox("gtrapprox", 0x02A86),
    gtrarr("gtrarr", 0x02978),
    gtrdot("gtrdot", 0x022D7),
    gtreqless("gtreqless", 0x022DB),
    gtreqqless("gtreqqless", 0x02A8C),
    gtrless("gtrless", 0x02277),
    gtrsim("gtrsim", 0x02273),
    hArr("hArr", 0x021D4),
    hairsp("hairsp", 0x0200A),
    half("half", 0x000BD),
    hamilt("hamilt", 0x0210B),
    hardcy("hardcy", 0x0044A),
    harr("harr", 0x02194),
    harrcir("harrcir", 0x02948),
    harrw("harrw", 0x021AD),
    hbar("hbar", 0x0210F),
    hcirc("hcirc", 0x00125),
    hearts("hearts", 0x02665),
    heartsuit("heartsuit", 0x02665),
    hellip("hellip", 0x02026),
    hercon("hercon", 0x022B9),
    hfr("hfr", 0x1D525),
    hksearow("hksearow", 0x02925),
    hkswarow("hkswarow", 0x02926),
    hoarr("hoarr", 0x021FF),
    homtht("homtht", 0x0223B),
    hookleftarrow("hookleftarrow", 0x021A9),
    hookrightarrow("hookrightarrow", 0x021AA),
    hopf("hopf", 0x1D559),
    horbar("horbar", 0x02015),
    hscr("hscr", 0x1D4BD),
    hslash("hslash", 0x0210F),
    hstrok("hstrok", 0x00127),
    hybull("hybull", 0x02043),
    hyphen("hyphen", 0x02010),
    iacute("iacute", 0x000ED),
    ic("ic", 0x02063),
    icirc("icirc", 0x000EE),
    icy("icy", 0x00438),
    iecy("iecy", 0x00435),
    iexcl("iexcl", 0x000A1),
    iff("iff", 0x021D4),
    ifr("ifr", 0x1D526),
    igrave("igrave", 0x000EC),
    ii("ii", 0x02148),
    iiiint("iiiint", 0x02A0C),
    iiint("iiint", 0x0222D),
    iinfin("iinfin", 0x029DC),
    iiota("iiota", 0x02129),
    ijlig("ijlig", 0x00133),
    imacr("imacr", 0x0012B),
    image("image", 0x02111),
    imagline("imagline", 0x02110),
    imagpart("imagpart", 0x02111),
    imath("imath", 0x00131),
    imof("imof", 0x022B7),
    imped("imped", 0x001B5),
    in("in", 0x02208),
    incare("incare", 0x02105),
    infin("infin", 0x0221E),
    infintie("infintie", 0x029DD),
    inodot("inodot", 0x00131),
    INT("int", 0x0222B),
    intcal("intcal", 0x022BA),
    integers("integers", 0x02124),
    intercal("intercal", 0x022BA),
    intlarhk("intlarhk", 0x02A17),
    intprod("intprod", 0x02A3C),
    iocy("iocy", 0x00451),
    iogon("iogon", 0x0012F),
    iopf("iopf", 0x1D55A),
    iota("iota", 0x003B9),
    iprod("iprod", 0x02A3C),
    iquest("iquest", 0x000BF),
    iscr("iscr", 0x1D4BE),
    isin("isin", 0x02208),
    isinE("isinE", 0x022F9),
    isindot("isindot", 0x022F5),
    isins("isins", 0x022F4),
    isinsv("isinsv", 0x022F3),
    isinv("isinv", 0x02208),
    it("it", 0x02062),
    itilde("itilde", 0x00129),
    iukcy("iukcy", 0x00456),
    iuml("iuml", 0x000EF),
    jcirc("jcirc", 0x00135),
    jcy("jcy", 0x00439),
    jfr("jfr", 0x1D527),
    jmath("jmath", 0x00237),
    jopf("jopf", 0x1D55B),
    jscr("jscr", 0x1D4BF),
    jsercy("jsercy", 0x00458),
    jukcy("jukcy", 0x00454),
    kappa("kappa", 0x003BA),
    kappav("kappav", 0x003F0),
    kcedil("kcedil", 0x00137),
    kcy("kcy", 0x0043A),
    kfr("kfr", 0x1D528),
    kgreen("kgreen", 0x00138),
    khcy("khcy", 0x00445),
    kjcy("kjcy", 0x0045C),
    kopf("kopf", 0x1D55C),
    kscr("kscr", 0x1D4C0),
    lAarr("lAarr", 0x021DA),
    lArr("lArr", 0x021D0),
    lAtail("lAtail", 0x0291B),
    lBarr("lBarr", 0x0290E),
    lE("lE", 0x02266),
    lEg("lEg", 0x02A8B),
    lHar("lHar", 0x02962),
    lacute("lacute", 0x0013A),
    laemptyv("laemptyv", 0x029B4),
    lagran("lagran", 0x02112),
    lambda("lambda", 0x003BB),
    lang("lang", 0x027E8),
    langd("langd", 0x02991),
    langle("langle", 0x027E8),
    lap("lap", 0x02A85),
    laquo("laquo", 0x000AB),
    larr("larr", 0x02190),
    larrb("larrb", 0x021E4),
    larrbfs("larrbfs", 0x0291F),
    larrfs("larrfs", 0x0291D),
    larrhk("larrhk", 0x021A9),
    larrlp("larrlp", 0x021AB),
    larrpl("larrpl", 0x02939),
    larrsim("larrsim", 0x02973),
    larrtl("larrtl", 0x021A2),
    lat("lat", 0x02AAB),
    latail("latail", 0x02919),
    late("late", 0x02AAD),
    lbarr("lbarr", 0x0290C),
    lbbrk("lbbrk", 0x02772),
    lbrace("lbrace", 0x0007B),
    lbrack("lbrack", 0x0005B),
    lbrke("lbrke", 0x0298B),
    lbrksld("lbrksld", 0x0298F),
    lbrkslu("lbrkslu", 0x0298D),
    lcaron("lcaron", 0x0013E),
    lcedil("lcedil", 0x0013C),
    lceil("lceil", 0x02308),
    lcub("lcub", 0x0007B),
    lcy("lcy", 0x0043B),
    ldca("ldca", 0x02936),
    ldquo("ldquo", 0x0201C),
    ldquor("ldquor", 0x0201E),
    ldrdhar("ldrdhar", 0x02967),
    ldrushar("ldrushar", 0x0294B),
    ldsh("ldsh", 0x021B2),
    le("le", 0x02264),
    leftarrow("leftarrow", 0x02190),
    leftarrowtail("leftarrowtail", 0x021A2),
    leftharpoondown("leftharpoondown", 0x021BD),
    leftharpoonup("leftharpoonup", 0x021BC),
    leftleftarrows("leftleftarrows", 0x021C7),
    leftrightarrow("leftrightarrow", 0x02194),
    leftrightarrows("leftrightarrows", 0x021C6),
    leftrightharpoons("leftrightharpoons", 0x021CB),
    leftrightsquigarrow("leftrightsquigarrow", 0x021AD),
    leftthreetimes("leftthreetimes", 0x022CB),
    leg("leg", 0x022DA),
    leq("leq", 0x02264),
    leqq("leqq", 0x02266),
    leqslant("leqslant", 0x02A7D),
    les("les", 0x02A7D),
    lescc("lescc", 0x02AA8),
    lesdot("lesdot", 0x02A7F),
    lesdoto("lesdoto", 0x02A81),
    lesdotor("lesdotor", 0x02A83),
    lesges("lesges", 0x02A93),
    lessapprox("lessapprox", 0x02A85),
    lessdot("lessdot", 0x022D6),
    lesseqgtr("lesseqgtr", 0x022DA),
    lesseqqgtr("lesseqqgtr", 0x02A8B),
    lessgtr("lessgtr", 0x02276),
    lesssim("lesssim", 0x02272),
    lfisht("lfisht", 0x0297C),
    lfloor("lfloor", 0x0230A),
    lfr("lfr", 0x1D529),
    lg("lg", 0x02276),
    lgE("lgE", 0x02A91),
    lhard("lhard", 0x021BD),
    lharu("lharu", 0x021BC),
    lharul("lharul", 0x0296A),
    lhblk("lhblk", 0x02584),
    ljcy("ljcy", 0x00459),
    ll("ll", 0x0226A),
    llarr("llarr", 0x021C7),
    llcorner("llcorner", 0x0231E),
    llhard("llhard", 0x0296B),
    lltri("lltri", 0x025FA),
    lmidot("lmidot", 0x00140),
    lmoust("lmoust", 0x023B0),
    lmoustache("lmoustache", 0x023B0),
    lnE("lnE", 0x02268),
    lnap("lnap", 0x02A89),
    lnapprox("lnapprox", 0x02A89),
    lne("lne", 0x02A87),
    lneq("lneq", 0x02A87),
    lneqq("lneqq", 0x02268),
    lnsim("lnsim", 0x022E6),
    loang("loang", 0x027EC),
    loarr("loarr", 0x021FD),
    lobrk("lobrk", 0x027E6),
    longleftarrow("longleftarrow", 0x027F5),
    longleftrightarrow("longleftrightarrow", 0x027F7),
    longmapsto("longmapsto", 0x027FC),
    longrightarrow("longrightarrow", 0x027F6),
    looparrowleft("looparrowleft", 0x021AB),
    looparrowright("looparrowright", 0x021AC),
    lopar("lopar", 0x02985),
    lopf("lopf", 0x1D55D),
    loplus("loplus", 0x02A2D),
    lotimes("lotimes", 0x02A34),
    lowast("lowast", 0x02217),
    lowbar("lowbar", 0x0005F),
    loz("loz", 0x025CA),
    lozenge("lozenge", 0x025CA),
    lozf("lozf", 0x029EB),
    lpar("lpar", 0x00028),
    lparlt("lparlt", 0x02993),
    lrarr("lrarr", 0x021C6),
    lrcorner("lrcorner", 0x0231F),
    lrhar("lrhar", 0x021CB),
    lrhard("lrhard", 0x0296D),
    lrm("lrm", 0x0200E),
    lrtri("lrtri", 0x022BF),
    lsaquo("lsaquo", 0x02039),
    lscr("lscr", 0x1D4C1),
    lsh("lsh", 0x021B0),
    lsim("lsim", 0x02272),
    lsime("lsime", 0x02A8D),
    lsimg("lsimg", 0x02A8F),
    lsqb("lsqb", 0x0005B),
    lsquo("lsquo", 0x02018),
    lsquor("lsquor", 0x0201A),
    lstrok("lstrok", 0x00142),
    lt("lt", 0x0003C),
    ltcc("ltcc", 0x02AA6),
    ltcir("ltcir", 0x02A79),
    ltdot("ltdot", 0x022D6),
    lthree("lthree", 0x022CB),
    ltimes("ltimes", 0x022C9),
    ltlarr("ltlarr", 0x02976),
    ltquest("ltquest", 0x02A7B),
    ltrPar("ltrPar", 0x02996),
    ltri("ltri", 0x025C3),
    ltrie("ltrie", 0x022B4),
    ltrif("ltrif", 0x025C2),
    lurdshar("lurdshar", 0x0294A),
    luruhar("luruhar", 0x02966),
    mDDot("mDDot", 0x0223A),
    macr("macr", 0x000AF),
    male("male", 0x02642),
    malt("malt", 0x02720),
    maltese("maltese", 0x02720),
    map("map", 0x021A6),
    mapsto("mapsto", 0x021A6),
    mapstodown("mapstodown", 0x021A7),
    mapstoleft("mapstoleft", 0x021A4),
    mapstoup("mapstoup", 0x021A5),
    marker("marker", 0x025AE),
    mcomma("mcomma", 0x02A29),
    mcy("mcy", 0x0043C),
    mdash("mdash", 0x02014),
    measuredangle("measuredangle", 0x02221),
    mfr("mfr", 0x1D52A),
    mho("mho", 0x02127),
    micro("micro", 0x000B5),
    mid("mid", 0x02223),
    midast("midast", 0x0002A),
    midcir("midcir", 0x02AF0),
    middot("middot", 0x000B7),
    minus("minus", 0x02212),
    minusb("minusb", 0x0229F),
    minusd("minusd", 0x02238),
    minusdu("minusdu", 0x02A2A),
    mlcp("mlcp", 0x02ADB),
    mldr("mldr", 0x02026),
    mnplus("mnplus", 0x02213),
    models("models", 0x022A7),
    mopf("mopf", 0x1D55E),
    mp("mp", 0x02213),
    mscr("mscr", 0x1D4C2),
    mstpos("mstpos", 0x0223E),
    mu("mu", 0x003BC),
    multimap("multimap", 0x022B8),
    mumap("mumap", 0x022B8),
    nLeftarrow("nLeftarrow", 0x021CD),
    nLeftrightarrow("nLeftrightarrow", 0x021CE),
    nRightarrow("nRightarrow", 0x021CF),
    nVDash("nVDash", 0x022AF),
    nVdash("nVdash", 0x022AE),
    nabla("nabla", 0x02207),
    nacute("nacute", 0x00144),
    nap("nap", 0x02249),
    napos("napos", 0x00149),
    napprox("napprox", 0x02249),
    natur("natur", 0x0266E),
    natural("natural", 0x0266E),
    naturals("naturals", 0x02115),
    nbsp("nbsp", 0x000A0),
    ncap("ncap", 0x02A43),
    ncaron("ncaron", 0x00148),
    ncedil("ncedil", 0x00146),
    ncong("ncong", 0x02247),
    ncup("ncup", 0x02A42),
    ncy("ncy", 0x0043D),
    ndash("ndash", 0x02013),
    ne("ne", 0x02260),
    neArr("neArr", 0x021D7),
    nearhk("nearhk", 0x02924),
    nearr("nearr", 0x02197),
    nearrow("nearrow", 0x02197),
    nequiv("nequiv", 0x02262),
    nesear("nesear", 0x02928),
    nexist("nexist", 0x02204),
    nexists("nexists", 0x02204),
    nfr("nfr", 0x1D52B),
    nge("nge", 0x02271),
    ngeq("ngeq", 0x02271),
    ngsim("ngsim", 0x02275),
    ngt("ngt", 0x0226F),
    ngtr("ngtr", 0x0226F),
    nhArr("nhArr", 0x021CE),
    nharr("nharr", 0x021AE),
    nhpar("nhpar", 0x02AF2),
    ni("ni", 0x0220B),
    nis("nis", 0x022FC),
    nisd("nisd", 0x022FA),
    niv("niv", 0x0220B),
    njcy("njcy", 0x0045A),
    nlArr("nlArr", 0x021CD),
    nlarr("nlarr", 0x0219A),
    nldr("nldr", 0x02025),
    nle("nle", 0x02270),
    nleftarrow("nleftarrow", 0x0219A),
    nleftrightarrow("nleftrightarrow", 0x021AE),
    nleq("nleq", 0x02270),
    nless("nless", 0x0226E),
    nlsim("nlsim", 0x02274),
    nlt("nlt", 0x0226E),
    nltri("nltri", 0x022EA),
    nltrie("nltrie", 0x022EC),
    nmid("nmid", 0x02224),
    nopf("nopf", 0x1D55F),
    not("not", 0x000AC),
    notin("notin", 0x02209),
    notinva("notinva", 0x02209),
    notinvb("notinvb", 0x022F7),
    notinvc("notinvc", 0x022F6),
    notni("notni", 0x0220C),
    notniva("notniva", 0x0220C),
    notnivb("notnivb", 0x022FE),
    notnivc("notnivc", 0x022FD),
    npar("npar", 0x02226),
    nparallel("nparallel", 0x02226),
    npolint("npolint", 0x02A14),
    npr("npr", 0x02280),
    nprcue("nprcue", 0x022E0),
    nprec("nprec", 0x02280),
    nrArr("nrArr", 0x021CF),
    nrarr("nrarr", 0x0219B),
    nrightarrow("nrightarrow", 0x0219B),
    nrtri("nrtri", 0x022EB),
    nrtrie("nrtrie", 0x022ED),
    nsc("nsc", 0x02281),
    nsccue("nsccue", 0x022E1),
    nscr("nscr", 0x1D4C3),
    nshortmid("nshortmid", 0x02224),
    nshortparallel("nshortparallel", 0x02226),
    nsim("nsim", 0x02241),
    nsime("nsime", 0x02244),
    nsimeq("nsimeq", 0x02244),
    nsmid("nsmid", 0x02224),
    nspar("nspar", 0x02226),
    nsqsube("nsqsube", 0x022E2),
    nsqsupe("nsqsupe", 0x022E3),
    nsub("nsub", 0x02284),
    nsube("nsube", 0x02288),
    nsubseteq("nsubseteq", 0x02288),
    nsucc("nsucc", 0x02281),
    nsup("nsup", 0x02285),
    nsupe("nsupe", 0x02289),
    nsupseteq("nsupseteq", 0x02289),
    ntgl("ntgl", 0x02279),
    ntilde("ntilde", 0x000F1),
    ntlg("ntlg", 0x02278),
    ntriangleleft("ntriangleleft", 0x022EA),
    ntrianglelefteq("ntrianglelefteq", 0x022EC),
    ntriangleright("ntriangleright", 0x022EB),
    ntrianglerighteq("ntrianglerighteq", 0x022ED),
    nu("nu", 0x003BD),
    num("num", 0x00023),
    numero("numero", 0x02116),
    numsp("numsp", 0x02007),
    nvDash("nvDash", 0x022AD),
    nvHarr("nvHarr", 0x02904),
    nvdash("nvdash", 0x022AC),
    nvinfin("nvinfin", 0x029DE),
    nvlArr("nvlArr", 0x02902),
    nvrArr("nvrArr", 0x02903),
    nwArr("nwArr", 0x021D6),
    nwarhk("nwarhk", 0x02923),
    nwarr("nwarr", 0x02196),
    nwarrow("nwarrow", 0x02196),
    nwnear("nwnear", 0x02927),
    oS("oS", 0x024C8),
    oacute("oacute", 0x000F3),
    oast("oast", 0x0229B),
    ocir("ocir", 0x0229A),
    ocirc("ocirc", 0x000F4),
    ocy("ocy", 0x0043E),
    odash("odash", 0x0229D),
    odblac("odblac", 0x00151),
    odiv("odiv", 0x02A38),
    odot("odot", 0x02299),
    odsold("odsold", 0x029BC),
    oelig("oelig", 0x00153),
    ofcir("ofcir", 0x029BF),
    ofr("ofr", 0x1D52C),
    ogon("ogon", 0x002DB),
    ograve("ograve", 0x000F2),
    ogt("ogt", 0x029C1),
    ohbar("ohbar", 0x029B5),
    ohm("ohm", 0x003A9),
    oint("oint", 0x0222E),
    olarr("olarr", 0x021BA),
    olcir("olcir", 0x029BE),
    olcross("olcross", 0x029BB),
    oline("oline", 0x0203E),
    olt("olt", 0x029C0),
    omacr("omacr", 0x0014D),
    omega("omega", 0x003C9),
    omicron("omicron", 0x003BF),
    omid("omid", 0x029B6),
    ominus("ominus", 0x02296),
    oopf("oopf", 0x1D560),
    opar("opar", 0x029B7),
    operp("operp", 0x029B9),
    oplus("oplus", 0x02295),
    or("or", 0x02228),
    orarr("orarr", 0x021BB),
    ord("ord", 0x02A5D),
    order("order", 0x02134),
    orderof("orderof", 0x02134),
    ordf("ordf", 0x000AA),
    ordm("ordm", 0x000BA),
    origof("origof", 0x022B6),
    oror("oror", 0x02A56),
    orslope("orslope", 0x02A57),
    orv("orv", 0x02A5B),
    oscr("oscr", 0x02134),
    oslash("oslash", 0x000F8),
    osol("osol", 0x02298),
    otilde("otilde", 0x000F5),
    otimes("otimes", 0x02297),
    otimesas("otimesas", 0x02A36),
    ouml("ouml", 0x000F6),
    ovbar("ovbar", 0x0233D),
    par("par", 0x02225),
    para("para", 0x000B6),
    parallel("parallel", 0x02225),
    parsim("parsim", 0x02AF3),
    parsl("parsl", 0x02AFD),
    part("part", 0x02202),
    pcy("pcy", 0x0043F),
    percnt("percnt", 0x00025),
    period("period", 0x0002E),
    permil("permil", 0x02030),
    perp("perp", 0x022A5),
    pertenk("pertenk", 0x02031),
    pfr("pfr", 0x1D52D),
    phi("phi", 0x003C6),
    phiv("phiv", 0x003D5),
    phmmat("phmmat", 0x02133),
    phone("phone", 0x0260E),
    pi("pi", 0x003C0),
    pitchfork("pitchfork", 0x022D4),
    piv("piv", 0x003D6),
    planck("planck", 0x0210F),
    planckh("planckh", 0x0210E),
    plankv("plankv", 0x0210F),
    plus("plus", 0x0002B),
    plusacir("plusacir", 0x02A23),
    plusb("plusb", 0x0229E),
    pluscir("pluscir", 0x02A22),
    plusdo("plusdo", 0x02214),
    plusdu("plusdu", 0x02A25),
    pluse("pluse", 0x02A72),
    plusmn("plusmn", 0x000B1),
    plussim("plussim", 0x02A26),
    plustwo("plustwo", 0x02A27),
    pm("pm", 0x000B1),
    pointint("pointint", 0x02A15),
    popf("popf", 0x1D561),
    pound("pound", 0x000A3),
    pr("pr", 0x0227A),
    prE("prE", 0x02AB3),
    prap("prap", 0x02AB7),
    prcue("prcue", 0x0227C),
    pre("pre", 0x02AAF),
    prec("prec", 0x0227A),
    precapprox("precapprox", 0x02AB7),
    preccurlyeq("preccurlyeq", 0x0227C),
    preceq("preceq", 0x02AAF),
    precnapprox("precnapprox", 0x02AB9),
    precneqq("precneqq", 0x02AB5),
    precnsim("precnsim", 0x022E8),
    precsim("precsim", 0x0227E),
    prime("prime", 0x02032),
    primes("primes", 0x02119),
    prnE("prnE", 0x02AB5),
    prnap("prnap", 0x02AB9),
    prnsim("prnsim", 0x022E8),
    prod("prod", 0x0220F),
    profalar("profalar", 0x0232E),
    profline("profline", 0x02312),
    profsurf("profsurf", 0x02313),
    prop("prop", 0x0221D),
    propto("propto", 0x0221D),
    prsim("prsim", 0x0227E),
    prurel("prurel", 0x022B0),
    pscr("pscr", 0x1D4C5),
    psi("psi", 0x003C8),
    puncsp("puncsp", 0x02008),
    qfr("qfr", 0x1D52E),
    qint("qint", 0x02A0C),
    qopf("qopf", 0x1D562),
    qprime("qprime", 0x02057),
    qscr("qscr", 0x1D4C6),
    quaternions("quaternions", 0x0210D),
    quatint("quatint", 0x02A16),
    quest("quest", 0x0003F),
    questeq("questeq", 0x0225F),
    quot("quot", 0x00022),
    rAarr("rAarr", 0x021DB),
    rArr("rArr", 0x021D2),
    rAtail("rAtail", 0x0291C),
    rBarr("rBarr", 0x0290F),
    rHar("rHar", 0x02964),
    racute("racute", 0x00155),
    radic("radic", 0x0221A),
    raemptyv("raemptyv", 0x029B3),
    rang("rang", 0x027E9),
    rangd("rangd", 0x02992),
    range("range", 0x029A5),
    rangle("rangle", 0x027E9),
    raquo("raquo", 0x000BB),
    rarr("rarr", 0x02192),
    rarrap("rarrap", 0x02975),
    rarrb("rarrb", 0x021E5),
    rarrbfs("rarrbfs", 0x02920),
    rarrc("rarrc", 0x02933),
    rarrfs("rarrfs", 0x0291E),
    rarrhk("rarrhk", 0x021AA),
    rarrlp("rarrlp", 0x021AC),
    rarrpl("rarrpl", 0x02945),
    rarrsim("rarrsim", 0x02974),
    rarrtl("rarrtl", 0x021A3),
    rarrw("rarrw", 0x0219D),
    ratail("ratail", 0x0291A),
    ratio("ratio", 0x02236),
    rationals("rationals", 0x0211A),
    rbarr("rbarr", 0x0290D),
    rbbrk("rbbrk", 0x02773),
    rbrace("rbrace", 0x0007D),
    rbrack("rbrack", 0x0005D),
    rbrke("rbrke", 0x0298C),
    rbrksld("rbrksld", 0x0298E),
    rbrkslu("rbrkslu", 0x02990),
    rcaron("rcaron", 0x00159),
    rcedil("rcedil", 0x00157),
    rceil("rceil", 0x02309),
    rcub("rcub", 0x0007D),
    rcy("rcy", 0x00440),
    rdca("rdca", 0x02937),
    rdldhar("rdldhar", 0x02969),
    rdquo("rdquo", 0x0201D),
    rdquor("rdquor", 0x0201D),
    rdsh("rdsh", 0x021B3),
    real("real", 0x0211C),
    realine("realine", 0x0211B),
    realpart("realpart", 0x0211C),
    reals("reals", 0x0211D),
    rect("rect", 0x025AD),
    reg("reg", 0x000AE),
    rfisht("rfisht", 0x0297D),
    rfloor("rfloor", 0x0230B),
    rfr("rfr", 0x1D52F),
    rhard("rhard", 0x021C1),
    rharu("rharu", 0x021C0),
    rharul("rharul", 0x0296C),
    rho("rho", 0x003C1),
    rhov("rhov", 0x003F1),
    rightarrow("rightarrow", 0x02192),
    rightarrowtail("rightarrowtail", 0x021A3),
    rightharpoondown("rightharpoondown", 0x021C1),
    rightharpoonup("rightharpoonup", 0x021C0),
    rightleftarrows("rightleftarrows", 0x021C4),
    rightleftharpoons("rightleftharpoons", 0x021CC),
    rightrightarrows("rightrightarrows", 0x021C9),
    rightsquigarrow("rightsquigarrow", 0x0219D),
    rightthreetimes("rightthreetimes", 0x022CC),
    ring("ring", 0x002DA),
    risingdotseq("risingdotseq", 0x02253),
    rlarr("rlarr", 0x021C4),
    rlhar("rlhar", 0x021CC),
    rlm("rlm", 0x0200F),
    rmoust("rmoust", 0x023B1),
    rmoustache("rmoustache", 0x023B1),
    rnmid("rnmid", 0x02AEE),
    roang("roang", 0x027ED),
    roarr("roarr", 0x021FE),
    robrk("robrk", 0x027E7),
    ropar("ropar", 0x02986),
    ropf("ropf", 0x1D563),
    roplus("roplus", 0x02A2E),
    rotimes("rotimes", 0x02A35),
    rpar("rpar", 0x00029),
    rpargt("rpargt", 0x02994),
    rppolint("rppolint", 0x02A12),
    rrarr("rrarr", 0x021C9),
    rsaquo("rsaquo", 0x0203A),
    rscr("rscr", 0x1D4C7),
    rsh("rsh", 0x021B1),
    rsqb("rsqb", 0x0005D),
    rsquo("rsquo", 0x02019),
    rsquor("rsquor", 0x02019),
    rthree("rthree", 0x022CC),
    rtimes("rtimes", 0x022CA),
    rtri("rtri", 0x025B9),
    rtrie("rtrie", 0x022B5),
    rtrif("rtrif", 0x025B8),
    rtriltri("rtriltri", 0x029CE),
    ruluhar("ruluhar", 0x02968),
    rx("rx", 0x0211E),
    sacute("sacute", 0x0015B),
    sbquo("sbquo", 0x0201A),
    sc("sc", 0x0227B),
    scE("scE", 0x02AB4),
    scap("scap", 0x02AB8),
    scaron("scaron", 0x00161),
    sccue("sccue", 0x0227D),
    sce("sce", 0x02AB0),
    scedil("scedil", 0x0015F),
    scirc("scirc", 0x0015D),
    scnE("scnE", 0x02AB6),
    scnap("scnap", 0x02ABA),
    scnsim("scnsim", 0x022E9),
    scpolint("scpolint", 0x02A13),
    scsim("scsim", 0x0227F),
    scy("scy", 0x00441),
    sdot("sdot", 0x022C5),
    sdotb("sdotb", 0x022A1),
    sdote("sdote", 0x02A66),
    seArr("seArr", 0x021D8),
    searhk("searhk", 0x02925),
    searr("searr", 0x02198),
    searrow("searrow", 0x02198),
    sect("sect", 0x000A7),
    semi("semi", 0x0003B),
    seswar("seswar", 0x02929),
    setminus("setminus", 0x02216),
    setmn("setmn", 0x02216),
    sext("sext", 0x02736),
    sfr("sfr", 0x1D530),
    sfrown("sfrown", 0x02322),
    sharp("sharp", 0x0266F),
    shchcy("shchcy", 0x00449),
    shcy("shcy", 0x00448),
    shortmid("shortmid", 0x02223),
    shortparallel("shortparallel", 0x02225),
    shy("shy", 0x000AD),
    sigma("sigma", 0x003C3),
    sigmaf("sigmaf", 0x003C2),
    sigmav("sigmav", 0x003C2),
    sim("sim", 0x0223C),
    simdot("simdot", 0x02A6A),
    sime("sime", 0x02243),
    simeq("simeq", 0x02243),
    simg("simg", 0x02A9E),
    simgE("simgE", 0x02AA0),
    siml("siml", 0x02A9D),
    simlE("simlE", 0x02A9F),
    simne("simne", 0x02246),
    simplus("simplus", 0x02A24),
    simrarr("simrarr", 0x02972),
    slarr("slarr", 0x02190),
    smallsetminus("smallsetminus", 0x02216),
    smashp("smashp", 0x02A33),
    smeparsl("smeparsl", 0x029E4),
    smid("smid", 0x02223),
    smile("smile", 0x02323),
    smt("smt", 0x02AAA),
    smte("smte", 0x02AAC),
    softcy("softcy", 0x0044C),
    sol("sol", 0x0002F),
    solb("solb", 0x029C4),
    solbar("solbar", 0x0233F),
    sopf("sopf", 0x1D564),
    spades("spades", 0x02660),
    spadesuit("spadesuit", 0x02660),
    spar("spar", 0x02225),
    sqcap("sqcap", 0x02293),
    sqcup("sqcup", 0x02294),
    sqsub("sqsub", 0x0228F),
    sqsube("sqsube", 0x02291),
    sqsubset("sqsubset", 0x0228F),
    sqsubseteq("sqsubseteq", 0x02291),
    sqsup("sqsup", 0x02290),
    sqsupe("sqsupe", 0x02292),
    sqsupset("sqsupset", 0x02290),
    sqsupseteq("sqsupseteq", 0x02292),
    squ("squ", 0x025A1),
    square("square", 0x025A1),
    squarf("squarf", 0x025AA),
    squf("squf", 0x025AA),
    srarr("srarr", 0x02192),
    sscr("sscr", 0x1D4C8),
    ssetmn("ssetmn", 0x02216),
    ssmile("ssmile", 0x02323),
    sstarf("sstarf", 0x022C6),
    star("star", 0x02606),
    starf("starf", 0x02605),
    straightepsilon("straightepsilon", 0x003F5),
    straightphi("straightphi", 0x003D5),
    strns("strns", 0x000AF),
    sub("sub", 0x02282),
    subE("subE", 0x02AC5),
    subdot("subdot", 0x02ABD),
    sube("sube", 0x02286),
    subedot("subedot", 0x02AC3),
    submult("submult", 0x02AC1),
    subnE("subnE", 0x02ACB),
    subne("subne", 0x0228A),
    subplus("subplus", 0x02ABF),
    subrarr("subrarr", 0x02979),
    subset("subset", 0x02282),
    subseteq("subseteq", 0x02286),
    subseteqq("subseteqq", 0x02AC5),
    subsetneq("subsetneq", 0x0228A),
    subsetneqq("subsetneqq", 0x02ACB),
    subsim("subsim", 0x02AC7),
    subsub("subsub", 0x02AD5),
    subsup("subsup", 0x02AD3),
    succ("succ", 0x0227B),
    succapprox("succapprox", 0x02AB8),
    succcurlyeq("succcurlyeq", 0x0227D),
    succeq("succeq", 0x02AB0),
    succnapprox("succnapprox", 0x02ABA),
    succneqq("succneqq", 0x02AB6),
    succnsim("succnsim", 0x022E9),
    succsim("succsim", 0x0227F),
    sum("sum", 0x02211),
    sung("sung", 0x0266A),
    sup1("sup1", 0x000B9),
    sup2("sup2", 0x000B2),
    sup3("sup3", 0x000B3),
    sup("sup", 0x02283),
    supE("supE", 0x02AC6),
    supdot("supdot", 0x02ABE),
    supdsub("supdsub", 0x02AD8),
    supe("supe", 0x02287),
    supedot("supedot", 0x02AC4),
    suphsol("suphsol", 0x027C9),
    suphsub("suphsub", 0x02AD7),
    suplarr("suplarr", 0x0297B),
    supmult("supmult", 0x02AC2),
    supnE("supnE", 0x02ACC),
    supne("supne", 0x0228B),
    supplus("supplus", 0x02AC0),
    supset("supset", 0x02283),
    supseteq("supseteq", 0x02287),
    supseteqq("supseteqq", 0x02AC6),
    supsetneq("supsetneq", 0x0228B),
    supsetneqq("supsetneqq", 0x02ACC),
    supsim("supsim", 0x02AC8),
    supsub("supsub", 0x02AD4),
    supsup("supsup", 0x02AD6),
    swArr("swArr", 0x021D9),
    swarhk("swarhk", 0x02926),
    swarr("swarr", 0x02199),
    swarrow("swarrow", 0x02199),
    swnwar("swnwar", 0x0292A),
    szlig("szlig", 0x000DF),
    target("target", 0x02316),
    tau("tau", 0x003C4),
    tbrk("tbrk", 0x023B4),
    tcaron("tcaron", 0x00165),
    tcedil("tcedil", 0x00163),
    tcy("tcy", 0x00442),
    tdot("tdot", 0x020DB),
    telrec("telrec", 0x02315),
    tfr("tfr", 0x1D531),
    there4("there4", 0x02234),
    therefore("therefore", 0x02234),
    theta("theta", 0x003B8),
    thetasym("thetasym", 0x003D1),
    thetav("thetav", 0x003D1),
    thickapprox("thickapprox", 0x02248),
    thicksim("thicksim", 0x0223C),
    thinsp("thinsp", 0x02009),
    thkap("thkap", 0x02248),
    thksim("thksim", 0x0223C),
    thorn("thorn", 0x000FE),
    tilde("tilde", 0x002DC),
    times("times", 0x000D7),
    timesb("timesb", 0x022A0),
    timesbar("timesbar", 0x02A31),
    timesd("timesd", 0x02A30),
    tint("tint", 0x0222D),
    toea("toea", 0x02928),
    top("top", 0x022A4),
    topbot("topbot", 0x02336),
    topcir("topcir", 0x02AF1),
    topf("topf", 0x1D565),
    topfork("topfork", 0x02ADA),
    tosa("tosa", 0x02929),
    tprime("tprime", 0x02034),
    trade("trade", 0x02122),
    triangle("triangle", 0x025B5),
    triangledown("triangledown", 0x025BF),
    triangleleft("triangleleft", 0x025C3),
    trianglelefteq("trianglelefteq", 0x022B4),
    triangleq("triangleq", 0x0225C),
    triangleright("triangleright", 0x025B9),
    trianglerighteq("trianglerighteq", 0x022B5),
    tridot("tridot", 0x025EC),
    trie("trie", 0x0225C),
    triminus("triminus", 0x02A3A),
    triplus("triplus", 0x02A39),
    trisb("trisb", 0x029CD),
    tritime("tritime", 0x02A3B),
    trpezium("trpezium", 0x023E2),
    tscr("tscr", 0x1D4C9),
    tscy("tscy", 0x00446),
    tshcy("tshcy", 0x0045B),
    tstrok("tstrok", 0x00167),
    twixt("twixt", 0x0226C),
    twoheadleftarrow("twoheadleftarrow", 0x0219E),
    twoheadrightarrow("twoheadrightarrow", 0x021A0),
    uArr("uArr", 0x021D1),
    uHar("uHar", 0x02963),
    uacute("uacute", 0x000FA),
    uarr("uarr", 0x02191),
    ubrcy("ubrcy", 0x0045E),
    ubreve("ubreve", 0x0016D),
    ucirc("ucirc", 0x000FB),
    ucy("ucy", 0x00443),
    udarr("udarr", 0x021C5),
    udblac("udblac", 0x00171),
    udhar("udhar", 0x0296E),
    ufisht("ufisht", 0x0297E),
    ufr("ufr", 0x1D532),
    ugrave("ugrave", 0x000F9),
    uharl("uharl", 0x021BF),
    uharr("uharr", 0x021BE),
    uhblk("uhblk", 0x02580),
    ulcorn("ulcorn", 0x0231C),
    ulcorner("ulcorner", 0x0231C),
    ulcrop("ulcrop", 0x0230F),
    ultri("ultri", 0x025F8),
    umacr("umacr", 0x0016B),
    uml("uml", 0x000A8),
    uogon("uogon", 0x00173),
    uopf("uopf", 0x1D566),
    uparrow("uparrow", 0x02191),
    updownarrow("updownarrow", 0x02195),
    upharpoonleft("upharpoonleft", 0x021BF),
    upharpoonright("upharpoonright", 0x021BE),
    uplus("uplus", 0x0228E),
    upsi("upsi", 0x003C5),
    upsih("upsih", 0x003D2),
    upsilon("upsilon", 0x003C5),
    upuparrows("upuparrows", 0x021C8),
    urcorn("urcorn", 0x0231D),
    urcorner("urcorner", 0x0231D),
    urcrop("urcrop", 0x0230E),
    uring("uring", 0x0016F),
    urtri("urtri", 0x025F9),
    uscr("uscr", 0x1D4CA),
    utdot("utdot", 0x022F0),
    utilde("utilde", 0x00169),
    utri("utri", 0x025B5),
    utrif("utrif", 0x025B4),
    uuarr("uuarr", 0x021C8),
    uuml("uuml", 0x000FC),
    uwangle("uwangle", 0x029A7),
    vArr("vArr", 0x021D5),
    vBar("vBar", 0x02AE8),
    vBarv("vBarv", 0x02AE9),
    vDash("vDash", 0x022A8),
    vangrt("vangrt", 0x0299C),
    varepsilon("varepsilon", 0x003F5),
    varkappa("varkappa", 0x003F0),
    varnothing("varnothing", 0x02205),
    varphi("varphi", 0x003D5),
    varpi("varpi", 0x003D6),
    varpropto("varpropto", 0x0221D),
    varr("varr", 0x02195),
    varrho("varrho", 0x003F1),
    varsigma("varsigma", 0x003C2),
    vartheta("vartheta", 0x003D1),
    vartriangleleft("vartriangleleft", 0x022B2),
    vartriangleright("vartriangleright", 0x022B3),
    vcy("vcy", 0x00432),
    vdash("vdash", 0x022A2),
    vee("vee", 0x02228),
    veebar("veebar", 0x022BB),
    veeeq("veeeq", 0x0225A),
    vellip("vellip", 0x022EE),
    verbar("verbar", 0x0007C),
    vert("vert", 0x0007C),
    vfr("vfr", 0x1D533),
    vltri("vltri", 0x022B2),
    vopf("vopf", 0x1D567),
    vprop("vprop", 0x0221D),
    vrtri("vrtri", 0x022B3),
    vscr("vscr", 0x1D4CB),
    vzigzag("vzigzag", 0x0299A),
    wcirc("wcirc", 0x00175),
    wedbar("wedbar", 0x02A5F),
    wedge("wedge", 0x02227),
    wedgeq("wedgeq", 0x02259),
    weierp("weierp", 0x02118),
    wfr("wfr", 0x1D534),
    wopf("wopf", 0x1D568),
    wp("wp", 0x02118),
    wr("wr", 0x02240),
    wreath("wreath", 0x02240),
    wscr("wscr", 0x1D4CC),
    xcap("xcap", 0x022C2),
    xcirc("xcirc", 0x025EF),
    xcup("xcup", 0x022C3),
    xdtri("xdtri", 0x025BD),
    xfr("xfr", 0x1D535),
    xhArr("xhArr", 0x027FA),
    xharr("xharr", 0x027F7),
    xi("xi", 0x003BE),
    xlArr("xlArr", 0x027F8),
    xlarr("xlarr", 0x027F5),
    xmap("xmap", 0x027FC),
    xnis("xnis", 0x022FB),
    xodot("xodot", 0x02A00),
    xopf("xopf", 0x1D569),
    xoplus("xoplus", 0x02A01),
    xotime("xotime", 0x02A02),
    xrArr("xrArr", 0x027F9),
    xrarr("xrarr", 0x027F6),
    xscr("xscr", 0x1D4CD),
    xsqcup("xsqcup", 0x02A06),
    xuplus("xuplus", 0x02A04),
    xutri("xutri", 0x025B3),
    xvee("xvee", 0x022C1),
    xwedge("xwedge", 0x022C0),
    yacute("yacute", 0x000FD),
    yacy("yacy", 0x0044F),
    ycirc("ycirc", 0x00177),
    ycy("ycy", 0x0044B),
    yen("yen", 0x000A5),
    yfr("yfr", 0x1D536),
    yicy("yicy", 0x00457),
    yopf("yopf", 0x1D56A),
    yscr("yscr", 0x1D4CE),
    yucy("yucy", 0x0044E),
    yuml("yuml", 0x000FF),
    zacute("zacute", 0x0017A),
    zcaron("zcaron", 0x0017E),
    zcy("zcy", 0x00437),
    zdot("zdot", 0x0017C),
    zeetrf("zeetrf", 0x02128),
    zeta("zeta", 0x003B6),
    zfr("zfr", 0x1D537),
    zhcy("zhcy", 0x00436),
    zigrarr("zigrarr", 0x021DD),
    zopf("zopf", 0x1D56B),
    zscr("zscr", 0x1D4CF),
    zwj("zwj", 0x0200D),
    zwnj("zwnj", 0x0200C);

    //<<<end of generated code

    private String name;
    private int code;

    private NamedCharacterReference(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public int getCode() {
        return code;
    }

    public String getReferenceCode() {
        return new StringBuilder().append('&').append(getName()).append(';').toString();
    }

    public char getValue() {
        return (char) getCode();
    }
    
}
