(**
  A demo for the VODigiClock class. This little clock is really useable and
  is used by the author as part of its fvwm2 button pannel.
**)

MODULE DigiClock;

(*
    Demo for VisualOberon. Shows the current time.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,

              VO:Prefs:All,  (* Include preferences for all objects *)

       C   := VO:DigiClock,
       G   := VO:Object,
       Q   := VO:QuickHelp,
       T   := VO:Text,
       W   := VO:Window,

              Err,
       L   := Locales;

TYPE
  Window     = POINTER TO WindowDesc;
  WindowDesc = RECORD (W.WindowDesc)
               END;

VAR
  w        : Window;

  msg2Exit : D.Msg2Exit;

  old      : ARRAY 32 OF CHAR;

  PROCEDURE (w : Window) PreInit*;

  VAR
    clock : C.DigiClock;

  BEGIN
    NEW(clock);
    clock.Init;
    clock.SetFlags({G.horizontalFlex,G.verticalFlex});
(*  clock.SetWidth(G.sizeFontRel,10);
  clock.SetHeight(G.sizeFontRel,5);*)
    IF D.display.colorMode=D.colorMode THEN
      clock.SetForeground(D.display.AllocateNamedColor("green",D.textColor));
      clock.SetNumberBackground(D.display.AllocateNamedColor("black",D.backgroundColor));
      IF clock.backgroundObject=NIL THEN
        clock.SetBackground(D.display.AllocateNamedColor("black",D.textColor));
      END;
    END;
    clock.SetHelpObject(Q.InitHelp(T.MakeLeftText("\ecDigiClock\n@ 1998, Tim Teulings\nwritten with VisualOberon"),clock));

    w.SetTop(clock);

    w.PreInit^;
  END PreInit;


BEGIN
  D.display.SetAppName("Clock");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  L.Set(L.ALL,"",old);  (* use env variables *)

  NEW(w);
  w.Init;
  w.SetTitle("Clock");

  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);

  w.Open;

  D.display.EventLoop;

  D.display.Close;
END DigiClock.