MODULE VO:ObjectPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT BG  := VO:Base:Background,
       F   := VO:Base:Frame,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PG  := VO:Prefs:GUI,
       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       L   := VO:Label,
       P   := VO:Panel,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  PrefsItem*     = POINTER TO PrefsItemDesc;
  PrefsItemDesc* = RECORD (PG.PrefsItemDesc)
                     prefs     : G.Prefs;
                     frame     : V.IntModel;
                   END;
(*
VAR
  prefs : Item;
*)
  PROCEDURE (d : PrefsItem) Init*;

  BEGIN
    d.Init^;
    d.name:="String";

    NEW(d.frame);
    d.frame.Init;
  END Init;

  PROCEDURE (d : PrefsItem) SetPrefs*(prefs : G.Prefs);

  BEGIN
    d.prefs:=prefs;
  END SetPrefs;

  PROCEDURE (d : PrefsItem) GetObject*():G.Object;

  VAR
    frame    : FG.FrameGroup;
    label    : L.Label;
    panel    : P.Panel;
    tab      : TA.Tab;
    frmCombo : FSD.FrmSelCombo;

  BEGIN
    NEW(tab);
    tab.Init;
    tab.SetFlags({G.horizontalFlex,G.verticalFlex});

    panel:=P.CreatePanel();
    panel.Set(P.vertical);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Frame");

        label:=L.CreateLabel();

          frmCombo:=FSD.CreateFrmSelCombo();
          frmCombo.SetModel(d.frame);
        label.AddTextLabel("Object Frame",frmCombo);
      frame.SetObject(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText("Object"),panel);


    RETURN tab;
  END GetObject;

  PROCEDURE (d : PrefsItem) Refresh*;

  BEGIN
    d.frame.SetLongint(d.prefs.frame);
  END Refresh;

  PROCEDURE (p : PrefsItem) Apply*;

  BEGIN
    p.prefs.frame:=p.frame.GetLongint();
  END Apply;

  PROCEDURE (p : PrefsItem) LoadPrefs*(top : PP.Item);

  BEGIN
    F.LoadFrame("frame",top,p.prefs.frame);
    p.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : PrefsItem) SavePrefs*(block : PP.BlockItem);

  BEGIN
    block.AddItemValue("frame",F.internalFrames[p.prefs.frame]);
    BG.SaveBackground(block,p.prefs.background);
  END SavePrefs;

END VO:ObjectPrefs.