/* position8.h
 */
#ifndef OSL_POSITION8_H
#define OSL_POSITION8_H

#include "osl/position.h"
#include "osl/misc/fixedCapacityVector.h"
#include "osl/misc/cstdint.h"
#include <iosfwd>

namespace osl
{
  namespace container
  {
    struct Position8 : public FixedCapacityVector<uint8_t,8>
    {
      typedef FixedCapacityVector<uint8_t,8> base_t;
      void push_back(Position position)
      {
	base_t::push_back(position.uintValue());
      }
      bool isMember(Position position) const
      {
	return base_t::isMember(position.uintValue());
      }
      const Position operator[](size_t i) const
      {
	return Position::makeDirect(base_t::operator[](i));
      }
    };
    std::ostream& operator<<(std::ostream&, const Position8&);
  } // namespace container
  using container::Position8;
} // namespace osl

#endif /* OSL_POSITION8_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
