#include "osl/effect_util/virtualPin.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/apply_move/applyMove.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
#include <fstream>

using namespace osl;
using namespace osl::effect_util;

extern bool isShortTest;

class VirtualPinTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(VirtualPinTest);
  CPPUNIT_TEST(testFind);
  CPPUNIT_TEST_SUITE_END();
public:
  void testFind();
};

CPPUNIT_TEST_SUITE_REGISTRATION(VirtualPinTest);

void VirtualPinTest::testFind() 
{
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE *  * -FU *  *  *  * \n"
			   "P2 * -OU * -KA-KI+NG+RY *  * \n"
			   "P3 * -FU-GI-RY *  *  *  *  * \n"
			   "P4 * -KY-FU-FU * -FU * +UM * \n"
			   "P5-FU *  * -KI * +FU *  * -FU\n"
			   "P6 *  * -KE+KE *  *  * -FU * \n"
			   "P7+FU+FU+GI+FU+FU *  *  * +FU\n"
			   "P8+KY * +KI *  * +GI *  *  * \n"
			   "P9+OU+KE+KI *  *  * +FU * +KY\n"
			   "P+00FU00FU\n"
			   "P-00FU\n"
			   "+\n").getInitialState());
    CPPUNIT_ASSERT(VirtualPin::find(state, WHITE, Position(5,1)));
    CPPUNIT_ASSERT(! VirtualPin::find(state, WHITE, Position(7,4)));
  }
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
