/* average.h
 */
#ifndef _AVERAGE_H
#define _AVERAGE_H

namespace osl
{
  namespace stat
  {
    /**
     * incrementaly maintain average of data sequence
     */
    class Average
    {
      double average;
      int elements;
    public:
      // CREATORS
      Average() : average(0), elements(0)
      {
      }
      // MANIPULATORS
      /**
       * Add an element x
       * @return difference between x and (old) average
       */
      double add(const double& x)
      {
	++elements;
	const double diff = x - average;
	average += diff/elements;
	return diff;
      }
      void merge(const Average& r) 
      {
	if (r.elements == 0)
	  return;
	const double sum = average*elements + r.average*r.elements;
	elements += r.elements;
	average = sum / elements;
      }
      void clear()
      {
	average = 0.0;
	elements = 0;
      }
      // ACCESSORS
      double getAverage() const	{ return average; }
      int numElements() const	{ return elements; }
    };
  } // namespace stat
} // namespace osl


#endif /* _AVERAGE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
