/* reorder.t.cc
 */
#include "osl/misc/reorder.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <vector>
#include <algorithm>
#include <ext/algorithm>
#include <cassert>

using namespace osl;

class ReorderTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(ReorderTest);
  CPPUNIT_TEST(testReorder);
  CPPUNIT_TEST_SUITE_END();
public:
  void testReorder();
};


void ReorderTest::
testReorder()
{
  typedef std::vector<int> vector_t;
  for (int n=0; n<8; ++n)
  {
    vector_t v;
    const int size = 100;
    for (int i=0; i<size; ++i)
      v.push_back(i);
    std::random_shuffle(v.begin(), v.end());
    CPPUNIT_ASSERT(! __gnu_cxx::is_sorted(v.begin(), v.end()));
    vector_t indices(size);
    for (int i=0; i<size; ++i)
    {
      vector_t::const_iterator p=std::find(v.begin(), v.end(), i);
      assert(p!=v.end());
      indices[i] = p-v.begin();
    }
    misc::Reorder::reorder(v.begin(), v.end(), indices);
    CPPUNIT_ASSERT(__gnu_cxx::is_sorted(v.begin(), v.end()));
  }
}

CPPUNIT_TEST_SUITE_REGISTRATION(ReorderTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
