// This is a roxen module. (c) Martin Baehr 1996

// The disclaimer module. replaces the container: <body>...</body> 
// to add a disclaimer just before </body>. 

//  This code is (c) 1996-1997 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.
//  This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
//  implicit or explicit. Use at your own risk.
//  You can modify this code as you wish, but in this case please
//  - state that you changed the code in the modified version
//  - do not remove my name from it
//  - send me a copy of the modified version or a patch, so that
//    I can include it in the 'official' release.
//  If you find this code useful, please e-mail me. It would definitely
//  boost my ego :)
//  
//  For risks and side-effects please read the code or ask your local 
//  unix or roxen-guru.

string cvs_version = "$Id: disclaimer.pike,v 1.0 1996/12/31 mb Exp $";
#include <module.h> 
inherit "module"; 
inherit "roxenlib"; 

void create()
{
  defvar("disclaimers", 
	 "#we are not responsible for the content of our customers pages:\n"
	 "/customers/*: <hr><a href=http://www.yumyum.at/>YumYum</a>"
	 " disclaims any responsibility for this content!\n"
	 "#you may also store your disclaimer in a file to be included:\n"
	 "/users/*: <insert file=/disclaimers/user_disclaimer>\n" 
	 "#default for all others:\n"
	 "*: <hr>these pages are presented to you by"
	 "<a href=http://www.yumyum.at/>YumYum Communications</a>\n",
	 "disclaimers", 
	 TYPE_TEXT_FIELD, 
	 "this are the disclaimers based on file-wildcards, "
	 "entries are scanned top-down, and the first match will be used."
	 );
}

array register_module() 
{ 
  return({ 
    MODULE_PARSER, 
      "Disclaimer", 
      "The disclaimer module replaces the container: " 
      "<tt>&lt;body&gt;...&lt;/body&gt;</tt>"
      " to add a disclaimer just before <tt>&lt;/body&gt;</tt>.\n<p>"
      "if you don't want a disclaimer on a particular page, "
      "put <tt>no_disclaimer</tt> into the closing body-tag:"
      "<tt>&lt;/body no_disclaimer&gt;</tt>"
      "<p><strong>this module will only work on pages with "
      "<tt>&lt;body&gt;...&lt;/body&gt;</tt> present. without that you will not get a disclaimer</strong>",
      0, 
      1, 
  }); 
} 

#define  regexp(_) (Regexp(_)->match)
array disclaimers_arr=({ });

void start()
{
  string disclaimer;

  foreach(query("disclaimers")/"\n", disclaimer)
  {
    if(!strlen(disclaimer) || disclaimer[0]=='#')
      continue;
    //perror(disclaimer+"\n");

    string pattern, value;
    if(sscanf(disclaimer, "%s:%s", pattern, value)==2)
    {
      //perror("disclaimers_arr: if pattern: %s, value: %s\n", pattern, value);
      disclaimers_arr += ({ ({ regexp(replace(pattern, ({ "?", "*", "." }),
					      ({ ".", ".*", "\." }))),
				 value
				   }) });
    }
  }
//  ::start();
}


/* A container gets the contents as the third 
* argument. Example: <body Bar=Gazonk>Hi!</body> --> 
* container_body("body", (["bar":"Gazonk"]), 
* "Hi!", ...); 
* Note the lowercasing of Bar. 
*/ 
string container_body(string tag_name, 
		     mapping arguments, 
		     string contents, 
		     object request_id, 
		     mapping defines) 
{ 
  if (arguments->no_disclaimer)
    return 0;
  if (arguments->_parsed)
    return 0;

  string path, i=0;
  array disclaimer_arr;

  path = request_id->raw_url;
  //perror("perror:"+path+"\n");
  //  path = request_id->not_query;
  //  perror("perror:"+path+"\n");

  foreach(disclaimers_arr, disclaimer_arr)
  {
    //perror("foreach: %s\n",disclaimer_arr[1]);
    if(disclaimer_arr[0](request_id->raw_url))
      return disclaimer_arr[1]+"</body _parsed>"+contents;
  }
  return "</body _parsed>"+contents;
    //  perror("the disclaimer: %s", disclaimer);
    //  return disclaimer+"</body _parsed>"+contents; 



} 
mapping query_container_callers() 
{ 
  return (["/body":container_body, ]); 
} 


