/* EnhancedTableCellRenderer.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.tables;

import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

/**
 * Enhances the standard renderer by painting decorations to the
 * right of the column headers.
 */
class EnhancedTableCellRenderer extends DefaultTableCellRenderer {
    
    //
    private final int spacing; // TODO: merge with spacing in EnhancedTableHeader
        
    //
    public EnhancedTableCellRenderer() {
        this.spacing = EnhancedTableHeader.SPACING;
    }
    
    //
    private List<TableColumnDecoration> decorations;
    
    //
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        
        // copied from JTableHeader.UIResourceTableCellRenderer
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                setForeground(header.getForeground());
                setBackground(header.getBackground());
                setFont(header.getFont());
            }
        }
        
        setText((value == null) ? "" : value.toString());
        setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        
        setHorizontalAlignment(JLabel.CENTER);
        
        TableColumn tc = table.getColumnModel().getColumn(column);
        decorations = ((EnhancedTable)table).getDecorations(tc.getModelIndex());
        return this;
    }
    
    //
    protected void paintComponent(Graphics g) {
        
        // paint decorations for the current column
        if (decorations == null) {
            super.paintComponents(g);
        } else {
            // cannot use insets for compatibility with mouse handler
            int x = getWidth(); //  - getInsets ().right;
            int h = getHeight(); // + getInsets ().top - getInsets().bottom;
            for (TableColumnDecoration deco : decorations) {
                x -= deco.getDecorationWidth() + spacing;
                int y = (h - deco.getDecorationHeight()) / 2;
                deco.paintDecoration(this, g, x, y);
            }
            int oldWidth = getWidth();
            int oldHeight = getHeight();
            setSize(x - spacing, oldHeight); // decrease bounds for subsequent painting of label
            super.paintComponent(g);
            setSize(oldWidth, oldHeight); // restore so border is painted correctly
        }
    }
    
}
