/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <errno.h>
#include <sys/time.h>

#include <libsysactivity/libsysactivity.h>

void* stress_get_process(void* arg) {
	int ret;
#ifdef SA_OPEN_PROCESS
	ret = sa_open_process();
	if (ret != 0) {
		printf("sa_open_process(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	int stress;

	pid_t pid, written;
	ret = sa_count_processes(&pid);
	if (ret != 0) {
		printf("sa_count_processes(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
	pid_t* pids = malloc(pid * sizeof(pid_t));
	ret = sa_get_processes_ids(pids, pid, &written);
	if (ret != 0) {
		printf("sa_get_processes_ids(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	struct sa_process pro;
	pid_t i;

	for (stress = 0; stress < 200; stress++) {
		for (i = 0; i < written; i++) {
			ret = sa_get_process(pids[i], &pro);
			if (ret != 0) {
				printf("sa_get_process(): %s\n", strerror(ret));
				exit(EXIT_FAILURE);
			}
		}
	}
	free(pids);

#ifdef SA_CLOSE_PROCESS
	ret = sa_close_process();
	if (ret != 0) {
		printf("sa_close_process(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return NULL;
}

int main() {
	pthread_t thread1;
	struct timespec delay;
	delay.tv_sec = 0;
	delay.tv_nsec = 1000000;

	pthread_create(&thread1, NULL, stress_get_process, NULL);
	nanosleep(&delay, NULL);
	stress_get_process(NULL);

	return EXIT_SUCCESS;
}
