/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/* 
   This file illustrates an example of how to create a new Spatial Temporal Element 
   Set (STElementSet) from a layer. A Spatial Temporal Element Set can be created 
   from a layer or from a theme.
   In this example the STElementSet is created from a layer and is filled only
   with some attributes.

   Author: Karine Reis   
*/

#include <TeSTElementSet.h>
#include <TeSTEFunctionsDB.h>
#include <TeInitQuerierStrategy.h>
#include <TeMySQL.h>

int main()
{	
 	// Datatabase server parameters
	string host = "localhost";
	string dbname = "TerraLib";
	string user = "root";
	string password = "ferreira";

	// Open a connection to the TerraTeste MySQL database 
	TeDatabase* db = new TeMySQL();
	if (!db->connect(host, user, password, dbname))
	{
		cout << "Error: " << db->errorMessage() << endl;
		cout << endl << "Press Enter\n";
		getchar();
		return 1;
	}
	cout << "Connection successful to the database \"" << dbname << "\" on MySQL server \"" << host << "\" !\n";;
	
	// Loads the layer
	TeLayer* estados = new TeLayer("EstadosBrasil");
	if (!db->loadLayer(estados))
	{
	    cout << "Fail to load the layer \"EstadosBrasil\": " << db->errorMessage() << endl;
		db->close();
		cout << endl << "Press Enter\n";
		getchar();
        return 1;
	}

	// Inits querier strategies
	TeInitQuerierStrategies();

	// Creates a elementSet from the layer "estados"
	TeSTElementSet steSet (estados);

	// Defines what attributes will be kept in the elementSet. 
	// The attribute name must be in the format "table_name.attribute_name"
	vector<string> attrs;
	attrs.push_back("EstadosBrasil.NOME_UF");
	attrs.push_back("EstadosBrasil.CAPITAL");

	// Fills the elementSet without geometries and with the 
	// attributes NOME_UF and CAPITAL 
	bool loadGeometries = false;
	bool loadAllAttributes = false;
	if(!TeSTOSetBuildDB(&steSet, loadGeometries, loadAllAttributes, attrs))
	{
		cout << "Error! " << endl;
		cout << endl << "Press Enter\n";
		getchar();
		return 1;
	}

	// Prints the number of elements of the elementSet
	cout << "Number of elements: " << steSet.numElements() << endl;

	
	TeSTElementSet::iterator it = steSet.begin();
	while ( it != steSet.end())
	{
		TeSTInstance st = (*it);

		string desc;
		// returns the attributes
		TePropertyVector vectp = st.getPropertyVector();

		cout << "Id: " << st.objectId() << " ---------------- " << endl;
		for (unsigned int i=0; i<vectp.size(); i++)
		{
			cout << vectp[i].attr_.rep_.name_ << "  =  ";
			cout << vectp[i].value_ << endl;
		}
		cout << endl;
		++it;
	}

	db->close();
	cout << endl << "Press Enter\n";
	getchar();
	return 0;
}
