/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
#ifndef __TEBAYESFUNCTIONSH__
#define __TEBAYESFUNCTIONSH__

#include "TeStatDataStructures.h"

// Class for error treatment
enum TeGlobalBayesError {
   BAYES_GREATER_CASES,
   BAYES_NULL_POPULATION
};

class TeGlobalBayesException  {


   TeGlobalBayesError error_;

public:

  TeGlobalBayesException(TeGlobalBayesError e) {
    error_ = e;
  }

  TeGlobalBayesError getErrorCode() {
    return error_;
  }
};


// TeGlobalEmpiricalBayes				// Function declaration
bool TeGlobalEmpiricalBayes(TeSTStatInstanceSet *rs, double rate);



/* Taxa Bayesiana Local -- recebe conjunto de areas, cria matriz de vizinhanca,
   e estima taxa local baseado na vizinhanca.

   As duas primeiras propriedades das areas sao populacao e casos.
   Ha mais duas propriedades double onde serao armazenados total de casos e total
   de populacao dos vizinhos.

  teta[i]=w[i]*r[i]+(1-w[i])*c[i]
  w[i]=V/(V+r[i]))
  V=Sum(Area i,Pop[i]*(ri-m)^2)/Sum(Area i,Pop[i])-m/PopMedia
*/
// TeGlobalEmpiricalBayes				// Function declaration
bool TeLocalEmpiricalBayes(TeSTElementSet *rs, string& colname, double rate);


#endif
