//---------------------------------------------------------------------------
#include <stdlib.h>
#include <math.h>
#include <string.h>
#ifdef WIN32
#pragma hdrstop
#endif

#include "TeSkaterGrafo.h"
#include "lista.h"
#include "TeProxMatrixConstructionStrategy.h"
#include "TeGeneralizedProxMatrix.h"
#include "TeSTElementSet.h"


TSkaterGrafo::TSkaterGrafo(bool hasPop){

   MyGrafo= new MyGrafo_t;
   MyGrafo->Nos = (Grafo_ptr) malloc(sizeof(Grafo_t));
   MyGrafo->Size = 0;
   Hash = new THash;
   Tem_Pop = (hasPop) ? 1 : 0;
};


/*************************/
int TSkaterGrafo::GetSize(){

  return MyGrafo->Size; //Retorna o tamanho do grafo
};


/*************************/
/*************************/

bool  TSkaterGrafo::MontaGrafo(TeSTElementSet& regSet) {

//  long nAreas = regSet.numElements();

  TeSTElementSet::iterator it = regSet.begin(); 
  int  nCov   = (*it).getPropertyVector().size();


  //Monta lista de areas

  TeCoord2D centroid;
  (*it).centroid(centroid);
  X_min=X_max=centroid.x();
  Y_min=Y_max=centroid.y();
  //Obtem o numero de variaveis --> se tem populacao e menos um
  if (this->Tem_Pop)
          MyGrafo->Num_Var = nCov-1; //Obtem o numero de variaveis
  else
          MyGrafo->Num_Var = nCov;

  string val;
  int i;

  //Monta areas
  while (it != regSet.end()) 
  {
		(*it).centroid(centroid);    
		MyGrafo->Nos = 
		  (Grafo_ptr) realloc(MyGrafo->Nos,sizeof(Grafo_t)*((MyGrafo->Size)+1));
		sprintf(MyGrafo->Nos[MyGrafo->Size].Label,"%s",(*it).objectId().c_str());
		MyGrafo->Nos[MyGrafo->Size].Vizinhos = NULL;
		MyGrafo->Nos[MyGrafo->Size].ArViz = NULL;
		Hash->Insere(MyGrafo->Nos[MyGrafo->Size].Label,MyGrafo->Size);
		MyGrafo->Nos[MyGrafo->Size].X = centroid.x();
		if(centroid.x() < X_min) X_min =centroid.x();// Procura limites da tela
		else if(centroid.x() > X_max) X_max = centroid.x();
    
		MyGrafo->Nos[MyGrafo->Size].Y =centroid.y();
		if(centroid.y()< Y_min) Y_min = centroid.y(); //Procura limites da tela
		else if(centroid.y() > Y_max) Y_max = centroid.y();
    
		MyGrafo->Nos[MyGrafo->Size].Variaveis = 
		  (double *) malloc(sizeof(double)*MyGrafo->Num_Var);
		for(i=0;i<MyGrafo->Num_Var;i++) {
		  (*it).getPropertyValue(val, i);
		  MyGrafo->Nos[MyGrafo->Size].Variaveis[i] = atof(val.c_str()); 
		}
		if (Tem_Pop) {
		  (*it).getPropertyValue(val, MyGrafo->Num_Var);
		  MyGrafo->Nos[MyGrafo->Size].Populacao = (int)atof(val.c_str());//covs[a*nCov+nCov-1];
		}
		else
		  MyGrafo->Nos[MyGrafo->Size].Populacao = 0;
    
		MyGrafo->Nos[MyGrafo->Size].Mark=1;
		(MyGrafo->Size)++;
		(++it);
  }


  //Monta vizinhanca
   //Monta matriz de vizinhanca
	TeProxMatrixLocalAdjacencyStrategy matrix(&regSet, TePOLYGONS);         
	TeGeneralizedProxMatrix neighMatrix(&matrix);

  int L_indice,V_indice;
  double dist;

  it = regSet.begin();
	
	while ( it != regSet.end())
	{
		TeNeighboursMap	neighbors = neighMatrix.getMapNeighbours((*it).objectId());

		//Grafo eh desconexo
		if (neighbors.size() == 0) 
		{
		  delete Hash;
		  return false;
		}

		L_indice = Hash->Pesquisa((*it).objectId().c_str());
		MyGrafo->Nos[L_indice].Vizinhos = new TListaVizinho;
		MyGrafo->Nos[L_indice].ArViz = new TListaVizinho;

		TeNeighboursMap::iterator itNeigs = neighbors.begin();
	 			
		while(itNeigs != neighbors.end())
		{
     
		   V_indice = Hash->Pesquisa(((*itNeigs).first).c_str());
		   dist = Distancia(L_indice,V_indice);
		   MyGrafo->Nos[L_indice].Vizinhos->Insere(V_indice,dist);
		   (++itNeigs);
		}
		(++it);
	}

  delete Hash;
  return true;
}


/*************************/
double TSkaterGrafo::Distancia(int L_indice, int V_indice){

   int i;
   double Acc=0;

   for(i=0;i < MyGrafo->Num_Var;i++)
      Acc += (MyGrafo->Nos[L_indice].Variaveis[i] - MyGrafo->Nos[V_indice].Variaveis[i]) *
             (MyGrafo->Nos[L_indice].Variaveis[i] - MyGrafo->Nos[V_indice].Variaveis[i]);
   return sqrt(Acc);
};

//-------------------------------------
void  TSkaterGrafo::Escalona(double *X, double *Y){
  *X = Cx *(*X + Gamax);
  *Y = Cy *(*Y + Gamay);
};

/***************************/
//Retorna o Indice e o peso do proximo Vizinho -1 se nao houver mais vizinhos
void  TSkaterGrafo::Adjacente(int *Indice,double *Peso,int i){
   MyGrafo->Nos[i].Vizinhos->Adjacente(Indice,Peso);
};

void  TSkaterGrafo::Adjacente1(int *Indice,double *Peso,int i){
   MyGrafo->Nos[i].ArViz->Adjacente(Indice,Peso);
};

//--------------------------------------------------------
void  TSkaterGrafo::Escala(int Altura,int Largura){

  Cx = (Largura - 2*(RAIO))/(X_max-X_min);
  Gamax = -RAIO/Cx - X_min;

  Cy = (Altura - 2*(RAIO))/(Y_max-Y_min);
  Gamay = -RAIO/Cy - Y_min;
};
//--------------------------------------------------------
double  TSkaterGrafo::Get_X(int Indice){
   return MyGrafo->Nos[Indice].X;
};

//--------------------------------------------------------
double  TSkaterGrafo::Get_Y(int Indice){
   return MyGrafo->Nos[Indice].Y;
};
//---------------------------------------------
int  TSkaterGrafo::GetNum_Var(){
  return MyGrafo->Num_Var;
};
