/*  libticables - link cable library, a part of the TiLP project
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_TI_MACROS_H
# include <tilp/cabl_int.h>
# include <tilp/pause.h>
#else
# include "../src/cabl_int.h"
# include "../src/pause.h"
#endif

#undef VERSION
#define VERSION "Test program"

void print_lc_error(int errnum)
{
  char msg[256] = "No error -> bug !\n";

  ticable_get_error(errnum, msg);
  fprintf(stderr, "Link cable error (code %i): %s\n", errnum, msg);
}

int main(int argc, char **argv)
{
  int err;
  byte data;
  LinkParam lp;
  LinkCable lc;
  PortInfo pi;
  char *os;

  //printf("found = <%s>\n", search_for_tiusb_node(0));
  
  /* Display verbose informations in the shell (Linux) or 
     in a console (Win32) 
  */
  ticable_DISPLAY_settings(DSP_ON);
  
  /* Auto-detect some things (just for example, not mandatory) */
  ticable_detect_os(&os);
  ticable_detect_port(&pi);
  
  /* Set cable */
  ticable_init();

  ticable_get_default_param(&lp);
  lp.delay = 10;
  lp.timeout = 15;
  lp.port = SERIAL_PORT_2;
  lp.method = IOM_AUTO;
  ticable_set_param(&lp);

  ticable_set_cable(LINK_SER, &lc);
     
  /* Init port (usually at program startup) */
  if( (err=lc.init()) )
    {
      print_lc_error(err);
      return -1;
    }
  
  /* Open it */
  if( (err=lc.open()) )
    {
      print_lc_error(err);
      return -1;
    }

  DISPLAY("Wait 1 second...\n");
  PAUSE(1000);
  
  /* 
     Do a simple test with a TI89/92+ calculator
  */
  
  /* Check if calc is ready */
  DISPLAY("Check if calc is OK...\n");
  err=lc.put(0x00);			// 0x08: TI89, 0x09: TI92
  err=lc.put(0x68);
  err=lc.put(0x00);
  err=lc.put(0x00);
  err=lc.get(&data);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  printf("Data: %02X\n", data);

  DISPLAY("\n");


  /* Remote control: display a 'A' on the calc */
  DISPLAY("Display a 'A' on the calc...\n");
  err=lc.put(0x08);			// 0x08: TI89, 0x09: TI92
  err=lc.put(0x87);
  err=lc.put('A');
  err=lc.put(0x00);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  printf("Data: %02X\n", data);
  err=lc.get(&data);
  
  /* Close port */
  if( (err=lc.close()) ) print_lc_error(err);
  
  /* Exit port (usually at program termination */
  if( (err=lc.exit()) ) print_lc_error(err);

  return 0;
}

