/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_MISC__
#define __TIFFEP_MISC__

#include "tiffep.h"


/**********************/
/* Exported functions */
/**********************/
TIEXPORT
const char *tiffep_group_file_ext(gint calc_type);
TIEXPORT
const char *tiffep_backup_file_ext(int calc_type);
TIEXPORT
const int tiffep_tixx_dir(int calc_type);
TIEXPORT
const char *tiffep_flash_app_file_ext(int calc_type);
TIEXPORT
const char *tiffep_flash_os_file_ext(int calc_type);
/*
const char *ti82_byte2type(byte data);
byte ti82_type2byte(char *s);
const char *ti82_byte2fext(byte data);
byte ti82_fext2byte(char *s);

const char *ti83_byte2type(byte data);
byte ti83_type2byte(char *s);
const char *ti83_byte2fext(byte data);
byte ti83_fext2byte(char *s);

const char *ti83p_byte2type(byte data);
byte ti83p_type2byte(char *s);
const char *ti83p_byte2fext(byte data);
byte ti83p_fext2byte(char *s);

const char *ti85_byte2type(byte data);
byte ti85_type2byte(char *s);
const char *ti85_byte2fext(byte data);
byte ti85_fext2byte(char *s);

const char *ti86_byte2type(byte data);
byte ti86_type2byte(char *s);
const char *ti86_byte2fext(byte data);
byte ti86_fext2byte(char *s);

const char *ti89_byte2type(byte data);
byte ti89_type2byte(char *s);
const char *ti89_byte2fext(byte data);
byte ti89_fext2byte(char *s);

const char *ti92_byte2type(byte data);
byte ti92_type2byte(char *s);
const char *ti92_byte2fext(byte data);
byte ti92_fext2byte(char *s);

const char *ti92p_byte2type(byte data);
byte ti92p_type2byte(char *s);
const char *ti92p_byte2fext(byte data);
byte ti92p_fext2byte(char *s);
*/

TIEXPORT
const char* tiffep_vartype_to_file_extension(gint calc_type, gint var_type);

TIEXPORT
int tiffep_is_a_group_file(gchar *filename);
TIEXPORT
int tiffep_is_a_backup_file(gchar *filename);
TIEXPORT
int tiffep_is_a_flash_file(gchar *filename);

TIEXPORT
int tiffep_which_calc_type_from_file(gchar *filename);
TIEXPORT
int tiffep_which_var_type_from_file(gchar *filename);
TIEXPORT
int tiffep_which_file_type_from_file(gchar *filename);

TIEXPORT
const char *tiffep_var_type_to_string(gint var_type);
TIEXPORT
const char *tiffep_calc_type_to_string(gint calc_type);
TIEXPORT
const char *tiffep_attribute_to_string(gint var_atrb);

/**************************/
/* Internal use functions */
/**************************/

gint read_string8(gchar *s, FILE *f);
gint write_string8(gchar *s, FILE *f);
gint read_string_n(gchar *s, gint n, FILE *f);
gint write_string_n(gchar *s, gint n, FILE *f);

word compute_checksum(byte *buffer, gint size, word *chk);

#endif

