#---------------------------------------------------------------------------
#
#   libtunepimp -- The MusicBrainz tagging library.  
#                  Let a thousand taggers bloom!
#   
#   Copyright (C) Robert Kaye 2003
#   
#   This file is part of libtunepimp.
#
#   libtunepimp is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   libtunepimp is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with libtunepimp; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   $Id: tunepimp.py,v 1.3 2004/03/25 09:20:15 robert Exp $
#
#---------------------------------------------------------------------------
import _tunepimp

import track, metadata

# TODO
#   Unhandled case - handle result_t casting cases   

# TPCallBackEnum values used for GetNotification
eFileAdded = 0;
eFileChanged = 1;
eFileRemoved = 2;
eWriteTagsComplete = 3;

# TPError returned by WriteTags and GetResults
eOk                     = 0
eTooManyTRMs            = 1
eNoUserInfo             = 2
eLookupError            = 3
eSubmitError            = 4
eInvalidIndex           = 5
eInvalidObject          = 6

# TPFileStatus
eUnrecognized           = 0    # unrecognized
eRecognized             = 1    # Recognized and previously saved
ePending                = 2    # pending trm calculation
eTRMLookup              = 3    # trm done, pending trm lookup
eTRMCollision           = 4    # trm done, pending trm lookup
eFileLookup             = 5    # trm done, no matches, pending file lookup
eUserSelection          = 6    # file lookup done, needs user selection
eVerified               = 7    # User verified, about to write changes to disk 
eSaved                  = 8    # File was saved
eDeleted                = 9    # to be deleted, waiting for refcount == 0
eError                  = 10   # Error

# TPResultType
eNone                   = 0
eArtistList             = 1
eAlbumList              = 2
eTrackList              = 3
eMatchedTrack           = 4

# TPAlbumType
eAlbumType_Album        = 0
eAlbumType_Single       = 1
eAlbumType_EP           = 2
eAlbumType_Compilation  = 3
eAlbumType_Soundtrack   = 4
eAlbumType_Spokenword   = 5
eAlbumType_Interview    = 6
eAlbumType_Audiobook    = 7
eAlbumType_Live         = 8
eAlbumType_Remix        = 9
eAlbumType_Other        = 1;
eAlbumType_Error        = 1;

# TPAlbumStatus
eAlbumStatus_Official   = 0
eAlbumStatus_Promotion  = 1
eAlbumStatus_Bootleg    = 2

# TPThreadPriorityEnum
eIdle                   = 0
eLowest                 = 1
eLow                    = 2
eNormal                 = 3
eHigh                   = 4
eHigher                 = 5
eTimeCritical           = 6

# Thread identifiers
tpThreadNone            = 0x0000
tpThreadLookupTRM       = 0x0001
tpThreadLookupFile      = 0x0002
tpThreadWrite           = 0x0004
tpThreadAll             = 0xFFFF

class tunepimp(object):
    '''This is the main tunepimp class. For details on how to use this class, 
       please look up the main tunepimp documentation'''

    def __init__(self, appName, appVersion, threads=tpThreadAll):
        self.tp = _tunepimp.New(appName, appVersion, threads)

    def __del__(self):
        _tunepimp.Delete(self.tp)

    def getVersion(self):
        return _tunepimp.GetVersion(self.tp)

    def setUserInfo(self, user, passwd):
        _tunepimp.SetUserInfo(self.tp, user, passwd)

    def getUserInfo(self):
        return _tunepimp.GetUserInfo(self.tp)

    def setUseUTF8(self):
        _tunepimp.SetUseUTF8(self.tp)

    def getUseUTF8(self):
        return _tunepimp.GetUseUTF8(self.tp)

    def setServer(self, server, port):
        _tunepimp.SetServer(self.tp, server, port)

    def getServer(self):
        return _tunepimp.GetServer(self.tp)

    def setProxy(self, server, port):
        _tunepimp.SetProxy(self.tp, server, port)

    def getProxy(self):
        return _tunepimp.GetProxy(self.tp)

    def getNumSupportedExtensions(self):
        return _tunepimp.GetNumSupportedExtensions(self.tp)

    def getSupportedExtensions(self):
        return _tunepimp.GetSupportedExtensions(self.tp)

    def setAnalyzerPriority(self, priority):
        _tunepimp.SetAnalyzerPriority(self.tp, priority)

    def getAnalyzerPriority(self):
        return _tunepimp.GetAnalyzerPriority(self.tp)

    def setAutoFileLookup(self, autoLookup):
        _tunepimp.SetAutoFileLookup(self.tp, autoLookup)

    def getAutoFileLookup(self):
        return _tunepimp.GetAutoFileLookup(self.tp)

    def getNotification(self):
        return _tunepimp.GetNotification(self.tp)

    def getStatus(self):
        return _tunepimp.GetStatus(self.tp)

    def getError(self):
        return _tunepimp.GetError(self.tp)

    def setDebug(self, debug):
        _tunepimp.SetDebug(self.tp, debug)

    def getDebug(self):
        return _tunepimp.GetDebug(self.tp)

    def addFile(self, file):
        return _tunepimp.AddFile(self.tp, file)

    def addDir(self, dir):
        return _tunepimp.AddDir(self.tp, dir)

    def remove(self, file):
        _tunepimp.Remove(self.tp, file)

    def getNumFiles(self):
        return _tunepimp.GetNumFiles(self.tp)

    def getNumUnsubmitted(self):
        return _tunepimp.GetNumUnsubmitted(self.tp)

    def getNumUnsavedItems(self):
        return _tunepimp.GetNumUnsavedItems(self.tp)

    def getTrackCounts(self):
        return _tunepimp.GetTrackCounts(self.tp)

    def getFileIds(self):
        return _tunepimp.GetFileIds(self.tp)

    def getTrack(self, id):
        tr = track.track(_tunepimp.GetTrack(self.tp, id))
        return tr

    def releaseTrack(self, tr):
        _tunepimp.ReleaseTrack(self.tp, tr.getTrackObject())

    def wake(self):
        _tunepimp.Wake(self.tp)

    def selectResult(self, index):
        return _tunepimp.SelectResult(self.tp, index)

    def misidentified(self, fileId):
        _tunepimp.Misidentified(self.tp, fileId)

    def identifyAgain(self, fileId):
        _tunepimp.IdentifyAgain(self.tp, fileId)

    def writeTags(self, fileIdTuple):
        return _tunepimp.WriteTags(self.tp, fileIdTuple)

    def addTRMSubmission(self):
        _tunepimp.AddTRMSubmission(self.tp)

    def submitTRMs(self, trackId, trmId):
        return _tunepimp.SubmitTRMs(self.tp, trackId, trmId)

    def setRenameFiles(self, rename):
        _tunepimp.SetRenameFiles(self.tp, rename)

    def getRenameFiles(self):
        return _tunepimp.GetRenameFiles(self.tp)

    def setMoveFiles(self, move):
        _tunepimp.SetMoveFiles(self.tp, move)

    def getMoveFiles(self):
        return _tunepimp.GetMoveFiles(self.tp)

    def setWriteID3v1(self, write):
        _tunepimp.SetWriteID3v1(self.tp, write)

    def getWriteID3v1(self):
        return _tunepimp.GetWriteID3v1(self.tp)

    def setClearTags(self, clear):
        _tunepimp.SetClearTags(self.tp, clear)

    def getClearTags(self):
        return _tunepimp.GetClearTags(self.tp)

    def setFileMask(self, mask):
        _tunepimp.SetFileMask(self.tp, mask)

    def getFileMask(self):
        return _tunepimp.GetFileMask(self.tp)

    def setVariousFileMask(self, mask):
        _tunepimp.SetVariousFileMask(self.tp, mask)

    def getVariousFileMask(self):
        return _tunepimp.GetVariousFileMask(self.tp)

    def setAllowedFileCharacters(self, allowedChars):
        _tunepimp.SetAllowedFileCharacters(self.tp, allowedChars)

    def getAllowedFileCharacters(self):
        return _tunepimp.GetAllowedFileCharacters(self.tp)

    def setDestDir(self, destDir):
        _tunepimp.SetDestDir(self.tp, destDir)

    def getDestDir(self):
        return _tunepimp.GetDestDir(self.tp)

    def setTopSrcDir(self, topSrcDir):
        _tunepimp.SetTopSrcDir(self.tp, topSrcDir)

    def getTopSrcDir(self):
        return _tunepimp.GetTopSrcDir(self.tp)

    def setTRMCollisionThreshold(self, thres):
        _tunepimp.SetTRMCollisionThreshold(self.tp, thres)

    def getTRMCollisionThreshold(self):
        return _tunepimp.GetTRMCollisionThreshold(self.tp)

    def setMinTRMThreshold(self, thres):
        _tunepimp.SetMinTRMThreshold(self.tp, thres)

    def GetMinTRMThreshold(self):
        return _tunepimp.GetMinTRMThreshold(self.tp)

    def setAutoSaveThreshold(self, thres):
        _tunepimp.SetAutoSaveThreshold(self.tp, thres)

    def getAutoSaveThreshold(self):
        return _tunepimp.GetAutoSaveThreshold(self.tp)

    def setMaxFileNameLen(self, len):
        _tunepimp.SetMaxFileNameLen(self.tp, len)

    def getMaxFileNameLen(self):
        return _tunepimp.GetMaxFileNameLen(self.tp)

    def setAutoRemovedSavedFiles(self, autoRemove):
        _tunepimp.SetAutoRemovedSavedFiles(self.tp, autoRemove)

    def getAutoRemovedSavedFiles(self):
        return _tunepimp.GetAutoRemovedSavedFiles(self.tp)

    def getRecognizedFileList(self, thres):
        return _tunepimp.GetRecognizedFileList(self.tp, thres)
