/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jsp.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.jsp.compilers.JasperC;
import org.apache.tools.ant.taskdefs.optional.jsp.compilers.JspCompilerAdapter;

public class JspCompilerAdapterFactory {
    private JspCompilerAdapterFactory() {
    }

    public static JspCompilerAdapter getCompiler(String compilerType, Task task) throws BuildException {
        if (compilerType.equalsIgnoreCase("jasper")) {
            return new JasperC();
        }
        return JspCompilerAdapterFactory.resolveClassName(compilerType);
    }

    private static JspCompilerAdapter resolveClassName(String className) throws BuildException {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            return (JspCompilerAdapter)o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException(className + " can't be found.", (Throwable)cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " isn't the classname of " + "a compiler adapter.", (Throwable)cce);
        }
        catch (Throwable t) {
            throw new BuildException(className + " caused an interesting " + "exception.", t);
        }
    }
}

