/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.tr.OutputMethod;
import org.xml.sax.AttributeList;

class OutputMethodAttributeList
implements AttributeList {
    private final OutputMethod method;
    private final Name[] names;
    private Name[] cdataSectionElements;

    OutputMethodAttributeList(OutputMethod method) {
        this.method = method;
        this.names = method.getAttributeNames();
        this.cdataSectionElements = method.getCdataSectionElements();
        if (this.cdataSectionElements.length == 0) {
            this.cdataSectionElements = null;
        }
    }

    public int getLength() {
        return this.names.length;
    }

    public String getName(int i) {
        if (this.cdataSectionElements != null && i-- == 0) {
            return "cdata-section-elements";
        }
        return OutputMethodAttributeList.nameToString(this.names[i]);
    }

    private static final String nameToString(Name name) {
        if (name.getNamespace() == null) {
            return name.getLocalPart();
        }
        return name.getNamespace() + '^' + name.getLocalPart();
    }

    public String getValue(int i) {
        if (this.cdataSectionElements != null && i-- == 0) {
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < this.cdataSectionElements.length; ++i) {
                if (i != 0) {
                    buf.append(' ');
                }
                buf.append(OutputMethodAttributeList.nameToString(this.cdataSectionElements[i]));
            }
            return buf.toString();
        }
        return this.method.getSpecifiedValue(this.names[i]);
    }

    public String getType(int i) {
        return "CDATA";
    }

    public String getType(String name) {
        return "CDATA";
    }

    public String getValue(String nameString) {
        if (nameString.equals("cdata-section-elements")) {
            return this.cdataSectionElements == null ? null : this.getValue(0);
        }
        int ns = nameString.lastIndexOf(94);
        Name name = ns < 0 ? this.method.getNameTable().createName(nameString) : this.method.getNameTable().createName(nameString.substring(0, ns), nameString.substring(ns + 1));
        return this.method.getSpecifiedValue(name);
    }
}

