/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax2.MultiNamespaceResult;
import com.jclark.xsl.sax2.SAXTwoOMBuilder;
import com.jclark.xsl.sax2.SAXTwoOMBuilderImpl;
import com.jclark.xsl.sax2.XMLProcessorEx;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLProcessorImpl
implements XMLProcessorEx {
    private XMLReader _reader = null;
    private ErrorHandler errorHandler;

    public XMLProcessorImpl() {
    }

    public XMLProcessorImpl(XMLReader reader) {
        this._reader = reader;
    }

    public void setXMLReader(XMLReader reader) {
        this._reader = reader;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Node load(InputSource source, int documentIndex, LoadContext context, NameTable nameTable) throws IOException, XSLException {
        try {
            if (this._reader == null) {
                this._reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            SAXTwoOMBuilderImpl builder = new SAXTwoOMBuilderImpl(context, source.getSystemId(), documentIndex, nameTable.getEmptyNamespacePrefixMap(), source);
            this._reader.setContentHandler(builder);
            this._reader.setDTDHandler(builder);
            this._reader.parse(source);
            return builder.getRootNode();
        }
        catch (SAXException e) {
            Exception wrapped = e.getException();
            if (wrapped == null) {
                throw new XSLException(e.getMessage());
            }
            if (wrapped instanceof XSLException) {
                throw (XSLException)e.getException();
            }
            throw new XSLException(wrapped);
        }
        catch (Exception e) {
            throw new XSLException(e);
        }
    }

    public Node load(URL url, int documentIndex, LoadContext context, NameTable nameTable) throws IOException, XSLException {
        XMLReader reader = this._reader;
        try {
            this._reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this._reader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Exception e) {
            throw new XSLException(e);
        }
        Node n = this.load(new InputSource(url.toString()), documentIndex, context, nameTable);
        this._reader = reader;
        return n;
    }

    public SAXTwoOMBuilder getConfiguredOMBuilder(String systemId, int documentIndex, LoadContext context, NameTable nameTable) {
        SAXTwoOMBuilder builder = XMLProcessorImpl.createBuilder(systemId, documentIndex, context, nameTable);
        return builder;
    }

    public static SAXTwoOMBuilder createBuilder(String systemId, int documentIndex, LoadContext context, NameTable nameTable) {
        return new SAXTwoOMBuilderImpl(context, systemId, documentIndex, nameTable.getEmptyNamespacePrefixMap(), null);
    }

    public Result createResult(Node baseNode, int documentIndex, LoadContext loadContext, Node[] rootNode) throws XSLException {
        URL baseURL = null;
        if (baseNode != null) {
            baseURL = baseNode.getURL();
        }
        String base = baseURL == null ? null : baseURL.toString();
        SAXTwoOMBuilder builder = XMLProcessorImpl.createBuilder(base, documentIndex, loadContext, baseNode.getNamespacePrefixMap().getNameTable());
        rootNode[0] = builder.getRootNode();
        return new MultiNamespaceResult(builder, this.errorHandler);
    }
}

