/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.SaxFilterMaker;
import com.jclark.xsl.sax2.MultiNamespaceResult;
import com.jclark.xsl.sax2.OutputMethodHandler;
import com.jclark.xsl.sax2.ResultBase;
import com.jclark.xsl.sax2.SAXTwoOMBuilder;
import com.jclark.xsl.sax2.XMLProcessorEx;
import com.jclark.xsl.sax2.XMLProcessorImpl;
import com.jclark.xsl.sax2.XSLProcessor;
import com.jclark.xsl.tr.ActionDebugTarget;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Sheet;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.transform.SourceLocator;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XSLProcessorImpl
implements XSLProcessor,
Cloneable,
ParameterSet {
    private XMLProcessorEx _sourceModelBuilder;
    private XMLProcessorEx _sheetModelBuilder;
    private boolean _engineMatchesSheetLoader = false;
    private XMLReader _sheetReader;
    private XMLReader _sourceReader;
    private Sheet _sheet;
    private Engine _engine;
    private InputSource _sheetSource;
    private ResultBase _result;
    private OutputMethodHandler _outputMethodHandler;
    private ContentHandler _contentHandler;
    private DTDHandler _dtdHandler;
    private EntityResolver _resolver;
    private ErrorHandler _errorHandler;
    private Hashtable _params = new Hashtable();
    private SaxFilterMaker _xrap = null;
    private ActionDebugTarget _debugger = null;
    private Node _sourceRoot = null;

    public XSLProcessorImpl() {
    }

    public XSLProcessorImpl(Sheet sheet, Engine engine) {
        this._sheet = sheet;
        this._engine = engine;
        this._engineMatchesSheetLoader = true;
    }

    public void setReaders(XMLReader sourceReader, XMLReader sheetReader) {
        this._sourceReader = sourceReader;
        this._sheetReader = sheetReader;
        this._sourceModelBuilder = new XMLProcessorImpl(sourceReader);
        this._sheetModelBuilder = this._sourceReader == this._sheetReader ? this._sourceModelBuilder : new XMLProcessorImpl(this._sheetReader);
        this._engineMatchesSheetLoader = false;
    }

    public void setSourceReader(XMLReader sourceReader) {
        this._sourceReader = sourceReader;
        this._sourceModelBuilder = new XMLProcessorImpl(sourceReader);
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (this._sheetReader != null) {
            this._sheetReader.setEntityResolver(resolver);
        }
        if (this._sourceReader != null) {
            this._sourceReader.setEntityResolver(resolver);
        }
    }

    public EntityResolver getEntityResolver() {
        return this._resolver;
    }

    public void setOutputMethodHandler(OutputMethodHandler handler) {
        this._outputMethodHandler = handler;
        this._contentHandler = null;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
        this._outputMethodHandler = null;
    }

    public ContentHandler getSourceBuilder() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (this._sheetReader != null) {
            this._sheetReader.setErrorHandler(handler);
        }
        if (this._sourceReader != null) {
            this._sourceReader.setErrorHandler(handler);
        }
        if (this._sheetModelBuilder != null) {
            this._sheetModelBuilder.setErrorHandler(handler);
        }
        if (this._sourceModelBuilder != null) {
            this._sourceModelBuilder.setErrorHandler(handler);
        }
        this._errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setFeature(String featureURI, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("XSLProcessor cannot set feature: " + featureURI);
    }

    public boolean getFeature(String featureURI) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("XSLProcessor cannot get feature: " + featureURI);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("XSLProcessor cannot get property: " + name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("XSLProcessor cannot set property: " + name);
    }

    public void loadStylesheet(InputSource sheetSource) throws SAXException, IOException {
        if (!this._engineMatchesSheetLoader) {
            if (this._sheetModelBuilder == null) {
                throw new Error("loadStylesheet called before setParsers");
            }
            this._engine = new EngineImpl(this._sheetModelBuilder, new ExtensionHandlerImpl());
            this._engineMatchesSheetLoader = true;
        }
        try {
            this.phase(1);
            Node node = this._sheetModelBuilder.load(sheetSource, 0, this._engine.getSheetLoadContext(), this._engine.getNameTable());
            this.phase(2);
            this._sheet = this._engine.createSheet(node);
        }
        catch (XSLException e) {
            this.handleXSLException(e);
        }
    }

    public void setSaxExtensionFilter(String name, SaxFilterMaker xrap) {
        this._xrap = xrap;
    }

    public void setDebugger(String name, ActionDebugTarget debugger) {
        this._debugger = debugger;
    }

    public void parse(String sourceURI) throws SAXException, IOException {
        this.parse(new InputSource(sourceURI));
    }

    public void parse(InputSource source) throws SAXException, IOException {
        try {
            this.configureResult();
            if (this._sheet == null) {
                throw new SAXException("no compiled stylesheet!");
            }
            if (this._engine == null) {
                throw new SAXException("no engine");
            }
            if (this._sourceModelBuilder == null) {
                throw new SAXException("no object model builder");
            }
            this.phase(3);
            Node sourceRoot = this._sourceModelBuilder.load(source, 0, this._sheet.getSourceLoadContext(), this._engine.getNameTable());
            this.phase(4);
            this.transform(sourceRoot);
            this.phase(5);
        }
        catch (XSLException e) {
            this.handleXSLException(e);
        }
    }

    public void configureResult() {
        this._result = this._outputMethodHandler != null ? new MultiNamespaceResult(this._outputMethodHandler, this._errorHandler) : (this._contentHandler != null ? new MultiNamespaceResult(this._contentHandler, this._errorHandler) : new MultiNamespaceResult(new DefaultHandler(), this._errorHandler));
    }

    public void transform(Node sourceRoot) throws XSLException {
        if (this._xrap != null) {
            this._sheet.setSaxExtensionFilter(this._xrap);
        }
        if (this._debugger != null) {
            this._sheet.setDebugger(this._debugger);
        }
        this._sheet.process(sourceRoot, this._sourceModelBuilder, this, this._result);
    }

    public SAXTwoOMBuilder getSourceOMBuilder(String systemId) {
        if (this._sourceModelBuilder == null) {
            return null;
        }
        return this._sourceModelBuilder.getConfiguredOMBuilder(systemId, 0, this._sheet.getSourceLoadContext(), this._engine.getNameTable());
    }

    void handleXSLException(XSLException e) throws SAXException, IOException {
        String systemId = null;
        int lineNumber = -1;
        SourceLocator sl = e.getLocator();
        if (sl != null) {
            systemId = sl.getSystemId();
            lineNumber = sl.getLineNumber();
        }
        Exception wrapped = (Exception)e.getException();
        String message = e.getMessage();
        if (systemId != null || lineNumber != -1) {
            throw new SAXParseException(message, null, systemId, lineNumber, -1, wrapped);
        }
        if (message == null) {
            if (wrapped instanceof SAXException) {
                throw (SAXException)wrapped;
            }
            if (wrapped instanceof IOException) {
                throw (IOException)wrapped;
            }
        }
        throw new SAXException(message, wrapped);
    }

    void phase(int n) {
    }

    public Object clone() {
        try {
            XSLProcessorImpl cloned = (XSLProcessorImpl)super.clone();
            cloned._params = (Hashtable)cloned._params.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Object getParameter(Name name) {
        String nameString = name.getNamespace();
        nameString = nameString == null ? name.getLocalPart() : nameString + '^' + name.getLocalPart();
        return this._params.get(nameString);
    }

    public void setParameter(String name, Object obj) {
        int nsend;
        if (name.length() > 1 && name.charAt(0) == '{' && (nsend = name.indexOf(125)) > 0) {
            name = name.substring(1, nsend) + '^' + name.substring(nsend + 1);
        }
        this._params.put(name, obj);
    }

    public Object getParameter(String name) {
        int nsend;
        if (name.length() > 1 && name.charAt(0) == '{' && (nsend = name.indexOf(125)) > 0) {
            name = name.substring(1, nsend) + '^' + name.substring(nsend + 1);
        }
        return this._params.get(name);
    }

    public void clearParameters() {
        this._params = new Hashtable();
    }
}

