(* ocamlgsl - OCaml interface to GSL                        *)
(* Copyright () 2002 - Olivier Andrieu                     *)
(* distributed under the terms of the GPL version 2         *)

type t

val make : int -> t

external order : t -> int
    = "ml_gsl_cheb_order"

external init : t -> Gsl_fun.gsl_fun -> a:float -> b:float -> unit
    = "ml_gsl_cheb_init"

val eval     : t -> ?order:int -> float -> float
val eval_err : t -> ?order:int -> float -> Gsl_fun.result

val deriv : t -> t
val integ : t -> t
