// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Convert_CompPolynomialToPoles_HeaderFile
#define _Convert_CompPolynomialToPoles_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_TColStd_HArray2OfReal_HeaderFile
#include <Handle_TColStd_HArray2OfReal.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColStd_HArray1OfReal;
class TColStd_HArray1OfInteger;
class TColStd_HArray2OfReal;
class Standard_OutOfRange;
class Standard_ConstructionError;
class TColStd_Array1OfInteger;
class TColStd_Array1OfReal;
class TColStd_Array2OfReal;


//! To convert an function (curve) polynomial by span in a BSpline. <br>
//! <br>
//!   This class uses the following arguments : <br>
//!   NumCurves :  the number of Polynomial Curves <br>
//!   Continuity:  the requested continuity for the n-dimensional Spline <br>
//!   Dimension :  the dimension of the Spline <br>
//!   MaxDegree :  maximum allowed degree for each composite <br>
//!                polynomial segment. <br>
//!   NumCoeffPerCurve : the number of coefficient per segments = degree - 1 <br>
//!   Coefficients  :  the coefficients organized in the following way <br>
//!       [1..<myNumPolynomials>][1..myMaxDegree +1][1..myDimension] <br>
//!       that is : index [n,d,i] is at slot <br>
//!       (n-1) * (myMaxDegree + 1) * myDimension + (d-1) * myDimension + i <br>
//!  PolynomialIntervals :  nth polynomial represents a polynomial between <br>
//!     myPolynomialIntervals->Value(n,0) and <br>
//!     myPolynomialIntervals->Value(n,1) <br>
//!  TrueIntervals : the nth polynomial has to be mapped linearly to be <br>
//!       defined on the following interval : <br>
//!       myTrueIntervals->Value(n) and myTrueIntervals->Value(n+1) <br>
//!       so that it represent adequatly the function with the <br>
//!       required continuity <br>
class Convert_CompPolynomialToPoles  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //!  Warning! <br>
//!           Continuity can be at MOST the maximum degree of <br>
//!           the polynomial functions <br>
//!  TrueIntervals : <br>
//!  this is the true parameterisation for the composite curve <br>
//!  that is : the curve has myContinuity if the nth curve <br>
//!  is parameterized between myTrueIntervals(n) and myTrueIntervals(n+1) <br>
//! <br>
//!  Coefficients have to be the implicit "c form": <br>
//!  Coefficients[Numcurves][MaxDegree+1][Dimension] <br>
//! <br>
//!  Warning! <br>
//!         The NumberOfCoefficient of an polynome is his degree + 1 <br>
//!  Example: To convert the linear function f(x) = 2*x + 1 on the <br>
//!         domaine [2,5] to BSpline with the bound [-1,1]. Arguments are : <br>
//!          NumCurves  = 1; <br>
//!          Continuity = 1; <br>
//!          Dimension  = 1; <br>
//!          MaxDegree  = 1; <br>
//!          NumCoeffPerCurve [1] = {2}; <br>
//!          Coefficients[2] = {1, 2}; <br>
//!          PolynomialIntervals[1,2] = {{2,5}} <br>
//!          TrueIntervals[2] = {-1, 1} <br>
  Standard_EXPORT   Convert_CompPolynomialToPoles(const Standard_Integer NumCurves,const Standard_Integer Continuity,const Standard_Integer Dimension,const Standard_Integer MaxDegree,const Handle(TColStd_HArray1OfInteger)& NumCoeffPerCurve,const Handle(TColStd_HArray1OfReal)& Coefficients,const Handle(TColStd_HArray2OfReal)& PolynomialIntervals,const Handle(TColStd_HArray1OfReal)& TrueIntervals);
  //! To Convert sevral span with different order of Continuity. <br>
//!  Warning: The Length of Continuity have to be NumCurves-1 <br>
  Standard_EXPORT   Convert_CompPolynomialToPoles(const Standard_Integer NumCurves,const Standard_Integer Dimension,const Standard_Integer MaxDegree,const TColStd_Array1OfInteger& Continuity,const TColStd_Array1OfInteger& NumCoeffPerCurve,const TColStd_Array1OfReal& Coefficients,const TColStd_Array2OfReal& PolynomialIntervals,const TColStd_Array1OfReal& TrueIntervals);
  //! To Convert only one span. <br>
  Standard_EXPORT   Convert_CompPolynomialToPoles(const Standard_Integer Dimension,const Standard_Integer MaxDegree,const Standard_Integer Degree,const TColStd_Array1OfReal& Coefficients,const TColStd_Array1OfReal& PolynomialIntervals,const TColStd_Array1OfReal& TrueIntervals);
  //!  number of poles of the n-dimensional BSpline <br>
//! <br>
  Standard_EXPORT     Standard_Integer NbPoles() const;
  //!  returns the poles of the n-dimensional BSpline <br>
//!  in the following format : <br>
//!  [1..NumPoles][1..Dimension] <br>
//! <br>
  Standard_EXPORT     void Poles(Handle(TColStd_HArray2OfReal)& Poles) const;
  
  Standard_EXPORT     Standard_Integer Degree() const;
  //! Degree of the n-dimensional Bspline <br>
  Standard_EXPORT     Standard_Integer NbKnots() const;
  //! Knots of the n-dimensional Bspline <br>
  Standard_EXPORT     void Knots(Handle(TColStd_HArray1OfReal)& K) const;
  //! Multiplicities of the knots in the BSpline <br>
  Standard_EXPORT     void Multiplicities(Handle(TColStd_HArray1OfInteger)& M) const;
  
  Standard_EXPORT     Standard_Boolean IsDone() const;





protected:





private:

  
  Standard_EXPORT     void Perform(const Standard_Integer NumCurves,const Standard_Integer MaxDegree,const Standard_Integer Dimension,const TColStd_Array1OfInteger& NumCoeffPerCurve,const TColStd_Array1OfReal& Coefficients,const TColStd_Array2OfReal& PolynomialIntervals,const TColStd_Array1OfReal& TrueIntervals) ;


Handle_TColStd_HArray1OfReal myFlatKnots;
Handle_TColStd_HArray1OfReal myKnots;
Handle_TColStd_HArray1OfInteger myMults;
Handle_TColStd_HArray2OfReal myPoles;
Standard_Integer myDegree;
Standard_Boolean myDone;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
