// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Image_PixMap_HeaderFile
#define _Image_PixMap_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Image_PixMap_HeaderFile
#include <Handle_Image_PixMap.hxx>
#endif

#ifndef _Image_HPrivateImage_HeaderFile
#include <Image_HPrivateImage.hxx>
#endif
#ifndef _Aspect_PixMap_HeaderFile
#include <Aspect_PixMap.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Image_TypeOfImage_HeaderFile
#include <Image_TypeOfImage.hxx>
#endif
#ifndef _Standard_PByte_HeaderFile
#include <Standard_PByte.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
#ifndef _Image_CRawBufferData_HeaderFile
#include <Image_CRawBufferData.hxx>
#endif
class Aspect_PixmapDefinitionError;
class Aspect_PixmapError;
class Quantity_Color;


//! This class defines a system-independent bitmap <br>
class Image_PixMap : public Aspect_PixMap {

public:

  
//! Allocate the bitmap with requested dimensions. <br>
//! Allowed image types: <br>
//!  - Image_TOI_RGB (color image, 1 byte per component); <br>
//!  - Image_TOI_RGBA (color image with alpha channel); <br>
//!  - Image_TOI_RGBF (color image, 1 float per component); <br>
//!  - Image_TOI_RGBAF (color image with alpha channel); <br>
//!  - Image_TOI_FLOAT (grey image, 1 float per pixel). <br>
  Standard_EXPORT   Image_PixMap(const Standard_Integer theWidth,const Standard_Integer theHeight,const Image_TypeOfImage theType);
  
//! Create a bitmap by copying an existing buffer. <br>
  Standard_EXPORT   Image_PixMap(const Standard_PByte theDataPtr,const Standard_Integer theWidth,const Standard_Integer theHeight,const Standard_Integer thePitch,const Standard_Integer theBitsPerPixel,const Standard_Boolean theIsTopDown);
  
//! Destroies the Bitmap <br>
  Standard_EXPORT   virtual  void Destroy() ;
~Image_PixMap()
{
  Destroy();
}
  
//! Dumps the Bitmap to an image file with <br>
//! an optional gamma correction value <br>
//! and returns TRUE if the dump occurs normaly. <br>
  Standard_EXPORT   virtual  Standard_Boolean Dump(const Standard_CString theFilename,const Standard_Real theGammaCorr = 1.0) const;
  
//! Returns NULL handle <br>
  Standard_EXPORT   virtual  Aspect_Handle PixmapID() const;
  
//! Fill the structure for low-level access to the bitmap data. <br>
//! It is up to you to interpret these bytes correctly! <br>
//! Important notice: image stored upside-down in the memory, <br>
//!                   first image row is an last scanline in <br>
//!                   the memory buffer. <br>
//! If image was created with type Image_TOI_FLOAT buffer <br>
//! format will be set to TDepthComponent. You can override <br>
//! this field with another one-channel buffer format because <br>
//! it useless for bitmap definition. <br>
  Standard_EXPORT     void AccessBuffer(Image_CRawBufferData& theBufferInfo) const;
  
//! Returns the pixel color. This function is relatively slow, <br>
//! use AccessBuffer() instead for stream operations. <br>
//! Note that this function convert input theY coordinate <br>
//! to count off from top of an image (while in memory it stored <br>
//! upside-down). <br>
  Standard_EXPORT   virtual  Quantity_Color PixelColor(const Standard_Integer theX,const Standard_Integer theY) const;



  DEFINE_STANDARD_RTTI(Image_PixMap)

protected:


Image_HPrivateImage myImage;


private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
