## Copyright (C) 1996, 1997  Friedrich Leisch
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage : snnspattern (f, in, out)
##
## Write a pattern file for the Stuttgart neural network simulator SNNS.
## f is a string containing the file name (without extension .pat), in
## is a matrix where each row contains one input vector and out the
## matrix of corresponding target vectors.  The SNNS utility mkhead must
## be in your PATH.
  
## Author:  FL <Friedrich.Leisch@ci.tuwien.ac.at>
## Description:  Write a pattern file for SNNS
                        
function snnspattern (f, in, out);

  f = [f, ".pat"];
  
  [inr, inc] = size (in);
  
  if (nargin == 3)
    [outr, outc] = size (out);
    if (inr != outr)
      error ("snnspattern: in and out must have same number of rows");
    endif
  elseif (nargin == 2)
    outc = 0;
  else
    usage ("snnspattern(f, in, out)");
  endif    
  
  cmd= "mkhead ";
  cmd = [ cmd, sprintf ("%d %d %d > %s", inr, inc, outc, f) ];
  system (cmd);
  
  outf = fopen (f,"a");
  
  for r = 1:inr
    fprintf (outf, "# Input pattern %d:\n", r);
    for c = 1:inc
      fprintf (outf, "%f ", in (r,c));
    endfor
    fprintf (outf, "\n");
    if (outc > 0)
      fprintf (outf, "# Output pattern %d:\n", r);
      for c = 1:outc
	fprintf (outf, "%f ", out (r,c));
      endfor
      fprintf (outf, "\n");
    endif
  endfor

  fclose (outf);

endfunction
