%%NAME
%%  eaxis - draw scaled axis
%%
%%SYNOPSIS
%%  eaxis(xPos,yPos,length,type,scale[,angle[,color]])
%%
%%PARAMETER(S)
%%  xPos     x-value of start position of axis
%%  yPos     y-value of start position of axis
%%  length   length  of axis 
%%  type     orientation of scaling  'w'=west, 'e'=east, 's'=south, 'n'=north 
%%  scale    vector of scaling, [startValue stepValue endValue]
%%  angle    angle to rotate axis 
%%  color    color of axis
%% 
%%GLOBAL PARAMETER(S)
%%  eXAxisSouthValueFormat
%%  eYAxisWestValueFormat
%%  eXAxisNorthValueFormat
%%  eYAxisEastValueFormat
%%  eXAxisSouthValueVisible
%%  eYAxisWestValueVisible
%%  eXAxisNorthValueVisible
%%  eYAxisEastValueVisible
%%  eAxesColor
%%  eAxesValueFontSize
%%  eAxesValueSpace
%%  eAxesLineWidth
%%  eAxesTicShortLength
%%  eAxesTicLongLength
%%  eAxesTicLongMaxN
%%
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function eaxis(xPos,yPos,length,type,scale,angle,color)
  eglobpar;
  if nargin>7 | nargin<5
    usage('eaxis(xPos,yPos,length,type,scale[,angle[,color]])');
  end
  if nargin<7
    color=eAxesColor;
  end 
  if nargin<6
    angle=0;
  end 
  if type=='s'
   valueFormat=eXAxisSouthValueFormat;
   valueVisible=eXAxisSouthValueVisible;
  elseif type=='w'
   valueFormat=eYAxisWestValueFormat;
   valueVisible=eYAxisWestValueVisible;
  elseif type=='n'
   valueFormat=eXAxisNorthValueFormat;
   valueVisible=eXAxisNorthValueVisible;
  else
   valueFormat=eYAxisEastValueFormat;
   valueVisible=eYAxisEastValueVisible;
  end

  escalexy(eFile,type,xPos*eFac,yPos*eFac,...
           0,angle,length*eFac,scale(1),scale(2),scale(3),...
           valueFormat,valueVisible,...
           eAxesValueFontSize*eFac,...
           eAxesLineWidth*eFac,...
           eAxesTicShortLength*eFac,...
           eAxesTicLongLength*eFac,...
           eAxesTicLongMaxN,...
           eAxesValueSpace*eFac,...
           color);
