%%NAME
%%  egrid - draw grid
%%
%%SYNOPSIS
%%  egrid([xAxisSouthScale,yAxisWestScale[,xAxisNorthScale,yAxisEastScale]])
%%
%%PARAMETER(S)
%%  xAxisSouthScale   scale vector of south axis [start step end]
%%  yAxisWestScale    scale vector of west axis  [start step end]
%%  xAxisNorthScale   scale vector of north axis [start step end]
%%  yAxisEastScale    scale vector of east axis  [start step end]
%%
%%    special cases of scale vectors are:
%%      if start=0 and end=0 then autorange=on 
%%      if step=0 then autoscale=on
%%    (default scale vector=[0 0 0])
%% 
%%GLOBAL PARAMETER(S)
%%  eXAxisSouthScale
%%  eXAxisSouthScaleType
%%  eYAxisWestScale
%%  eYAxisWestScaleType
%%  eXAxisNorthScale
%%  eYAxisEastScale
%%  ePlotAreaPos
%%  ePlotAreaWidth
%%  ePlotAreaHeight
%%  eXGridVisible
%%  eYGridVisible
%%  eAxesTicLongMaxN
%%  eXGridLineWidth
%%  eXGridColor
%%  eXGridDash
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function egrid(xAxisSouthScale,yAxisWestScale,xAxisNorthScale,yAxisEastScale)
  if rem(nargin,2) | nargin>4
    usage('egrid ([xAxisSouthScale,yAxisWestScale[,xAxisNorthScale,yAxisEastScale]])');
  end
  eglobpar;
  if nargin>0
    eXAxisSouthScale=xAxisSouthScale;
    ePlotAreaXValueStart=eXAxisSouthScale(1);
    ePlotAreaXValueEnd=eXAxisSouthScale(3);
    eYAxisWestScale=yAxisWestScale;
    ePlotAreaYValueStart=eYAxisWestScale(1);
    ePlotAreaYValueEnd=eYAxisWestScale(3);
    ePlotAreaXFac=ePlotAreaWidth*eFac/...
      (ePlotAreaXValueEnd-ePlotAreaXValueStart);
    ePlotAreaYFac=ePlotAreaHeight*eFac/...
      (ePlotAreaYValueEnd-ePlotAreaYValueStart);
  end
  if nargin>2
    eXAxisNorthScale=xAxisNorthScale;
    eYAxisEastScale=yAxisEastScale;
  end
  if nargin==0
    if eXAxisSouthScale(1)~=eXAxisSouthScale(3)
      ePlotAreaXValueStart=eXAxisSouthScale(1);
      ePlotAreaXValueEnd=eXAxisSouthScale(3);
    end
    if eYAxisWestScale(1)~=eYAxisWestScale(3)
      ePlotAreaYValueStart=eYAxisWestScale(1);
      ePlotAreaYValueEnd=eYAxisWestScale(3);
    end
  
    % scale and draw axes
    if eXGridVisible
      if eXAxisSouthScaleType==0
        egridxy(eFile,'s',...
              ePlotAreaPos(1)*eFac,...
              ePlotAreaPos(2)*eFac,...
              ePlotAreaWidth*eFac,...
              ePlotAreaXValueStart,...
              eXAxisSouthScale(2),...
              ePlotAreaXValueEnd,...
              eAxesTicLongMaxN,...
              ePlotAreaHeight*eFac,...
              eXGridLineWidth*eFac,...
              eXGridColor,...
              eXGridDash*eFac);
      elseif eXAxisSouthScaleType==1
        egridcl(eFile,'s',...
              ePlotAreaPos(1)*eFac,...
              ePlotAreaPos(2)*eFac,...
              ePlotAreaWidth*eFac,...
              ePlotAreaXValueStart,...
              eXAxisSouthScale(2),...
              ePlotAreaXValueEnd,...
              eAxesTicLongMaxN,...
              ePlotAreaHeight*eFac,...
              eXGridLineWidth*eFac,...
              eXGridColor,...
              eXGridDash*eFac);
      end
    end
    if eYGridVisible
      if eYAxisWestScaleType==0
        egridxy(eFile,'w',...
              ePlotAreaPos(1)*eFac,...
              ePlotAreaPos(2)*eFac,...
              ePlotAreaHeight*eFac,...
              ePlotAreaYValueStart,...
              eYAxisWestScale(2),...
              ePlotAreaYValueEnd,...
              eAxesTicLongMaxN,...
              ePlotAreaWidth*eFac,...
              eYGridLineWidth*eFac,...
              eYGridColor,...
              eYGridDash*eFac);
      elseif eYAxisWestScaleType==1
        egridcl(eFile,'w',...
              ePlotAreaPos(1)*eFac,...
              ePlotAreaPos(2)*eFac,...
              ePlotAreaHeight*eFac,...
              ePlotAreaYValueStart,...
              eYAxisWestScale(2),...
              ePlotAreaYValueEnd,...
              eAxesTicLongMaxN,...
              ePlotAreaWidth*eFac,...
              eYGridLineWidth*eFac,...
              eYGridColor,...
              eYGridDash*eFac);
      end
    end
  end
