## Copyright (C) 2000  Etienne Grossman
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

##       i = ind2sub(sz,r,c) = ind2sub(sz,[r,c])
## 
## i is the indice of element (r,c) in a matrix of size sz. That is, 
## i=(c-1)*sz(1)+r
##
## See also sub2ind.
##

## Author:        Etienne Grossmann  <etienne@isr.ist.utl.pt>
## Last modified: January 2000

function ii = ind2sub(sz,r,c)
  if nargin==2,
    if size(r,2)==2,		# Assume it's [r,c]
      c = r(:,2);
      r = r(:,1);
    else			# Assume it's [r;c]
      c = r(2,:);
      r = r(1,:);
    end
  elseif nargin!=3,
    printf("ind2sub : 2 or 3 args are needed\n");
    keyboard
  end
  ii=(c-1)*sz(1)+r;
