/*

Copyright (C) 1996, 1997 John W. Eaton

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.

*/

#if !defined (octave_oct_cmplx_h)
#define octave_oct_cmplx_h 1

// By using this file instead of <complex>, we can easily avoid buggy
// implementations of the standard complex data type (if needed).

#include <complex>

namespace octave
{
  typedef std::complex<double> complex;

#if 0
#if defined (CXX_ISO_COMPLIANT_LIBRARY)

  // If namespaces don't work, we will end up with some infinite looping.

  inline double real (const complex& z)
  {
    return std::real (z);
  }

  inline double
  imag (const complex& z)
  {
    return std::imag (z);
  }

  inline double
  abs (const complex& z)
  {
    return std::abs (z);
  }

  inline double
  arg (const complex& z)
  {
    return std::arg (z);
  }

  inline double
  norm (const complex& z)
  {
    return std::norm (z);
  }

  inline complex
  conj (const complex& z)
  {
    return std::conj (z);
  }

  inline complex
  cos (const complex& z)
  {
    return std::cos (z);
  }

  inline complex
  cosh (const complex& z)
  {
    return std::cosh (z);
  }

  inline complex
  exp (const complex& z)
  {
    return std::exp (z);
  }

  inline complex
  log (const complex& z)
  {
    return std::log (z);
  }

  inline complex
  log10 (const complex& z)
  {
    return std::log10 (z);
  }

  inline complex
  pow (const complex& z, int n)
  {
    return std::pow (z, n);
  }

  inline complex
  pow (const complex& z, const double& x)
  {
    // XXX FIXME XXX -- this should not be needed, but it avoids a bug
    // in some versions of libstdc++ (3.3.x and possibly others).

    return std::pow (z, complex (x));
  }

  inline complex
  pow (const complex& z1, const complex& z2)
  {
    return std::pow (z1, z2);
  }

  inline complex
  pow (const double& x, const complex& z)
  {
    return std::pow (x, z);
  }

  inline complex
  sin (const complex& z)
  {
    return std::sin (z);
  }

  inline complex
  sinh (const complex& z)
  {
    return std::sinh (z);
  }

  inline complex
  sqrt (const complex& z)
  {
    return std::sqrt (z);
  }

  inline complex
  tan (const complex& z)
  {
    return std::tan (z);
  }

  inline complex
  tanh (const complex& z)
  {
    return std::tanh (z);
  }
#endif
#endif
}

typedef octave::complex Complex;

#endif

/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; End: ***
*/
