## Copyright (C) 2005 Shai Ayal
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## OctPlot is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with OctPlot; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{h}} = legend (@var{args})
## Controls the legend in the current axes. The followign combinations
## of input arguments are accepted:
##
## @table @samp
## @item legend(@var{vis})
## where @var{vis} is a string with a value of @code{on}, @code{off}, 
## @code{hide}, @code{show}, or @code{toggle} controls the legends 
## visibility.
##
## @item legend("lab1","lab2",...)
## Sets the labels of the lines in the current plot. The order of the
## lines is the order of their handles in the axes' "Children" property.
## An empty label ommits the line from the legend.
##
## @item legend(...,"Location",@var{loc})
## Sets the location of the legend to @var{loc}. Refer to the legend
## properties for legal values of @var{loc}
## @end table
##
## legend returns the handle of the current axes' legend 
## @end deftypefn
## @seealso{axes,line}

## Author: Shai Ayal <shaiay@users.sourceforge.net>
## Keywords: octplot graphics

function handle = legend (varargin)

  lgnd = get(gca(),"legend");
  
  if length(varargin)==1,
    arg1 = varargin{1};
    if isstr(arg1),
      if strcmp(arg1,"show") | strcmp(arg1,"on"),
	set(lgnd,"visible","on");
      elseif strcmp(arg1,"hide") | strcmp(arg1,"off"),
	set(lgnd,"visible","off");
      elseif strcmp(arg1,"toggle") ,
  if(strcmp(get(lgnd,"visible"),"on"))
    set(lgnd,"visible","off");
  else
      set(lgnd,"visible","on");
  endif
      endif
    endif
  else
    ## check for location
    if length(varargin)>=2,
      if isstr(varargin{end-1}) & isstr(varargin{end})
	if strcmp(varargin{end-1},"Location")
	  set(lgnd,"Location",varargin{end});
	endif
      endif
    endif
    is=1;
    for i=1:length(varargin)
      if ~isstr(varargin{i}),
	is = 0;
      endif
    endfor
    if is,
      chld = get(gca(),"children");
      li = 1;
      ci = 1;
      while(li<=length(varargin) & ci<=length(chld))
	if strcmp(get(chld(ci),"type"),"Line"),
	  set(chld(ci++),"label",varargin{li++});
	endif
      endwhile
    endif
  endif
      
  
  if nargout , handle=lgnd ; endif

endfunction
