%define name omlcs
%define ver 0.0.10
%define APCONF /etc/httpd/httpd.conf
%define APSRM /etc/httpd/httpd.conf

Summary: Markup language converter to html.
Name: %name
Version: %ver
Release: 1
Copyright: GPL
Group: unknown
Source: http://www.opal.dhs.org/programs/omlcs/%{name}-%{ver}.tar.gz
URL: http://www.opal.dhs.org/programs/omlcs
BuildArchitectures: noarch
Packager: Ola Lundqvist <opal@lysator.liu.se>
BuildRoot: /var/tmp/%{name}-%{ver}-root

%description
OpaL Markup Language Content System is a extended html-like language defined in xml. The oml parser is written in php with the help of the xml module. It supports quite a lot of features and makes writing of content lot easier because it can fetch data from other files in a automated way.

%changelog
* Sun Okt 05 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.10 (autoupdate by orm)
* Sun Sep 14 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.7 (autoupdate by orm)
* Sun Aug 29 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.6 (autoupdate by orm)
* Sun Aug 29 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.5 (autoupdate by orm)
* Sun Aug 27 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.4 (autoupdate by orm)
* Sun Aug 26 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.3 (autoupdate by orm)
* Sat Jul 29 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.2 (autoupdate by orm)
* Fri Jul 28 2000  Ola Lundqvist <opal@lysator.liu.se>
- Updated spec to version 0.0.1 (autoupdate by orm)

%prep
%setup -q -n %{name}-%{ver}

%build
autoconf
./configure --prefix=/usr
make

%install
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/etc/httpd/conf
cp -f conf/* $RPM_BUILD_ROOT/etc/httpd/conf

%clean
#rm -fr $RPM_BUILD_ROOT

%post
if [ -z "$(grep omlcs %{APCONF})" ]; then
    echo "\#Added by omlcs" >> %{APCONF}
    echo "Include omlcs.conf" >> %{APCONF}
    echo "" >> %{APCONF}
else
    echo "Uncommenting include for omlcs in apache access.conf"
    perl -pi -e 's/#?(\s*Include\s+omlcs\.conf)/$1/gi;' %{APCONF}
fi
chown nobody.nobody /var/cache/omlcs
chmod g+ws /var/cache/omlcs
if [ -z "$(grep index.oml %{APSRM})" ]; then
    echo "Adding index.oml to DirectoryIndex."
    perl -pi -e 's/(DirectoryIndex\s+[^\n]*)/$1 index.oml/gi;' %{APSRM}
fi
if [ -z "$(grep -e 'AddType.*\.oml' %{APSRM})" ]; then
    echo "Adding .oml to AddType ...x-httpd-php."
    perl -pi -e 's/#?[^\n]*(AddType\s+application\/x-httpd-php3?\s+[^\n]*)/$1 .oml/gi;' %{APSRM}
fi

%postun
perl -pi -e 's/#?\s*(Include.*omlcs.conf)/#$1/gi;' %{APCONF}
perl -pi -e 's/\s+index.oml//gi;' %{APCONF}
perl -pi -e 's/\s+.oml//gi;' %{APCONF}

%files
%defattr(-,root,root)
%doc NEWS README ChangeLog INSTALL TODO COPYING BUGS
/var/cache/omlcs
/usr/lib/omlcs
#/etc/omlcs
/etc/httpd/conf/*
/usr/share/omlcs
