# dir.mms for omnithread shared library
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# (Note that this is backwards from dir.mk since MMS has no $(word...).

major_version = 1
minor_version = 2
micro_version = 1

VERSION = $(major_version).$(minor_version).$(micro_version)

# assume that the parent directory is built and that therefore
# $(libpath)omnithread$(DebugSuffix).olb exists.

staticlib=[-]omnithread$(DebugSuffix).olb
shareableimage=omnithread$(ShareableImageSuffix).exe
exportshareableimage=$(libpath)$(shareableimage)

# OBJ_LIBS = $(staticlib)

all :: $(shareableimage)

$(shareableimage) : $(staticlib)
	$(CxxShareableImage)

export :: all

export :: $(exportshareableimage)

$(exportshareableimage) : $(shareableimage)
	$(ExportShareable)

veryclean ::
	@- $(RM) $(shareableimage)
	@- $(RM) *.opt *.dat *.mar
