# -*- Makefile -*-

################################################################################
# afterdir.mms - standard make stuff to go after dir.mms
################################################################################

#
# Macro used in rules for building subdirectories
#
MakeSubdirs=@$(MK_V)makesubdirs.dcl "$(MMSQUALIFIERS)" $@ \
"$(SUBDIRS)"

#
# Rules for cleaning.  Note that the /exclude qualifier is an anachronism
# retained for safety.
#
RM_FLAGS = /Exclude=(DESCRIP.MMS,DIR.MMS)/Log
RM = @$(MK_V)rm.dcl "$(RM_FLAGS)"
RemoveCorbaStubs = @$(MK_V)RemoveCorbaStubs.dcl "@omniMk:rm.dcl" \
"$(RM_FLAGS)" "$(CORBA_INTERFACES)" "corbastubs:"

clean ::
	$(VERBOSITY) purge
	$(VERBOSITY) $(RM) *.obj *.exe *.olb
	$(VERBOSITY) $(RM) *.lis *.dia *.olb *.map
	$(VERBOSITY) $(RM) $(CONFIG_DIR_V)*.* $(CONFIG_DIR_V).dir
	$(VERBOSITY) $(RM) [.cxx_repository]*.* cxx_repository.dir 
	$(VERBOSITY) $(RM) cxx_repository.opt
	$(VERBOSITY) $(RM) *.d
	$(VERBOSITY) @$(MK_V)removedir.dcl "$(dir_initialized)"

veryclean ::
	$(VERBOSITY) purge
	$(VERBOSITY) $(RM) *.obj *.exe *.olb
	$(VERBOSITY) $(RM) *.lis *.dia *.olb *.map
	$(VERBOSITY) $(RM) $(CONFIG_DIR_V)*.* $(CONFIG_DIR).dir
	$(VERBOSITY) $(RM) [.cxx_repository]*.* cxx_repository.dir 
	$(VERBOSITY) $(RM) cxx_repository.opt
	$(VERBOSITY) @$(MK_V)removedir.dcl "$(dir_initialized)"
	$(VERBOSITY) $(RM) *.d
	$(VERBOSITY) $(RemoveCorbaStubs)
	$(VERBOSITY) $(MakeSubDirs)
	$(VERBOSITY) $(CONFIG_RECURSE_)

###############################################################################
#
# rules for exporting.
#

Export = @$(MK_V)Export.dcl

ExportHeader = @$(MK_V)ExportHeader.dcl "$<"\
 'f$parse("$@","","","device")''f$parse("$@","","","directory")'

ExportExecutable = $(Export) $< $(BINPATH_V)
# Note using omnilib: rather than $(LIBPATH_V) to avoid hateful
# "%DCL-W-TKNOVF, command element is too long - shorten" messages
ExportLibrary = $(Export) $< omnilib:
ExportShareable = @$(MK_V)ExportShareable.dcl $< omnilib: $(CONFIG_SUFFIX)

# Rule to export python files.
#
# Note that while other platforms will copy files one at a time, the VMS rule
# does this in a single step.
#

LIBPYPATH_V=$(SUBST ..,-,$(EXPORT_TREE)/lib/python)
LIBPYPATH_V=$(SUBST /,.,$(LIBPYPATH_V))
LIBPYPATH_V=[$(SUBST .-,-,$(LIBPYPATH_V))]
ExportPythonFiles = @$(MK_V)ExportPythonFiles.dcl $(LIBPYPATH_V)

# Note that this is roughly equivalent to:
#
#	ExportPythonFiles =\
#	backup [...]*.py; $(EXPORT_TREE)[LIB.PYTHON...]*.*; /log
#
# with dependency checking.
#
# This could be improved by doing something like:
#
#	dir.mms
#	=======
#	pysrcs=foo.py bar.py
#
#	export :: $(pytargets)
#
# and have $(MK_V)premake.mms create the pytargets macro and
# individual dependency rules.
#
################################################################################
#
# C++ compiling and linking.
#

.IFDEF DEBUG
CONFIG_RECURSE_=! no more configs
CONFIG_CXXFLAGS=/Debug/Noopt
CONFIG_CXXLINKFLAGS=/Debug
CONFIG_DIR=debug
.ELSE
CONFIG_RECURSE_=$(mms) $(mmsqualifiers) /macro=(DEBUG=1) $(mmstargets)
CONFIG_CXXFLAGS=$(RELEASE_DEBUG)
CONFIG_DIR=release
.ENDIF
CONFIG_DIR_V=[.$(CONFIG_DIR)]

.IFDEF CXX6
# 6.0 compiler warns about idl generated code.
#COMPILER_CXXFLAGS = /Quiet

COMPILER_CXXFLAGS=/Standard=strict
COMPILER_CXXNOWARN=NOSTDLONGLONG DOLLARID EXTRASEMI
.ELSE
# The namespace hack causes %CXX-W-CANTCOMPLETE warnings with Compaq C++ 5.6
COMPILER_CXXNOWARN = CANTCOMPLETE
.ENDIF


OMNIORB_CXXFLAGS = /Mms=file=.d/Diag\
$(OMNIORB_CXXFLOAT)$(CONFIG_CXXFLAGS)$(COMPILER_CXXFLAGS)

OMNIORB_CXXLINKFLAGS=$(CONFIG_CXXLINKFLAGS)
OMNIORB_CXXREPOSITORIES=$(OMNIORB_LIB_REPOSITORY)

.ifdef DIR_CXXNAMEQUAL
CXXNAMEQUAL=$(DIR_CXXNAMEQUAL)
.else
CXXNAMEQUAL=/name=as_is
.endif

CXXNOWARN_LIST=$(COMPILER_CXXNOWARN) $(DIR_CXXNOWARN)
CXXNOWARN_CAR=$(word 1,$(CXXNOWARN_LIST))
CXXNOWARN_CDR=$(patsubst ?*?,*,$(subst ?$(CXXNOWARN_CAR)?,,$(patsubst *,?*?,$(CXXNOWARN_LIST))))
CXXNOWARN_QUAL=/WARN=(DISA=($(CXXNOWARN_CAR)$(foreach msgid,$(CXXNOWARN_CDR),,$(msgid))))

# Miscellaneous qualifiers for the cxx compiler.
CXXFLAGS = $(PLATFORM_CXXFLAGS) $(OMNIORB_CXXFLAGS) $(CXXNAMEQUAL)$(CXXNOWARN_QUAL)$(DIR_CXXFLAGS)

# list of macro definitions.
CXXMACROS = $(OMNIORB_CXXMACROS) $(DIR_CXXMACROS)

.ifdef CORBA_INTERFACES
STUB_INCLUDE=/corbastubs ../include
.endif

# list of include directories for the /include qualifier
CXXINCLUDES = $(STUB_INCLUDE) $(OMNIORB_CXXINCLUDES) $(DIR_CXXINCLUDES)

# List of repository directories for the /repository qualifier.  Note
# that DIR_CXXREPOSITORIES will always be defined in order to ensure
# that user instantiations don't wind up in the library repository.
# This is also why DIR_CXXREPOSITORIES is first (the writable
# repository).

.ifdef DIR_CXXREPOSITORIES
.else
DIR_CXXREPOSITORIES=[.CXX_REPOSITORY]
.endif

CXXREPOSITORIES=$(DIR_CXXREPOSITORIES) $(OMNIORB_CXXREPOSITORIES)

CXXCompile=@$(MK_V)CXXCompile.dcl "$(CXXFLAGS)" "$(CXXMACROS)" "$(CXXINCLUDES)"\
	"$(CXXREPOSITORIES)" $< $@

.CC.OBJ :
	$(VERBOSITY) $(CXXCompile)

.cc.obj :
	$(VERBOSITY) $(CXXCompile)

CXXExecutable = @$(MK_V)CXXExecutable.dcl "$@" "$<"\
	"$(OBJ_LIBS)"\
	"$(PLATFORM_CXXLINKFLAGS)$(OMNIORB_CXXLINKFLAGS)$(DIR_CXXLINKFLAGS)"\
	"$(CXXREPOSITORIES)"

SHARE_CXXLINKFLAGS=$(PLATFORM_CXXLINKFLAGS)$(OMNIORB_CXXLINKFLAGS)\
/NoTemplate_prelink$(DIR_CXXLINKFLAGS)

#CXXShareableImage = @$(MK_V)CXXShareableImage.dcl "$@"\
#	"$<" "$(OBJ_LIBS)"\
#	"$(SHARE_CXXLINKFLAGS)"\
#	"$(LIB_VERSION)" "$(CXXREPOSITORIES)"

CXXShareableImage = python $(TOP)/mk/cxxshareableimage.py "$@"\
	"$<" "$(OBJ_LIBS)"\
	"$(SHARE_CXXLINKFLAGS)"\
	"$(LIB_VERSION)" ""

# Comment out $(CXXREPOSITORIES) to avoid hateful %DCL-W-TKNOVF
# messages.  cxxshareableimage.py will use [.cxx_repository] by default.
#	"$(LIB_VERSION)" "$(CXXREPOSITORIES)"

UpdateDemangler=@omnimk:UpdateDemangler.dcl
#
################################################################################

################################################################################
#
# C compiling
#

.ifdef DECC
OMNIORB_CFLAGS=/MMS=file=.d/Diag
.endif

CFLAGS = $(OMNIORB_CFLAGS) $(DIR_CFLAGS)

# list of macro definitions.
CMACROS = $(OMNIORB_CMACROS) $(DIR_CMACROS)

# list of include directories for the /include qualifier
CINCLUDES = $(OMNIORB_CINCLUDES) $(DIR_CINCLUDES)

CCompile=@$(MK_V)CCompile.dcl "$(CFLAGS)" "$(CMACROS)" "$(CINCLUDES)"\
	$< $@

.C.OBJ :
	$(VERBOSITY) $(CCompile)

.c.obj :
	$(VERBOSITY) $(CCompile)

CExecutable = @$(MK_V)CLinkCommand.dcl "/Exec=$@" "$<"\
	"$(OBJ_LIBS)"\
	"$(PLATFORM_CLINKFLAGS)$(OMNIORB_CLINKFLAGS)$(DIR_CLINKFLAGS)"\
	"$(CXXREPOSITORIES)"
#
################################################################################

################################################################################
# reconfigure rule							       #
################################################################################

.ifdef autoconfig

reconfigure ::
	$(VERBOSITY) $(RM) $(MK_V)platform.mms
	$(VERBOSITY) $(CONFIGURE_PLATFORM)

.endif

FIRSTACTIONS = @$(MK_V)firstactions.dcl\
 "$(BINPATH_V)" "$(PLATFORM)" "$(LIBPATH_V)"

OMNIIDL_CXX = omniidl ""-bcxx""
BuildCorbaStubs = @$(MK_V)BuildCorbaStubs.dcl "$(CORBA_INTERFACES)"\
	"$(OMNIIDL_CXX)"\
	"$(CXXFLAGS)" "$(CXXMACROS)" "$(CXXINCLUDES)" "$(CXXREPOSITORIES)"\
	"$(OMNIORB_IDL_FLAGS) $(DIR_IDLFLAGS)"

OMNIIDL_COMPILE=$(OMNIORB_IDL) $(OMNIORB_IDL_FLAGS) $(DIR_IDLFLAGS)

.ifdef autoconfig

CONFIGURE_PLATFORM=if f$search("$(MK_V)platform.mms") .eqs. "" then\
	@$(MK_V)autoconfig.dcl

.endif

.ifdef COMPILE_VERIFY
.else
COMPILE_VERIFY=0
.endif

.ifdef $(dir_initialized)

.ifdef CORBA_INTERFACES
.first
	$(VERBOSITY) $(FIRSTACTIONS)
	$(VERBOSITY) $(DIR_FIRSTACTIONS)
	$(VERBOSITY) COMPILE_VERIFY==$(COMPILE_VERIFY)
	$(VERBOSITY) nocleantarget=f$locate("CLEAN",F$EDIT("$(mmstargets)","UPCASE"))\
		.EQ. F$LENGTH("$(mmstargets)")
	$(VERBOSITY) if nocleantarget THEN $(BuildCorbaStubs)

.else	# corba_interfaces not defined

.first
	$(VERBOSITY) $(FIRSTACTIONS)
	$(VERBOSITY) $(DIR_FIRSTACTIONS)
	$(VERBOSITY) COMPILE_VERIFY==$(COMPILE_VERIFY)

.endif	# corba_interfaces

.else # $(dir_initialized)

all :: reconfigure

.endif	# $(dir_initialized)
