import string
import re
import sys
headerDependencyRule=\
'''%(exportHeaderDir)s%(headerName)s : %(headerName)s
	@ $(ExportHeader)
'''

stubDependencyRule=\
'''%(idl)s.hh %(idl)sSK.cc %(idl)sDynSK.cc : %(idldir)s%(idl)s.idl
	backup $< [] /new/log
	%(idlcmd)s %(idloptions)s %(idl)s.idl
'''


class InterfaceList:

    def __init__(self, interfaces):
        self.interfaces=interfaces
        self.idloverrides={}
        self.idloptions=''
        self.moreHeaders=[]

    def idlCommand(self, idlcmd):
        self.idlcmd=idlcmd

    def idlDirectory(self, idldir):
        self.idldir=idldir

    def exportHeaderDirectory(self, exportHeaderDir):
        self.exportHeaderDir=exportHeaderDir

    def overridable(self, idloptions):
        self.idloptions=idloptions

    def override(self, interface, idloptions):
        '''Override the IDL options for the given IDL interface.'''
        self.idloverrides[interface]=idloptions

    def extraHeaders(self, headers):
        self.moreHeaders=headers

    def generateHeading(self):
        import time
        print '''# -*- Makefile -*-
##############################################################################
# Automatically generated by %s
# Do not edit!
# Generation date: %s
##############################################################################

.include cosinterfaces.mms

''' % (sys.argv[0],time.asctime(time.localtime(time.time())))

    def generateHeaderDependencies(self):
        print '''# headers to be exported to %s''' % self.exportHeaderDir
        print
        for header in self.moreHeaders:
            self.headerName=header
            print headerDependencyRule % self.__dict__
        for interface in self.interfaces:
            self.headerName=interface+'.hh'
            print headerDependencyRule % self.__dict__
        if hasattr(self,'headerName'):
            del self.headerName

    def generateIdlDependencies(self):
        print '''# Rules to generate the stubs'''
        print
        for interface in self.interfaces:
            self.idl=interface
            keep=self.idloptions
            if self.idloverrides.has_key(interface):
                self.idloptions=self.idloverrides[interface]
            print stubDependencyRule % self.__dict__
            self.idloptions=keep
        if hasattr(self,'idl'):
            del self.idl

    def ccDfile(self, file):
        dFileName=file+".d"
        print '''.include %s''' % dFileName
        # It turns out that CXX gets the /mms output wrong (object
        # file is missing dirspec).
        open(dFileName,"w").write(
            "$(CONFIG_DIR_V)%s.obj : %s.cc\n" % (file,file))

    def generateStubDependencies(self):
        print '''# C++ compiler generated dependencies.'''
        print
        for interface in self.interfaces:
            self.ccDfile(interface+"SK")
            self.ccDfile(interface+"DynSK")

    def generateExportHeaderDeps(self):
        print '''# Rules to export interface headers.'''
        print
        headers=self.moreHeaders
        for interface in self.interfaces:
            headers.append(interface+'.hh')
        format='export :: '+self.exportHeaderDir+'%s\\'
        for header in headers[:-1]:
            print format % header
            format='\t'+self.exportHeaderDir+'%s\\'
        print format[:-1] % headers[-1]

    def generateCxxsrcDefinitions(self):
        print "# Overcome DCL stupidity"
        macroNames=["CXXSRCS"]
        for num in range(0,10):
            macroNames.append("CXXSRCS_%d" % num)
        chunksize=(len(self.interfaces)+10)/11
        deepcopy=interfaces[:]
        for macro in macroNames:
            format=macro+"=%sSK.cc %sDynSK.cc\\"
            chunk=deepcopy[:chunksize]
            del deepcopy[:chunksize]
            for interface in chunk[:-1]:
                print format % (interface,interface)
                format='\t%sSK.cc %sDynSK.cc\\'
            interface=chunk[-1]
            print format[:-1] % (interface,interface)

    def generate(self):
        self.generateHeading()
        self.generateHeaderDependencies()
        self.generateIdlDependencies()
        self.generateStubDependencies()
        self.generateExportHeaderDeps()
        self.generateCxxsrcDefinitions()


class MacroParser:

    '''Naive MMS macro parser.'''

    def parse(self, fileName):
##        print '''### parsing %s''' % fileName
        self.lastFileName=fileName
##        print '''### preprocessing...''',
        self.__preprocess(open(self.lastFileName))
##        print '[ok]'
##        print '### parsing assignments...',
        self.__parseAssignments()
##        print '[ok]'

    def __init__(self):
        self.__symbolTable={}

    def __preprocess(self, f):
        lines=f.readlines()
        self.__lines=[]
        oline=''
        for line in lines:
            line=string.join(string.split(line))
            pos=string.find(line,'#')
            if pos != -1:
                line=string.strip(line[:pos])
            pos=string.find(line,'!')
            if pos != -1:
                line=string.strip(line[:pos])
            if not line:
                continue
            cont=0
            if line[-1] in '\\-':
                line=string.strip(line[:-1])
                cont=1
            if oline:
                oline=oline+' '+line
            else:
                oline=line
            if oline and not cont:
                self.__lines.append(oline)
                oline=''
        if oline:
            self.__lines.append(oline)
        return self.__lines

    referenceExpression=re.compile("""\$\(([a-zA-Z0-9_]+)\)""")
    foreachExpression=re.compile(
        """\$\(foreach ([a-zA-Z0-9_]+),([^,]*),([^)]+)\)""")
    postExpression=re.compile("""#([a-zA-Z0-9_]+)#""")
    def __substituteVars(self, value):
        match=self.referenceExpression.search(value)
        while match:
            symbolName=string.lower(string.strip(match.group(1)))
            if self.__symbolTable.has_key(symbolName):
                value = value[:match.start()]\
                        + self.__symbolTable[symbolName]\
                        + value[match.end():]
                match=self.referenceExpression.search(value)
            else:
                # Using '#' as a deliminter here is safe because we've
                # already removed comments.
                value = string.join([value[:match.start()],
                                     symbolName,
                                     value[match.end():]],
                                    "#")
                match=self.referenceExpression.search(value,match.end())
        match=self.foreachExpression.search(value)
        while match:
##            print '''### parsing foreach expression: %s''' % match.group(0)
            symbolName=match.group(1).lower()
            words=match.group(2)
            subs=match.group(3)
            result=''
            for word in string.split(words):
##                print '''### Locating %s references in %s''' % (
##                    symbolName, subs),
                repl=subs
                repm=self.postExpression.search(repl)
                while repm:
                    if repm.group(1).lower()==symbolName:
                        repl = repl[:repm.start()]+word+repl[repm.end():]
                    repm=self.postExpression.search(repl,repm.end())
##                    print '...',repl,
##                print
                if result:
                    result=result+' '+repl
                else:
                    result=result+repl
            value = value[:match.start()]+result+value[match.end():]
            match=self.foreachExpression.search(value)

        match=self.postExpression.search(value)
        while match:
            symbolName=string.lower(string.strip(match.group(1)))
##            print '''### warning %s reference not defined in %s''' % (
##                symbolName,
##                '%s$(%s)%s' % (value[:match.start()],
##                               symbolName,
##                               value[match.end():]
##                               )
##                )
            value = value[:match.start()] + value[match.end():]
            match=self.postExpression.search(value)
        return value

    assignmentExpression=re.compile("""^([a-zA-Z0-9_]+) *= *(.*)$""")
    def __parseAssignments(self):
        for line in self.__lines:
            match=self.assignmentExpression.match(line)
            if match:
                key=string.lower(string.strip(match.group(1)))
                value=string.strip(match.group(2))
                self.__symbolTable[key]=self.__substituteVars(value)

    # Note that the following methods are a read-only subset of the
    # operations that are normally defined for a mapping type ("mapping type"
    # is Pythonese for associative array).

    def __getitem__(self,key):
        return self.__symbolTable[string.lower(key)]
    def __len__(self):
        return len(self.__symbolTable)
    def keys(self):
        return self.__symbolTable.keys()
    def values(self):
        return self.__symbolTable.values()
    def items(self):
        return self.__symbolTable.items()
    def has_key(self, key):
        return self.__symbolTable.has_key(string.lower(key))

if __name__=='__main__':
    try:
        macroParser=MacroParser()
        macroParser.parse('cosinterfaces.mms')

        interfaces=[]
        overrides=[]

        class Override:
            def __init__(self, interface, option):
                self.interface=interface
                self.option=option

        macro="COSINTERFACES"
        if macroParser.has_key(macro):
            lists=string.split(macroParser[macro])
            for list in lists:
                if macroParser.has_key(list):
                    idls=string.split(macroParser[list])
                    interfaces.extend(idls)
                    idlopt="%s_IDLOPT" % list
                    if macroParser.has_key(idlopt):
                        idlopt=macroParser[idlopt]
                        for idl in idls:
                            overrides.append(Override(idl,idlopt))

        interfaceList=InterfaceList(interfaces)
        interfaceList.idlCommand('''$(OMNIIDL_COMPILE)''')
        interfaceList.idlDirectory('''$(COSImport_V)''')
        interfaceList.exportHeaderDirectory('''$(COSInclude_V)''')
        if macroParser.has_key("COS_IDL_OPT"):
            interfaceList.overridable(macroParser["COS_IDL_OPT"])
        for override in overrides:
            interfaceList.override(override.interface,override.option)
        if macroParser.has_key("extraheaders"):
            interfaceList.extraHeaders(string.split(macroParser["extraheaders"]
                                                    ))
        interfaceList.generate()
    except Exception,e:
        print str(e)
        import traceback
        traceback.print_exc()
        sys.exit(2)
