#!/usr/bin/perl -w
#
# injectjobs.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
#
# injectjobs.pl -- injects jobs en masse into timesheet
#
# Copyright (C) 1999 onShore, Inc.
#
# Author: B. W. Fitzpatrick <fitz@onShore.com>
# Maintainer: B. W. Fitzpatrick <fitz@onShore.com>
# Created: February, 1999
#
# $Id: injectjobs.pl,v 1.4 2001/08/29 22:22:49 adam Exp $
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you can either send email to this
# program's maintainer or write to: The Free Software Foundation,
# Inc.; 59 Temple Place, Suite 330; Boston, MA 02111-1307, USA.

# ******** WARNING
# Be careful using this program. I basically wrote it in a half hour to save me the pain
# of manually adding 30 jobs
# This can easily add a bunch of crap into timesheet that you didn't want to if you're not careful
#
# Your input file should be in the format:
# JOB: Some description here                          ###
# See sample at the end of this program

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use ADB;
use strict;

if (!$ARGV[0]) {
	die "Usage: $0 jobimportfilename\n";
}
my $file = $ARGV[0];

open (JOBS, $file) || die "Can't open file $file:$!\n";

while (<JOBS>) {
	# Ignore anything that doesn't start with ^JOB:
	if (/^JOB:\s(.*?)(\d{1,3})$/) {
		my $desc = $1;
		my $hours = $2;
		$desc =~ s/\s*$//g;
		my $flaghours = int ($hours * .9);
		my $rate = '150'; # Assume programming

		if ($desc =~ /GUI/)           { $rate = '125'; }
		if ($desc =~ /HTML/)          { $rate = '75'; }
		if ($desc =~ /Documentation/) { $rate = '90'; }

		print "$hours\t$flaghours\t$rate\t$desc\n";
		&add_job_submit($desc, $hours, $flaghours, $rate);
	}
}

sub add_job_submit{
   my %new;
	$new{'job_description'} = shift @_;
	$new{'estimated_hours'} = shift @_;
	$new{'flag_hrs'} = shift @_;
	$new{'bill_rate'} = shift @_;

   $new{'fkclient_id'} = '166';                   # Client PK
   $new{'open_date'} = '02-10-1999';              # MM-DD-CCYY
   $new{'close_date'} = '12-01-1999';             # MM-DD-CCYY
   $new{'fksupervisor_id'} = 'bwf';               # User PK. bwf, for example

   $new{'fknotify_id'} = 'apharris';              # User PK. apharris, for example
   $new{'current_estimate_date'} = '12-01-1999';  # MM-DD-CCYY
   $new{'category'} = 'Development';              # Category constraint. 'Development' for example
   $new{'downloaded'} = 'n';                      # Set to 'n' for not downloaded

	$new{'open'} = 1;                              # Set to 1 for opened, 0 for closed
   $new{'default_approved'} = 0;                  # Set to 0 for hours not to be approved automatically, 1 to do so.

   &scrub_hash(\%new);
   
   my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
   my $result;
   $result = $dbconn->insert_record_seq($Conf::JOB_DB_KEY, $Conf::JOB_DB, \%new);
   if (!$result) {
      my $oops = $dbconn->errorstring;
      &error("Unable To Add Job To Backend: $oops\n");
   }
   print "Job Added, your Job Number is $result\n";
	return;
}

		

__DATA__



# Programming Rate				$150/hour
# Design Rate					$125/hour
# Documentation Rate				 $90/hour
# HTML Programmer Rate				 $75/hour
#
JOB: Project Management and QAQC		       302
JOB: Client Communications				        49

This text will be ignored because it doesn't start with JOB:

Weekly status reports				           26    
IT communication & coordination			      5    
Client manager communication			        18    
#											   
JOB: GUI Design						           63
GUI: Preliminary look & feel prototype		  23    
GUI: Design implementation				        40    
JOB: GUI Testing and Revisions				  48
GUI: Testing						              30    
GUI: Revisions						              18    
