// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_GenId_HeaderFile
#define _Aspect_GenId_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
class Aspect_IdentDefinitionError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class permits the creation and control of all <br>
//!	    identifiers. <br>
//!  Warning: An identifier is an integer. <br>
class Aspect_GenId  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an available set of identifiers with the lower <br>
//!	    bound 0 and the upper bound INT_MAX/2. <br>
Standard_EXPORT Aspect_GenId();

//! Creates an available set of identifiers with the lower <br>
//!	    bound <Low> and the upper bound <Up>. <br>
//!  Warning: Raises IdentDefinitionError if <Up> is less than <Low>. <br>//! Copies the content of <Other> into <me>. <br>
Standard_EXPORT Aspect_GenId(const Standard_Integer Low,const Standard_Integer Up);

//! Frees all identifiers of <me>. <br>
Standard_EXPORT   void Free() ;

//! Frees the identifier <Id> of <me>. <br>
Standard_EXPORT   void Free(const Standard_Integer Id) ;

//! Returns the number of available identifiers of <me>. <br>
Standard_EXPORT   Standard_Integer Available() const;

//! Returns the lower bound of <me>. <br>
Standard_EXPORT   Standard_Integer Lower() const;

//! Returns an available identifier of <me>. <br>
//!  Warning: Raises IdentDefinitionError if all identifiers are busy. <br>
Standard_EXPORT   Standard_Integer Next() ;

//! Returns the upper bound of <me>. <br>
Standard_EXPORT   Standard_Integer Upper() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer MyCount;
Standard_Integer MyLength;
Standard_Integer MyLowerBound;
Standard_Integer MyUpperBound;
TColStd_ListOfInteger MyFreeIds;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
