// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_SetOfPolylines_HeaderFile
#define _Graphic2d_SetOfPolylines_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic2d_SetOfPolylines_HeaderFile
#include <Handle_Graphic2d_SetOfPolylines.hxx>
#endif

#ifndef _Graphic2d_SequenceOfPolyline_HeaderFile
#include <Graphic2d_SequenceOfPolyline.hxx>
#endif
#ifndef _Graphic2d_Line_HeaderFile
#include <Graphic2d_Line.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
class Standard_OutOfRange;
class Graphic2d_GraphicObject;
class Graphic2d_Drawer;


//! The primitive SetOfPolylines <br>
//!  Warning: This primitive must be use as possible for to insure <br>
//!	   that the sets is drawn correctly when the line type or <br>
//!	   line width attrib is not SOLID and 1 pixel for the set. <br>
//!         NOTE: than the method PickedIndex() permits to known <br>
//!              the last picked polyline and segment in the set. <br>
class Graphic2d_SetOfPolylines : public Graphic2d_Line {

public:
 // Methods PUBLIC
 // 

//! Creates an empty set of polylines in the graphic <br>
//!         object <aGraphicObject>. <br>
Standard_EXPORT Graphic2d_SetOfPolylines(const Handle(Graphic2d_GraphicObject)& aGraphicObject);

//! Add a point in the current polyline of the set <br>
//!	    or creates a new one when <NewPolyline> flag is TRUE. <br>
Standard_EXPORT   void Add(const Quantity_Length X,const Quantity_Length Y,const Standard_Boolean NewPolyline = Standard_False) ;

//! Add a segment in the set to one of polyline <br>
//!	    which has the last point identical to one of the segment <br>
//!	    or creates a new polyline in the sets with the 2 segment points. <br>
//!	    The first point is <X1>, <Y1>. <br>
//!	    The second point is <X2>, <Y2>. <br>
Standard_EXPORT   void Add(const Quantity_Length X1,const Quantity_Length Y1,const Quantity_Length X2,const Quantity_Length Y2) ;

//! Returns the number of polylines in the set. <br>
Standard_EXPORT   Standard_Integer Length() const;

//! Returns the number of points of the polylines <br>
//!    of rank <aPrank>. <br>
//!  Trigger: Raises OutOfRange if <aPrank> is <1 or >Length() <br>
Standard_EXPORT   Standard_Integer Length(const Standard_Integer aPrank) const;

//! Returns the point of rank <aVrank> <br>
//!	    from the polyline of rank <aPrank>. <br>
//!  Trigger: Raises OutOfRange if <aPrank> is <1 or >Length() <br>
//!	 or if <aVrank> is <1 or >Length(<aPrank>) <br>
Standard_EXPORT   void Values(const Standard_Integer aPrank,const Standard_Integer aVrank,Quantity_Length& X,Quantity_Length& Y) const;


Standard_EXPORT virtual  void Save(Aspect_FStream& aFStream) const;
//Standard_EXPORT ~Graphic2d_SetOfPolylines();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Draws the set of polylines <me>. <br>
Standard_EXPORT   void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;

//! Returns Standard_True if one point of the set <me> <br>
//!	    is picked, Standard_False if not. <br>
//!  Warning: The PickIndex() method returns the rank of the picked <br>
//!	    polyline point if any under the format : <br>
//!	    (<aPrank> << 16) | <aVrank>. <br>
Standard_EXPORT   Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Graphic2d_SequenceOfPolyline myPolylines;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
