// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Real2String_HeaderFile
#define _OSD_Real2String_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_PCharacter_HeaderFile
#include <Standard_PCharacter.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  Convertion of CString to Real and reciprocally <br>
class OSD_Real2String  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT OSD_Real2String();


//!  Converts aReal into aCstring in exponential format with maximum <br>
//!  17 digits. The size of the destination string must be sufficient (at least 23 characters) <br>
//!  The decimal separator account for locale setting, but <br>
//!  neither thousand separator nor grouping of digits in the output string. <br>
//! <br>
Standard_EXPORT   Standard_Boolean RealToCString(const Standard_Real aReal,Standard_PCharacter& aString) const;


//!  Converts aCstring representing a real. The first occurence of the decimal separator <br>
//!  (comma or period) defines it values for further readings. <br>
//!  Neither thousand separator nor grouping of digits are allowed in the CString <br>
Standard_EXPORT   Standard_Boolean CStringToReal(const Standard_CString aString,Standard_Real& aReal) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myReadDecimalPoint;
Standard_Integer myLocalDecimalPoint;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
