// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _STEPCAFControl_ActorWrite_HeaderFile
#define _STEPCAFControl_ActorWrite_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_STEPCAFControl_ActorWrite_HeaderFile
#include <Handle_STEPCAFControl_ActorWrite.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _STEPControl_ActorWrite_HeaderFile
#include <STEPControl_ActorWrite.hxx>
#endif
class TopoDS_Shape;


//! Extends ActorWrite from STEPControl by analysis of <br>
//!          whether shape is assembly (based on information from DECAF) <br>
class STEPCAFControl_ActorWrite : public STEPControl_ActorWrite {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT STEPCAFControl_ActorWrite();

//! Check whether shape S is assembly <br>
//!          Returns True if shape is registered in assemblies map <br>
Standard_EXPORT virtual  Standard_Boolean IsAssembly(TopoDS_Shape& S) const;

//! Set standard mode of work <br>
//!          In standard mode Actor (default) behaves exactly as its <br>
//!          ancestor, also map is cleared <br>
Standard_EXPORT   void SetStdMode(const Standard_Boolean stdmode = Standard_True) ;

//! Clears map of shapes registered as assemblies <br>
Standard_EXPORT   void ClearMap() ;

//! Registers shape to be written as assembly <br>
//!          The shape should be TopoDS_Compound (else does nothing) <br>
Standard_EXPORT   void RegisterAssembly(const TopoDS_Shape& S) ;
//Standard_EXPORT ~STEPCAFControl_ActorWrite();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myStdMode;
TopTools_MapOfShape myMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
