// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_Transform_HeaderFile
#define _Vrml_Transform_HeaderFile

#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Vrml_SFRotation_HeaderFile
#include <Vrml_SFRotation.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class gp_Vec;
class Vrml_SFRotation;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  defines a Transform of VRML specifying transform <br>
//!          properties. <br>
//!  This  node  defines  a  geometric  3D  transformation   consisting   of  (in  order) <br>
//!  a  (possibly)  non-uniform  scale  about  an  arbitrary  point,  a  rotation  about <br>
//!  an arbitrary point  and  axis  and  translation. <br>
//!  By  default  : <br>
//!    myTranslation (0,0,0) <br>
//!    myRotation  (0,0,1,0) <br>
//!    myScaleFactor (1,1,1) <br>
//!    myScaleOrientation (0,0,1,0) <br>
//!    myCenter (0,0,0) <br>
class Vrml_Transform  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_Transform();


Standard_EXPORT Vrml_Transform(const gp_Vec& aTranslation,const Vrml_SFRotation& aRotation,const gp_Vec& aScaleFactor,const Vrml_SFRotation& aScaleOrientation,const gp_Vec& aCenter);


Standard_EXPORT   void SetTranslation(const gp_Vec& aTranslation) ;


Standard_EXPORT   gp_Vec Translation() const;


Standard_EXPORT   void SetRotation(const Vrml_SFRotation& aRotation) ;


Standard_EXPORT   Vrml_SFRotation Rotation() const;


Standard_EXPORT   void SetScaleFactor(const gp_Vec& aScaleFactor) ;


Standard_EXPORT   gp_Vec ScaleFactor() const;


Standard_EXPORT   void SetScaleOrientation(const Vrml_SFRotation& aScaleOrientation) ;


Standard_EXPORT   Vrml_SFRotation ScaleOrientation() const;


Standard_EXPORT   void SetCenter(const gp_Vec& aCenter) ;


Standard_EXPORT   gp_Vec Center() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Vec myTranslation;
Vrml_SFRotation myRotation;
gp_Vec myScaleFactor;
Vrml_SFRotation myScaleOrientation;
gp_Vec myCenter;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
