<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	
	-- CHANGLOG --
		
	Version		Comments
	-------		--------
	0.81		Initial 0.81 compliant release.
	0.81p1		Fix to parse DVD year, ratio and all item type blurbs correctly.
*/
include_once("./functions/SitePlugin.class.inc");

function mymonthtonumber($str)
{
	switch($str) {
		case 'Januar':
			$ret=1;
			break;
		case 'Februar':
			$ret=2;
			break;
		case 'Mrz':
			$ret=3;
			break;
		case 'April':
			$ret=4;
			break;
		case 'Mai':
			$ret=5;
			break;
		case 'Juni':
			$ret=6;
			break;
		case 'Juli':
			$ret=7;
			break;
		case 'August':
			$ret=8;
			break;
		case 'September':
			$ret=9;
			break;
		case 'Oktober':
			$ret=10;
			break;
		case 'November':
			$ret=11;
			break;
		case 'Dezember':
			$ret=12;
			break;
	}
	return $ret;
}

function mystrip_tags($str)
{
	//As seen on http://www.php.net/manual/de/function.preg-replace.php ....
	$search = array ("'<[\/\!]*?[^<>]*?>'si",	// Strip out html tags
			"'([\r\n])[\s]+'",		// Strip out white space
			"'&(quot|#34);'i",		// Replace html entities
			"'&(amp|#38);'i",
			"'&(lt|#60);'i",
			"'&(gt|#62);'i",
			"'&(nbsp|#160);'i",
			"'&(iexcl|#161);'i",
			"'&(cent|#162);'i",
			"'&(pound|#163);'i",
			"'&(copy|#169);'i",
			"'&#(\d+);'e");			// evaluate as php

	$replace = array ("", 
			"\\1",
			"\"", 
			"&",
			"<",
			">",
			" ",
			chr(161),
			chr(162),
			chr(163),
			chr(169),
			"chr(\\1)");

	return trim(preg_replace($search, $replace, $str));
}

class amazonde extends SitePlugin
{
	var $_pageBuffer;
	
	function amazonde($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		if(strlen($search_vars_r['amazdeasin'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('amazdeasin'=>$search_vars_r['amazdeasin']));
			return TRUE;
		}
		else
		{
			// Get the mapped AMAZON index type
			$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
			
			$queryUrl = 'http://www.amazon.de/exec/obidos/external-search?index='.$index_type.'&keyword='.rawurlencode($search_vars_r['title']).'&sz='.$items_per_page.'&pg='.$page_no;

			$this->_pageBuffer = $this->fetchURI($queryUrl);
		}
		
		if(strlen($this->_pageBuffer)>0)
		{
			$amazdeasin = FALSE;
			
			// check for an exact match, but not if this is second page of listings or more
			if(!$this->isPreviousPage())
			{
				if (preg_match("/ASIN: <font>(\w{10})<\/font>/", $this->_pageBuffer, $regs))
				{
					$amazdeasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: (\w{10})/", strip_tags($this->_pageBuffer), $regs))
				{
					$amazdeasin = trim($regs[1]);
				}
				else if (preg_match ("/ISBN: ([^;]+);/", strip_tags($this->_pageBuffer), $regs)) // for books, ASIN is the same as ISBN
				{
					$amazdeasin = trim ($regs[1]);
				} 
			}
			
			// exact match
			if($amazdeasin!==FALSE)
			{
				// single record returned
				$this->addListingRow(NULL, NULL, NULL, array('amazdeasin'=>$amazdeasin));
				
				return TRUE;
			}
			else
			{
				if(preg_match("/Alle.([0-9]+).Treffer.fr/i", $this->_pageBuffer, $regs))
				{
					// store total count here.
					$this->setTotalCount($regs[1]);
					
					$start_of_block = strpos($this->_pageBuffer, "Treffer fr", $start_of_block);
					if($start_of_block!==FALSE)
					{
						$parseblock = substr($this->_pageBuffer, $start_of_block);
						if(preg_match_all(":<a href=/exec/obidos/ASIN/([^/]+)/[^>]+><b>([^<]*)</b></a>$:m", $parseblock, $matches))
						{
							for ($i = 0; $i < count($matches[1]); $i++)
							{
								$thumbimg = NULL;
								
								if(preg_match("!<img src=\"(http://.*".$matches[1][$i].".*jpg\")[^<]*>!U", $parseblock, $regs))
									$thumbimg = $regs[1];
								
								// get rid of new lines.
								$title = preg_replace("/[ \t\r\n]+/", " ", $matches[2][$i]);
								
								$this->addListingRow($title, $thumbimg, NULL, array('amazdeasin'=>$matches[1][$i]));
							}
							
							return TRUE;
						}
					}
				}
			}
			
			//default
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	/**
	* 
	*/
	function queryItem($search_attributes_r, $s_item_type)
	{
		$this->_pageBuffer = $this->fetchURI("http://www.amazon.de/exec/obidos/ASIN/".$search_attributes_r['amazdeasin']);
		
		// no sense going any further here.
		if(strlen($this->_pageBuffer)==0)
			return FALSE;
		
		if(preg_match("/<title>.*Amazon\.de:(.*)<\/title>/s", $this->_pageBuffer, $regs))
		{
			// If extra year appended, remove it and just get the title.
			if(preg_match("/(.*)\[[0-9]+\]:(.*)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else if(preg_match("/(.*)\([0-9]+\)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else
				$title = $regs[1];
			
			$indexOf = laststrpos($title, ":");
			if($indexOf!==FALSE)
			{
				if( preg_match("/[A-Z]+$/", trim(substr($title, $indexOf+1)) ))
				{
					$title = substr($title, 0, $indexOf);
				}
			}
			
			$title = str_replace("&#160;", "", $title);
			
			$this->addItemAttribute('title', convert_html_numeric_codes(strip_tags(trim(str_replace("\"", "", $title)))));
		}
	
		// Image src extraction block
		//http://images-eu.amazon.com/images/P/B000050YLW.02._PE68_SCMZZZZZZZ_.jpg
		if (preg_match_all("!\"(http://images-eu.amazon.com/[^\"]+".$search_attributes_r['amazukasin']."[^\"]+)\"!", $this->_pageBuffer, $regs))
		{
			$imageurl = NULL;
			$timageurl = NULL;
			
			// try for a big image first, otherwise get the smaller one.			
			for($i = 0; $i < count($regs[1]); $i++)
			{
				if(strpos($regs[1][$i], "LZZZZZZ") !== FALSE)
				{
					$imageurl = $regs[1][$i];
					break;
				}
				
				if(strpos($regs[1][$i], "ZZZZZZZ") !== FALSE)
				{
					$timageurl = $regs[1][$i];
				}
			}
			
			if($imageurl == NULL && timageurl != NULL)
				$imageurl = $timageurl;
						
			// If still null!
			if($imageurl == NULL)
			{
				// If first image has 'THUM' in it, we have matched a thumbnail,
				// get the next one instead.
				// 'Breath Fire III' (GAME) is such a case.
				if(count($regs[1])>1 && strpos($regs[1][0],"THUM")!==FALSE)
					$imageurl = $regs[1][1];
				else
					$imageurl = $regs[1][0];
			}
			
			if(strlen($imageurl))
			{
				$this->addItemAttribute('imageurl', $imageurl);
			}
		}
		
		if (preg_match("/<span class=listprice>\\\$([^<]*)<\/span>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		else if (preg_match("/<font [^>]*><b>EUR ([^<]+)<\/b><\/font>/i", $this->_pageBuffer, $regs2))//<font color="#990000"><b>EUR 44,99</b></font>
		{
			$this->addItemAttribute('listprice', preg_replace('/,/', '.', trim($regs2[1])));
		}
		
		// Get the mapped AMAZON index type
		$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
				
		switch($index_type)
		{
			case 'dvd-de':
			case 'vhs-de':
				$this->parse_amazon_video_data($search_attributes_r, $s_item_type);
				break;
			
			case 'video-games-de':
				$this->parse_amazon_game_data($search_attributes_r);
				break;
				
			case 'books-de':
				$this->parse_amazon_books_data($search_attributes_r);
				break;
				
			case 'music-de':
				$this->parse_amazon_music_data($search_attributes_r);
				break;
			
			default://Not much here, but what else can we do?
				break;
		}
		
		//echo("<pre>");
		//print_r($this->getItemData());
		//echo("</pre>");
	
		return TRUE;
	}
	
	function parse_amazon_game_data($search_attributes_r)
	{
		// Publisher extraction block
		if (preg_match("|\<a href=/exec/obidos/search-handle-url/size=20&store-name=videogames&index=video-games-de&field-manufacturer=(.*?)[^>]>(.*)\</a>\</span>\</td>\</tr>|i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('gamepblshr', $regs[2]);
		}
	
		// Platform extraction block
		if (preg_match("/<b>System:[\s]*<\/b>(.+?)<br>/si", $this->_pageBuffer, $regs))
		{
			if(preg_match(":&nbsp;[\s](.*):", $regs[1], $regs2))
				$regs = trim($regs2[1]);
			else
				$regs = trim($regs[1]);
			
			// Different combo's of windows, lets treat them all as windows.
			if (strpos($regs, 'Windows') !== FALSE)
				$platform = 'Windows';
			else
				$platform = $regs;
	
			$this->addItemAttribute('gamesystem', $platform);
		}
	
		// Rating extraction block
		if (preg_match("|\<b>USK Einstufung:\</b> \<a HREF=\"(.*?)[^\"]\">(.+?)\</a>\<p>|si", $this->_pageBuffer, $regs))
		{
			if(preg_match(":/exec/obidos/subst/help/usk.html:", $regs[1], $tmp))
				$this->addItemAttribute('gamerating', $regs[2]);
			else
				$this->addItemAttribute('gamerating', strtoupper($regs[1]));
		}
	
		if(preg_match("/<b>Erscheinungsdatum:<\/b>&#160;(.*?)<br>/", $this->_pageBuffer, $regs2))
		{
			$regs2 = explode(' ', trim($regs2[1]));
			$this->addItemAttribute('gamepbdate', substr($regs2[0],0,strlen($regs2[0])-1) . '/' . mymonthtonumber($regs2[1]) . '/' . $regs2[2]);
		}
	
		if (preg_match("/Unsere Besten<\/a>\n&gt; <a href=(.*?)[^>]>(.*?)[^<]<\/a>/", $this->_pageBuffer, $regs2))
		{
			switch($regs2[2])
			{
				case 'PC Adventures & Rollenspiel':
					$regs3='Adventure';
					break;
				case 'PC Actionspiel':
					$regs3='Action';
					break;
				case 'PC Simulatione':
					$regs3='FlightSimulation';
					break;
				case 'PC Rennspiel':
					$regs3='Race';
					break;
				case 'PC Sportspiel':
					$regs3='Sports';
					break;
				case 'PC Strategiespiel':
					$regs3='RPG';
					break;
				default:
					break;
			}
			if (isset($regs3))
			{
				$this->addItemAttribute('genre', $regs3);
				unset($regs3);
			}
		}
	
		//Plot (Amazon blurb)
		$this->addItemAttribute('blurb', $this->parse_amazon_game_blurb($this->_pageBuffer));
	
		// Editorial reviews
		if(preg_match("/<a href=([^\"]+)>Alle Rezensionen ansehen/i", $this->_pageBuffer, $regs))
		{
			$detailPage = $this->fetchURI('http://www.amazon.de/' . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($detailPage)>0)
			{
				$this->addItemAttribute('blurb', $this->parse_amazon_game_blurb($detailPage));
			}
		}
	
		// Features extraction block
		if(preg_match("/<b>Features:<\/b>[\s]<ul>(.+?)<\/ul>/si", $this->_pageBuffer, $featureblock))
		{
			$features = '';
			
			if(preg_match_all("/<li>(.*?)<li>/si", $featureblock[1], $matches))
			{
				// generate a list of features
				for($i = 0; $i < count($matches[1]); $i++)
				{
					$features .= mystrip_tags($matches[1][$i])."\n";
				}
			}
			
			if(strlen($features)>0)
			{
				$this->addItemAttribute('features', $features);
			}
		}
	}
	
	function parse_amazon_music_data($search_attributes_r)
	{
		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $this->_pageBuffer, $regs))
		{
			$contents = explode(",", $regs[1]);
			if(is_not_empty_array($contents))
			{
				$this->addItemAttribute('artist', $contents[1]);
			}
		}
	
		if( ($sqidx = strpos($this->getItemAttribute('title'), "["))!==FALSE)
		{
			$this->addItemAttribute('comments', str_replaces(array('[',']'), array("\n",''), substr($this->getItemAttribute('title'),$sqidx)));
			$this->replaceItemAttribute('title', substr($this->getItemAttribute('title'),0,$sqidx));
		}
	
		if(preg_match("!<b>Erscheinungsdatum:</b>&#160;([^<)]+)<br>!sU", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('release_dt', $regs[1]);
			
			if(preg_match("!([0-9]+)$!", $this->getItemAttribute('release_dt'), $regs2))
			{
				$this->addItemAttribute('year', $regs2[1]);
			}
		}
	
		if(preg_match("!<B>Label:</B>([^<]+)<BR>!", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('musiclabel', $regs[1]);
		}
	
		if(preg_match("!CD-Anzahl\: (.*?)\)!si", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('no_discs', $regs[1]);
		}
	
		function parse_music_tracks($title, $disc_no, $titlePage)
		{
			$tracks = NULL;
			if(preg_match("!<b class=\"h1\">".preg_quote($title, "!")."</b><br>(.*)<hr noshade size=1>!Usi", $titlePage, $regs))
			{
				// Only parse for the disc number if disc_no specified
				if(!is_numeric($disc_no) || preg_match("!<b>Disc $disc_no</b>(.*)</table>!Usi", $regs[1], $regs2))
				{
					if(preg_match_all("![0-9]+\.(.*?)<br>!msi", is_numeric($disc_no)?$regs2[1]:$regs[1], $matches))
					{
						for ($i = 0; $i < count($matches[1]); $i++)
						{
							if(preg_match("!<a href=[^>]*>([^<]*)<img!i", $matches[1][$i], $regs3)) 
								$track = $regs3[1];
							else
								$track = $matches[1][$i];
	
							if(strlen($track)>0)
							{						
								$track = convert_html_numeric_codes(strip_tags($track));
								$track = trim(strtr($track, array_flip(get_html_translation_table(HTML_ENTITIES, ENT_QUOTES))));
								
								$tracks[] = $track;
							}
						}
					}
				}
			}
			return $tracks;
		}
	
		if(is_numeric($this->getItemAttribute('no_discs')) && $this->getItemAttribute('no_discs') > 1)
		{
			for($i=0; $i<$attributes["no_discs"]; $i++)
			{
				$cdtracks[$i] = parse_music_tracks("Titelverzeichnis", $i+1, $this->_pageBuffer);
				if($cdtracks[$i] == NULL)
					$cdtracks[$i] = parse_music_tracks("Hrbeispiele", $i+1, $this->_pageBuffer);
			}
			
			// Now coalesce into single cdtracks array
			if(is_not_empty_array($cdtracks))
			{
				for($i=0; $i<count($cdtracks); $i++)
				{
					if(is_not_empty_array($cdtracks[$i]))
					{
						for($j=0; $j<count($cdtracks[$i]); $j++)
						{
							$this->addItemAttribute('cdtrack', $cdtracks[$i][$j]);
						}
					}
				}
			}
		}
		else
		{ // one disc
			$this->addItemAttribute('cdtrack', parse_music_tracks("Titelverzeichnis", NULL, $this->_pageBuffer));
			if($attributes["cdtrack"] == NULL)
				$this->addItemAttribute('cdtrack', parse_music_tracks("Hrbeispiele", NULL, $this->_pageBuffer));
		}			
	}
	
	function parse_amazon_books_data($search_attributes_r)
	{
		// Author extraction
		if (preg_match('|von <a href=".*?">(.*?)</a>|si', $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('author', unhtmlentities(trim($regs[1])));
		}	
	
	
		// ISBN
		if(preg_match("/<b>ISBN:<\/b>(.*?)<br>/", $this->_pageBuffer, $regs2))
		{
			$this->addItemAttribute('isbn', $regs2[1]);	
		}
		
		// Publicationdate
		if(preg_match("/<b>Erscheinungsdatum:<\/b>(.*?)<br>/", $this->_pageBuffer, $regs2))
		{
			// All we want is the year here.
			if (preg_match("/([0-9]+)$/", $regs2[1], $regs3))
				$this->addItemAttribute('pub_date', $regs3[1]);		
		}
	
		//Publischer / Pages
		if(preg_match("/<b>[\s]*[Gebundene Ausgabe|Kalender|Taschenbuch|Broschiert|CD]+<\/b>[\n|\r]*- (.*?) - (.*?)<br>/m",$this->_pageBuffer,$regs))
		{
			if(preg_match("/([0-9]+)/", $regs[1], $regs2))
				$this->addItemAttribute('nb_pages', $regs2[1]);

			$this->addItemAttribute('publisher', unhtmlentities($regs[2]));
		}
	
		// Category
		if (preg_match('|<b>Kategorie\(n\):</b> <a .*?>(.*?)</a>|', $this->_pageBuffer, $regs2))
		{
			$this->addItemAttribute('genre', unhtmlentities($regs2[1]));
		}
	
		//Plot (Amazon blurb)
		$this->addItemAttribute('blurb', $this->parse_amazon_book_blurb($this->_pageBuffer));
	
		// Editorial reviews
		if(preg_match("/<a href=([^\"]+)>Alle Rezensionen ansehen/i", $this->_pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI('http://www.amazon.de/' . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($reviewPage)>0)
			{
				$this->addItemAttribute('blurb', $this->parse_amazon_book_blurb($reviewPage));
			}
		}
	}
	
	function parse_amazon_video_data($search_attributes_r, $s_item_type)
	{
		//Production extraction block
		if (preg_match("/<li><b>Produktion:<\/b>(.*)/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
		
		// Rating extraction block
		if (preg_match("/<li><b>FSK:<\/b>(.*)/i", $this->_pageBuffer, $regs))
		{
			if(preg_match("/<img src=.* alt=\"(.*)\">/", $regs[1], $regs2))
				$this->addItemAttribute('age_rating', $regs2[1]);
			else
				$this->addItemAttribute('age_rating', $regs[1]);
				
		}
	
		// Actor extraction block
		$this->addItemAttribute('actors', $this->parse_amazon_video_people("Darsteller",$this->_pageBuffer));
	
		// Director extraction block
		$this->addItemAttribute('director', $this->parse_amazon_video_people("Regie",$this->_pageBuffer));
		
		if (preg_match("/<b>Studio:<\/b>(.*)/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}
		
		// Region extraction block
		if (preg_match("/Region ([0-6])/", $this->_pageBuffer, $regs))
			$this->addItemAttribute('dvd_region', $regs[1]);
		else
			$this->addItemAttribute('dvd_region', '2'); //otherwise assume region 2
			
		// Edition details block - 'dvd_extras' attribute
		if(preg_match("/<b>DVD Features:<\/b>[\n](.*)<li><b>/si", $this->_pageBuffer, $regs))
		{
			// TODO "anamorphic" Other formating in Amazon EU
			// "no_discs" NOT Supported by Amazon EU
			
			if(preg_match_all("/<ul><li>(.*)<\/ul>/i",$regs[1], $matches))
			{
				$dvd_extras = "";
				
				while(list(,$item) = @each($matches[1]))
				{
					$item = convert_html_numeric_codes(strip_tags($item));
					$item = strtr($item, array_flip(get_html_translation_table(HTML_ENTITIES, ENT_QUOTES)));
					// We may have a hard space here, so get rid of it.
					$item = trim(strtr($item, chr(160), ' '));
	
					// Don't include the region, no_discs, anamorphic
					if(strpos($item, "Ton:")===FALSE)  // audio languages already parse this.
					{
						$dvd_extras .= $item."\n";
					}
				}
				
				if(strlen($dvd_extras)>0)
				{
					$this->addItemAttribute('dvd_extras', $dvd_extras);
				}
			}
		}
		
		if( ($sqidx = strpos($this->getItemAttribute('title'), "["))!==FALSE)
		{
			$this->replaceItemAttribute('title', substr($this->getItemAttribute('title'),0,$sqidx));
			
			$comments = str_replaces(array('[',']'), array("\n",''), substr($this->getItemAttribute('title'),$sqidx));
			
			$dvd_extras = $this->getItemAttribute('dvd_extras');
			if(strlen($dvd_extras)>0)
				$this->replaceItemAttribute('dvd_extras', $comments."\n".$dvd_extras);
			else
				$this->addItemAttribute('dvd_extras', $comments);
		}
		
		// "imdb_id" Not supported in Amazon EU
	
		// All Amazon.de items should be PAL!
		$this->addItemAttribute('vid_format', 'PAL');
	
		//Plot (Amazon blurb)
		$this->addItemAttribute('blurb', $this->parse_amazon_video_blurb($this->_pageBuffer));
	
		// Plot (Costumer Blurb)
		// If possible, fetch additional (technical) info from the site
		if(preg_match("/<a href=([^\"]+)>Alle Rezensionen ansehen/i", $this->_pageBuffer, $regs))
		{
			$detailPage = $this->fetchURI('http://www.amazon.de/' . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($detailPage)>0)
			{
				$this->addItemAttribute('blurb', $this->parse_amazon_video_blurb($detailPage));
			}
		}
	
		// If possible, fetch additional (technical) info from the site
		if(preg_match("/<a href=\"([^\"]+)\">Technische Informationen/i", $this->_pageBuffer, $regs))
		{
			$detailPage = $this->fetchURI('http://www.amazon.de/' . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($detailPage)>0)
			{
				if (preg_match("/Production Company:([^<]*)<br>/i", $detailPage, $regs))
				{
					$this->addItemAttribute('studio', $regs[1]);
				}
				
				if(preg_match("/DVD Erscheinungstermin: ([^<]+)<br>/i", $detailPage, $regs))
				{
					// Get year only, for now.  In the future we may add ability to
					// convert date to local date format.
					$regs = preg_split ("/[\s,]+/", trim($regs[1]));
					if(preg_match("/([0-9]+)$/m", $regs[2], $regs2))
						$this->addItemAttribute('dvd_rel_dt', $regs2[1]);
				}
			
				// Duration extraction block
				if (preg_match("/Laufzeit: ([0-9]+)/i", $detailPage, $regs))
				{
					$this->addItemAttribute('run_time', $regs[1]);
				}
	
				// Ratio
				if (preg_match(":Bildformat(.*)<br>:i", $detailPage, $regs))
				{
					if(preg_match_all("/([0-9]{1}\.[0-9]+):1/", $regs[1], $matches))
					{
						$this->addItemAttribute('ratio', $matches[1]);
					}
					
					if(strpos($regs[1], "4:3"))
					{
						$this->addItemAttribute('ratio', '1.33');
					}
					
					if(strpos($regs[1], "16:9"))
					{
						$this->addItemAttribute('ratio', '1.78');
					}
				}
				
				// Spoken languages
				if (preg_match("/Sprache[n]*:\\n([^<]*)<br>/i", $detailPage, $regs))
				{
					$this->addItemAttribute('audio_lang', trim_explode("\n", trim(preg_replace("/[\n]+/", "\n", str_replace("&nbsp;", "\n", $regs[1])))));
				}
				
				// Subtitles
				if(preg_match("/Untertitel:([^<]*)<br>/i", $detailPage, $regs))
				{
				    $this->addItemAttribute('subtitles', trim_explode(",", $regs[1]));
				}
			}
		}
	}
	
	function parse_amazon_game_blurb($str)
	{
		return $this->parse_amazon_video_blurb($str);
	}
	
	function parse_amazon_book_blurb($str)
	{
		return $this->parse_amazon_video_blurb($str);
	}
	
	function parse_amazon_video_blurb($str)
	{
		if(preg_match_all("/<i>(.*[^<])<\/i><\/b><\/span><br>[\n]<span class=\"serif\">(.*)<\/span>[\n]/i", $str, $regs))
		{
			$offset = 0;
			for ($i=0; $i< count($regs[1]); $i++)
			{
				if ($regs[1][$i] != "")
				{
					$ret[$offset] = trim(mystrip_tags($regs[2][$i]));
					
					$ret[$offset] .= "\n--".$regs[1][$i];
					$offset++;
				}
			}
		}
		else
		{
			return NULL;
		}
		return $ret;
	}
	
	function parse_amazon_video_people($name, $srchstr)
	{
		if (preg_match("/<b>$name:<\/b>[\n]([^\n]+)\n/i", $srchstr, $regs))
		{
			if (strpos($regs[1],'&nbsp;') !== FALSE)
			{
				$regs1 = explode('&nbsp;',$regs[1]);
			} else {
				$regs1[0] = $regs[1];
			}
	
			for ($i=0; $i<count($regs1); $i++)
			{
				if (preg_match_all ("/<a href=(.*)>(.*)<\/a>/si", $regs1[$i], $regs2))
				{
					if ($i>0)
						$parse_amazon_video_people .= ", ";

					$parse_amazon_video_people .= trim(strip_tags($regs2[2][0]));
				}
			}
			
			return $parse_amazon_video_people;
		}
		return NULL;
	}
}
?>
