/*
 * encoder-h261.h --
 *
 *      H.261 video encoder header file
 *
 * Copyright (c) 1994-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

//static const char rcsid[] =
//    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/codec/encoder-h261.h,v 1.5 2002/02/06 00:55:50 chema Exp $";

#ifdef INT_64
#define NBIT 64
#define BB_INT INT_64
#else
#define NBIT 32
#define BB_INT u_int
#endif

class H261Encoder : public EncoderModule {
	public:
		void setq(int q);
	protected:
		H261Encoder();
		~H261Encoder();
		virtual void encode(const VideoFrame*, const u_int8_t *crvec);
		int command(int argc, const char*const* argv);
		void encode_blk(const short* blk, const char* lm);
		virtual int flush(pktbuf* pb, int nbit, pktbuf* npb);
		char* make_level_map(int q, u_int fthresh);
		void setquantizers(int lq, int mq, int hq);

		virtual void size(int w, int h) = 0;
		virtual void encode_mb(u_int mba, const u_char* frm,
				u_int loff, u_int coff, int how) = 0;

		/* bit buffer */
		BB_INT bb_;
		u_int nbb_;

		u_char* bs_;
		u_char* bc_;
		int sbit_;

		u_char lq_;		/* low quality quantizer */
		u_char mq_;		/* medium quality quantizer */
		u_char hq_;		/* high quality quantizer */
		u_char mquant_;		/* the last quantizer we sent to other side */
		int quant_required_;	/* 1 if not quant'd in dct */
		u_int ngob_;
		u_int mba_;

		u_int cif_;		/* 1 for CIF, 0 for QCIF */
		u_int bstride_;
		u_int lstride_;
		u_int cstride_;

		u_int loffsize_;	/* amount of 1 luma block */
		u_int coffsize_;	/* amount of 1 chroma block */
		u_int bloffsize_;	/* amount of 1 block advance */

		char* llm_[32];	/* luma dct val -> level maps */
		char* clm_[32];	/* chroma dct val -> level maps */

		float lqt_[64];		/* low quality quantizer */
		float mqt_[64];		/* medium quality quantizer */
		float hqt_[64];		/* high quality quantizer */

		u_int coff_[12];	/* where to find U given gob# */
		u_int loff_[12];	/* where to find Y given gob# */
		u_int blkno_[12];	/* for CR */
};


class H261DCTEncoder : public H261Encoder {
	public:
		H261DCTEncoder();
		void recv(Buffer*);
		void size(int w, int h);
	protected:
		void encode_mb(u_int mba, const u_char* frm,
				u_int loff, u_int coff, int how);
};

class H261PixelEncoder : public H261Encoder {
	public:
		H261PixelEncoder();
		void recv(Buffer*);
		void size(int w, int h);
	protected:
		void encode_mb(u_int mba, const u_char* frm,
				u_int loff, u_int coff, int how);
};

static class H261PixelEncoderClass : public TclClass {
	public:
		H261PixelEncoderClass() : TclClass("Module/VideoEncoder/Pixel/H261") {}
		TclObject* create(int /* argc */, const char*const* /* argv */) {
				return (new H261PixelEncoder);
		}
} matcher_pixel;


static class H261DCTEncoderClass : public TclClass {
	public:
		H261DCTEncoderClass() : TclClass("Module/VideoEncoder/DCT/H261") {}
		TclObject* create(int /* argc */, const char*const* /* argv */) {
				return (new H261DCTEncoder);
		}
} matcher_dct;

