/*
 * xwin.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define HAVE_SHM

#include <stdio.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/ipc.h>
#ifdef HAVE_SHM
#include <sys/shm.h>
#endif
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef HAVE_SHM
#include <X11/extensions/XShm.h>
#endif

static Display *dpy;

struct wininfo {
	Window win;
	Visual	*visual;/* pointer to visual */
	XVisualInfo	 vinfo; /* info on visual (or template) */
	GC		 gc;	/* graphics context */
	Colormap	 cmap;	/* colormap */
	int		 x,y;	/* origin relative to parent */
};

Window
createXwindow(int w, int  h, char *wname, char *iname, struct wininfo *info)
{
	XVisualInfo *vList;
	int visualsMatched;
	XSizeHints size_hints;
	int screen;
	u_int border_width = 2;
	Window win, root;
	XSetWindowAttributes attr;

	/* Get screen size from display structure macro */
	info->vinfo.screen = screen = DefaultScreen(dpy);
	root = DefaultRootWindow(dpy);

#ifdef notdef
	if (info->visual == 0) {
		vList = XGetVisualInfo(dpy, VisualScreenMask|VisualDepthMask
				       | VisualClassMask,
				       &info->vinfo, &visualsMatched);
		if (visualsMatched == 0) {
			fprintf(stderr, "cannot find suitable visual\n");
			exit(-1);
		}
		info->visual = vList[0].visual;
		/* store info about Visual */
		info->vinfo = vList[0];

		/* each visual requires a different colormap */
		info->cmap = XCreateColormap(dpy, root, info->visual,
					     AllocNone);
	}
#else
	info->visual = DefaultVisual(dpy, DefaultScreen(dpy));
	info->cmap = DefaultColormap(dpy, DefaultScreen(dpy));
#endif
	attr.colormap = info->cmap;
	attr.event_mask = VisibilityChangeMask;
	attr.backing_store = Always;
	attr.border_pixel = BlackPixel(dpy, screen);
	attr.background_pixel = BlackPixel(dpy, screen);

	win = XCreateWindow(dpy, root, info->x, info->y, w, h,
			    border_width, info->vinfo.depth, InputOutput,
			    info->visual,
			    CWColormap | CWBorderPixel | CWBackPixel |
			    CWEventMask | CWBackingStore,
			    &attr);

	/* Initialize size hint property for window manager */
	size_hints.flags  = PSize;
	size_hints.width  = w;
	size_hints.height = h;
	if (info->x >= 0)
		size_hints.x = info->x;
	if (info->y >= 0)
		size_hints.y = info->y;
	size_hints.flags |= USPosition;

	/* Set properties for window manager (always before mapping) */
	XSetStandardProperties(dpy, win, wname, iname, None,
			       (char **) 0, 0, &size_hints);

	if (info->gc == 0)
		info->gc = XCreateGC(dpy, win, (u_long)0, (XGCValues *)0);

	XMapWindow(dpy, win);
	/*
	 * override window manager if it doesn't follow hints
	 * the standard says we're not supposed to do this!
	 */
	XResizeWindow(dpy, win, w, h);
	XFlush(dpy);
	info->win = win;
	for (;;) {
		XEvent e;
		XNextEvent(dpy, &e);
		if (e.type == VisibilityNotify)
			break;
	}
	return (win);
}

struct wininfo wi;
XImage *image;
u_char *ximage_data;
int ximage_width;
int ximage_height;
#ifdef HAVE_SHM
XShmSegmentInfo si;
#endif

extern int noshm;

makewin(int width, int height)
{
	if (dpy == 0) {
		dpy = XOpenDisplay(0);
		if (dpy == 0) {
			fprintf(stderr, "cannot open display\n");
			exit(1);
		}
	}
	wi.vinfo.class = PseudoColor;
	wi.vinfo.depth = 8;
	wi.x = 0;
	wi.y = 0;
	wi.win = createXwindow(width, height,
			       "dvic", "dvic",
			       &wi);

	image = XCreateImage(dpy, wi.visual, 8,
			     ZPixmap, 0, (char*)ximage_data,
			     width, height, 8, 0);
#ifdef HAVE_SHM
	if (noshm)
#endif
		ximage_data = (u_char*)malloc(width * height);
#ifdef HAVE_SHM
	else {
		si.shmid = shmget(IPC_PRIVATE, width * height,
				       IPC_CREAT|0777);
		ximage_data = (u_char *)shmat(si.shmid, 0, 0);
		if (ximage_data == (u_char*)-1) {
			perror("shmat");
			exit(1);
		}
		si.shmaddr = (char*)ximage_data;
		si.readOnly = 1;
		XShmAttach(dpy, &si);
		image->obdata = (char*)&si;
	}
#endif
	image->data = (char*)ximage_data;
	ximage_width = width;
	ximage_height = height;
}

putrawimage()
{
	XSync(dpy, 0);
#ifdef HAVE_SHM
	if (!noshm)
		XShmPutImage(dpy, wi.win, wi.gc, image,
			     0, 0, 0, 0,
			     ximage_width, ximage_height, 0);
	else
#endif
		XPutImage(dpy, wi.win, wi.gc, image,
			  0, 0, 0, 0,
			  ximage_width, ximage_height);
	XFlush(dpy);
}

int
pixscale(double d)
{
	if (d < 0)
		return (0);
	if (d > 255)
		return (255 << 8);
	return ((int)d << 8);
}

/*FIXME*/
#ifdef __alpha
#define u_long u_int
#endif

static u_long color_dither[16] =
  { 0x180a00, 0x080010, 0x1c0804, 0x0c0214,
    0x060618, 0x160c08, 0x02041c, 0x120e0c,
    0x1e0906, 0x0e0316, 0x1a0b02, 0x0a0112,
    0x00051e, 0x100f0e, 0x04071a, 0x140d0a };

#define COLORDITHER(l, c, base, d) \
	{ c = (base) + (d); \
	  c = ((c>>9) & 0x7c00) + ((c>>6) & 0x3e0) + ((c>>3) & 0x1f); \
	  c = (l)[c]; }

extern u_long yuv2rgb[65536], color_lut[32768];
u_long yuv2rgb[65536], grey_lut[256], color_lut[32768];
#define GREY_LEVELS 32

/*FIXME*/
#ifdef sun
#define LITTLEENDIAN 0
#else
#define LITTLEENDIAN 1
#endif
int color_ok;

#define YUVLIM(x) (((x) < 0) ? 0 : ((x) > 127) ? 127 : (x))

void
init_color_cube()
{
	int i, screen, r_shift, g_shift, b_shift;
	int r, g, b, r0, g0, b0, y, u, v, u0, v0;
	int colmap;
	XVisualInfo visinfo;
	XColor color;
	u_long small_lut[128], red_lut[128], green_lut[128];
	u_long blue_lut[128];
	int screenDepth = 8;/*FIXME*/

	screen = DefaultScreen(dpy);
	colmap = XDefaultColormap(dpy, screen);/*FIXME*/
#ifdef notdef
	if (DefaultDepth(dpy, screen) == 24) {
		screenDepth = 24;
		visual = DefaultVisual(dpy, screen);
		(void) XMatchVisualInfo(dpy, screen, 24, visual->class, &visinfo);
		colmap = XDefaultColormap(dpy, screen);
	} else if (XMatchVisualInfo(dpy, screen, 24, TrueColor, &visinfo)) {
		Tk_MakeWindowExist(tkMainWin);
		screenDepth = 24;
		visual = visinfo.visual;
		colmap = XCreateColormap(dpy, Tk_WindowId(tkMainWin), visual,
					 AllocNone);
	} else if (XMatchVisualInfo(dpy, screen, 24, DirectColor, &visinfo)) {
		Tk_MakeWindowExist(tkMainWin);
		screenDepth = 24;
		visual = visinfo.visual;
		colmap = XCreateColormap(dpy, Tk_WindowId(tkMainWin), visual,
					 AllocNone);
	} else {
		screenDepth = DefaultDepth(dpy, screen);
		visual = DefaultVisual(dpy, screen);
		colmap = XDefaultColormap(dpy, screen);
	}
#endif
	if (screenDepth == 1) {
		/*FIXME*/
	} else if ((screenDepth == 8)  || (screenDepth == 16)) {
		for (i = 1; i <= GREY_LEVELS; i++) {
			color.red = color.green = color.blue =
				i * 65536/GREY_LEVELS - 1;
			color.flags = DoRed | DoGreen | DoBlue;
			if (XAllocColor(dpy, colmap, &color) == 0) {
				fprintf(stderr, "cannot allocate greymap\n");
				exit(1);
			}
			if (LITTLEENDIAN && (screenDepth <= 16))
				color.pixel <<= (32-screenDepth);
			grey_lut[i] = color.pixel;
		}
		grey_lut[0] = grey_lut[1];
		for (i = GREY_LEVELS + 1; i < 2*GREY_LEVELS; i++)
			grey_lut[i] = grey_lut[GREY_LEVELS];

		i = 0;
		for (b=0; b<4; b++) {
			for (g=0; g<8; g++) {
				for (r=0; r<4; r++) {
					color.red = r * 16384 + 16383;
					color.green = g * 8192 + 8191;
					color.blue = b * 16384 + 16383;
					color.flags = DoRed | DoGreen | DoBlue;
					if (XAllocColor(dpy, colmap, &color) == 0) {
						if (screenDepth < 24)
							XFreeColors(dpy, colmap, small_lut, i, 0);
						fprintf(stderr, "Can't allocate color cube!\n");
						color_ok = 0;
						return;
					} else {
						if (LITTLEENDIAN && (screenDepth <= 16))
							color.pixel <<= (32-screenDepth);
						small_lut[i++] = color.pixel;
					}
				}
			}
		}

		i = 0;
		for (b=0; b<32; b++) {
			b0 = (b < 4) ? 0 : (b < 16) ? b/4-1 : 3;
			for (g=0; g<32; g++) {
				g0 = (g < 2) ? 0 : (g < 16) ? g/2-1 : 7;
				for (r=0; r<32; r++) {
					r0 = (r < 4) ? 0 : (r < 16) ? r/4-1 : 3;
					color_lut[i++] = small_lut[b0*32+g0*4+r0];
				}
			}
		}

		i = 0;
		for (u=0; u<128; u+=4) {
			for (v=0; v<128; v+=4) {
				for (y=0; y<128; y+=2) {
					u0 = (u < 64) ? u : (u-128);
					v0 = (v < 64) ? v : (v-128);
					r = y + 11*v0/8;
					g = y - 11*u0/32 -45*v0/64;
					b = y + 111*u0/64;
					yuv2rgb[i++] = (YUVLIM(b)<<16) + (YUVLIM(g)<<8) + YUVLIM(r);
				}
			}
		}
		color_ok = 1;
	} else if ((screenDepth == 24) || (screenDepth == 32)) {
		for (i=0; i<128; i++) {
			color.red = color.green = color.blue = i*512 + 256;
			color.flags = DoRed | DoGreen | DoBlue;
			if (XAllocColor(dpy, colmap, &color) == 0) {
				fprintf(stderr, "Can't allocate colors!\n");
				exit(1);
			}
			grey_lut[2*i] = grey_lut[2*i+1] = color.pixel;
			red_lut[i] = color.pixel & visinfo.red_mask;
			green_lut[i] = color.pixel & visinfo.green_mask;
			blue_lut[i] = color.pixel & visinfo.blue_mask;
		}

		i = 0;
		for (u=2; u<128; u+=4) {
			for (v=2; v<128; v+=4) {
				for (y=1; y<128; y+=2) {
					u0 = (u < 64) ? u : (u-128);
					v0 = (v < 64) ? v : (v-128);
					r = y + 11*v0/8;
					g = y - 11*u0/32 -45*v0/64;
					b = y + 111*u0/64;
					yuv2rgb[i++] = red_lut[YUVLIM(r)] +
						green_lut[YUVLIM(g)] +
							blue_lut[YUVLIM(b)];
				}
			}
		}
		color_ok = 1;
	} else {
		fprintf(stderr, "Can't handle this type of display.\n");
		exit(1);
	}
}

void
rf_dither_scale(u_long *xip, u_char *yp, u_char* up, u_char *vp,
		int scalebits)
{
	register int w, z, yy;
	register int scaler = 1 << scalebits;
#ifdef notdef
	const int width = image->width;/*FIXME*/
	const int height = image->height;
#else
	const int width = 320;/*FIXME*/
	int height = 232;
#endif

	register u_char y0, y1, y2;
	register u_short uv;
	register u_long *cd=color_dither, *lut=color_lut, c, base, out;

#ifdef notdef
	yp = &vidPtr->image->y_data[y*imagewidth+x];
	uvp = (u_short *) &vidPtr->image->uv_data[y*imagewidth+x];
	xip = &((u_long *)vidPtr->ximage->data)
		  [(y >> scalebits)*ximagewidth + (x >> (scalebits+2))];
#endif
	z = 0;
	while (height > 0) {
		for (w = width; w > 0; w -= 8*scaler) {
			uv = ((up[0] - 128) & 0xf8) << 8;
			uv |= ((vp[0] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[0] >> 2)];
			COLORDITHER(lut, out, base, cd[z]);

			uv = ((up[scaler/2] - 128) & 0xf8) << 8;
			uv |= ((vp[scaler/2] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[scaler] >> 2)];
			COLORDITHER(lut, c, base, cd[z+1]);
			out = (out >> 8) + c;

			yp += 2*scaler;
			up += scaler;
			vp += scaler;

			uv = ((up[0] - 128) & 0xf8) << 8;
			uv |= ((vp[0] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[0] >> 2)];
			COLORDITHER(lut, c, base, cd[z+2]);
			out = (out >> 8) + c;

			uv = ((up[scaler/2] - 128) & 0xf8) << 8;
			uv |= ((vp[scaler/2] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[scaler] >> 2)];
			COLORDITHER(lut, c, base, cd[z+3]);
			xip[0] = (out >> 8) + c;

			yp += 2*scaler;
			up += scaler;
			vp += scaler;

			uv = ((up[0] - 128) & 0xf8) << 8;
			uv |= ((vp[0] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[0] >> 2)];
			COLORDITHER(lut, out, base, cd[z]);

			uv = ((up[scaler/2] - 128) & 0xf8) << 8;
			uv |= ((vp[scaler/2] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[scaler] >> 2)];
			COLORDITHER(lut, c, base, cd[z+1]);
			out = (out >> 8) + c;

			yp += 2*scaler;
			up += scaler;
			vp += scaler;

			uv = ((up[0] - 128) & 0xf8) << 8;
			uv |= ((vp[0] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[0] >> 2)];
			COLORDITHER(lut, c, base, cd[z+2]);
			out = (out >> 8) + c;

			uv = ((up[scaler/2] - 128) & 0xf8) << 8;
			uv |= ((vp[scaler/2] - 128) & 0xf8) << 3;
			base = yuv2rgb[uv + (yp[scaler] >> 2)];
			COLORDITHER(lut, c, base, cd[z+3]);
			xip[1] = (out >> 8) + c;

			yp += 2*scaler;
			up += scaler;
			vp += scaler;
			xip += 2;
		}
		yp += width << (scalebits - 1);
		up += (width << (scalebits - 1)) / 2;
		z = (z + 4) & 0xf;
		height -= scaler;
	}
}

void
rf_dither(u_long *xip, u_char *yp, u_char* up, u_char *vp, int len)
{
	register int w, z, yy;

#ifdef notdef
	int imagewidth = 320;/*FIXME*/
	int ximagewidth = image->bytes_per_line/4;
#endif
	const int width = image->width;/*FIXME*/

	register u_char y0, y1, y2;
	register u_short uv;
	register u_long *cd=color_dither, *lut=color_lut, c, base, out;

	z = 0;

	w = width;
	for (; len >= 0; len -= 8) {
		uv = ((up[0] - 128) & 0xf8) << 8;
		uv |= ((vp[0] - 128) & 0xf8) << 3;
		base = yuv2rgb[uv + (yp[0] >> 2)];
		COLORDITHER(lut, out, base, cd[z]);

		base = yuv2rgb[uv + (yp[1] >> 2)];
		COLORDITHER(lut, c, base, cd[z+1]);
		out = (out >> 8) + c;

		uv = ((up[1] - 128) & 0xf8) << 8;
		uv |= ((vp[1] - 128) & 0xf8) << 3;
		base = yuv2rgb[uv + (yp[2] >> 2)];
		COLORDITHER(lut, c, base, cd[z+2]);
		out = (out >> 8) + c;

		base = yuv2rgb[uv + (yp[3] >> 2)];
		COLORDITHER(lut, c, base, cd[z+3]);
		xip[0] = (out >> 8) + c;

		uv = ((up[2] - 128) & 0xf8) << 8;
		uv |= ((vp[2] - 128) & 0xf8) << 3;
		base = yuv2rgb[uv + (yp[4] >> 2)];
		COLORDITHER(lut, out, base, cd[z]);

		base = yuv2rgb[uv + (yp[5] >> 2)];
		COLORDITHER(lut, c, base, cd[z+1]);
		out = (out >> 8) + c;

		uv = ((up[3] - 128) & 0xf8) << 8;
		uv |= ((vp[3] - 128) & 0xf8) << 3;
		base = yuv2rgb[uv + (yp[6] >> 2)];
		COLORDITHER(lut, c, base, cd[z+2]);
		out = (out >> 8) + c;

		base = yuv2rgb[uv + (yp[7] >> 2)];
		COLORDITHER(lut, c, base, cd[z+3]);
		xip[1] = (out >> 8) + c;

		yp += 8;
		up += 4;
		vp += 4;
		xip += 2;

		w -= 8;
		if (w <= 0) {
			w = width;
			z = (z + 4) % 16;
		}
	}
}

void
putcolorimage(u_char *yp, u_char *up, u_char *vp, int scalebits)
{
	const int len = image->width * image->height;/*FIXME*/

	XSync(dpy, 0);
	if (scalebits != 0)
		rf_dither_scale((u_long *)image->data, yp, up, vp, scalebits);
	else
		rf_dither((u_long *)image->data, yp, up, vp, len);
#ifdef HAVE_SHM
	if (!noshm)
		XShmPutImage(dpy, wi.win, wi.gc, image,
			     0, 0, 0, 0,
			     ximage_width, ximage_height, 0);
	else
#endif
		XPutImage(dpy, wi.win, wi.gc, image,
			  0, 0, 0, 0,
			  ximage_width, ximage_height);
	XFlush(dpy);
}

