/*
 * fca-pkt.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_FCA_PKT_H
#define MASH_FCA_PKT_H


#define FCA_VERSION 1		/* current protocol version */

#define PKT_FLOOR_REQUEST        1
#define PKT_FLOOR_CANCEL         2
#define PKT_FLOOR_RELEASE        3
#define PKT_GRANT_UPDATE         4
#define PKT_QUEUE_UPDATE         5
#define PKT_MODERATOR_SA         6
#define PKT_PARTICIPANT_SA       7
#define PKT_PARTICIPANT_RREQ     8
#define PKT_MODERATOR_RREQ       9
#define PKT_PARTICIPANT_RREPLY   10
#define PKT_MODERATOR_RREPLY     11
#define PKT_OBSOLETE             12


class FCA_Packet : public TclObject {
public:
  static FCA_Packet *New();
  static void Delete(FCA_Packet *packet);

  FCA_Packet() { }

  Bool Extract(u_char *&pb, int &len);
  Bool ExtractFloorRequest (u_char *&pb, int &len);
  Bool ExtractFloorCancel  (u_char *&pb, int &len);
  Bool ExtractFloorRelease (u_char *&pb, int &len);
  Bool ExtractModeratorSA  (u_char *&pb, int &len);
  Bool ExtractParticipantSA(u_char *&pb, int &len);
  Bool ExtractModeratorUpdate  (u_char *&pb, int &len, u_int32_t pktType);
  Bool ExtractGrantUpdateHelper(u_char *&pb, int &len);
  Bool ExtractQueueUpdateHelper(u_char *&pb, int &len);

  Bool Packetize(u_char *pb, int &len);
  Bool PacketizeFloorRequest (u_char *&pb, int &len);
  Bool PacketizeFloorCancel  (u_char *&pb, int &len);
  Bool PacketizeFloorRelease (u_char *&pb, int &len);
  Bool PacketizeModeratorSA  (u_char *&pb, int &len);
  Bool PacketizeParticipantSA(u_char *&pb, int &len);
  Bool PacketizeModeratorUpdate  (u_char *&pb, int &len, u_int32_t pktType);
  Bool PacketizeGrantUpdateHelper(u_char *&pb, int &len);
  Bool PacketizeQueueUpdateHelper(u_char *&pb, int &len);

  Bool ExtractParticipantRreq  (u_char *&pb, int &len);
  Bool ExtractModeratorRreq    (u_char *&pb, int &len);
  Bool ExtractParticipantRreply(u_char *&pb, int &len);
  Bool ExtractModeratorRreply  (u_char *&pb, int &len);
  Bool ExtractObsolete         (u_char *&pb, int &len);

  Bool PacketizeParticipantRreq  (u_char *&pb, int &len);
  Bool PacketizeModeratorRreq    (u_char *&pb, int &len);
  Bool PacketizeParticipantRreply(u_char *&pb, int &len);
  Bool PacketizeModeratorRreply  (u_char *&pb, int &len);
  Bool PacketizeObsolete         (u_char *&pb, int &len);

private:
  void SetVar(const char *varname, const char *value);
  void SetVar(const char *varname, u_int32_t value);
  void SetVar(const char *varname, u_int16_t value);

  void LAppendVar(const char *varname, const char *value);
  void LAppendVar(const char *varname, u_int16_t value);

  const char *GetVar(const char *varname);
  void GetVar(const char *varname, u_int32_t &value);
  void GetVar(const char *varname, u_int16_t &value);
  void GetVar(const char *varname, SrcId &value);
  void DGetVar(const char *varname, char *&value);

  const char *LIndex(const char *varname, int index);
  void LIndex(const char *varname, int index, u_int16_t &value);
  void LIndex(const char *varname, int index, FCA_Packet *&value);

  inline int roundoff(int value) {
    return ((value % 4 == 0) ? value : (value/4 + 1) * 4);
  }

  inline void incr(u_char *&pb, int &len, int howMuch) {
    pb  += howMuch;
    len -= howMuch;
  }
};






#endif // MASH_FCA_PKT_H
