/*
 * mb-tk-items.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-tk-items.cc,v 1.5 2002/02/03 03:16:30 lim Exp $";
#endif



#include "tclcl.h"
#include "mb/mb-items.h"
#include "mb/mb-canv.h"

extern "C"
{
#include <tk.h>
};




// This is the subsection of line configs that we support
// the ugly casing is to get the correct offset when
// we pass in a PageItem*
#define OFFSET_P2T(type,field) (size_t)(&((type*)((PageItem*)0))->field)

const char cszNull[]="";


static Tk_CustomOption arrowTypeOption = {LineItem::parseArrowType,
					  LineItem::printArrowType,
					  (ClientData) NULL};

static int ParseColor(ClientData clientData, Tcl_Interp* interp,
                      Tk_Window tkwin, char *value, char *recordPtr,
                      int offset);
static char *PrintColor(ClientData clientData, Tk_Window tkwin,
                        char *recordPtr, int offset,
                        Tcl_FreeProc **freeProcPtr);

static Tk_CustomOption colorOption = {
	ParseColor,
	PrintColor,
	(ClientData) NULL
};

/*
 * use our own string routines since we want to use new and delete throughout
 */
static int ParseString(ClientData cd, Tcl_Interp* interp,
		       Tk_Window tkwin, char *value, char *recordPtr,
		       int offset);
static char *PrintString(ClientData clientData, Tk_Window tkwin,
			 char *recordPtr, int offset,
			 Tcl_FreeProc **freeProcPtr);
static Tk_CustomOption stringOption = {
	ParseString,
	PrintString,
	(ClientData) NULL
};

//
// Lines and multi-lines
//
static Tk_ConfigSpec lineConfigSpecs[] = {
	{TK_CONFIG_SYNONYM,"-outline", "fill", (char *) NULL,
	 (char *) NULL, 0, 0},
	{TK_CONFIG_CUSTOM, "-fill", "fill", (char *) NULL,
	 (char *) NULL, OFFSET_P2T(LineItem,fg_), TK_CONFIG_NULL_OK,
	 &colorOption},
	{TK_CONFIG_CUSTOM, "-arrow", (char *) NULL, (char *) NULL,
	 (char *) NULL, OFFSET_P2T(LineItem, arrow_), TK_CONFIG_NULL_OK,
	 &arrowTypeOption},
	{TK_CONFIG_PIXELS, "-width", (char *) NULL, (char *) NULL,
	 "1", OFFSET_P2T(LineItem, width_), TK_CONFIG_DONT_SET_DEFAULT},
	{TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	 (char *) NULL, 0, 0}
};

//
// Text
//
static Tk_ConfigSpec textConfigSpecs[] = {
	{TK_CONFIG_CUSTOM, "-text", (char *) NULL, (char *) NULL,
	 "", OFFSET_P2T(TextItem,szText_), 0, &stringOption},
	{TK_CONFIG_CUSTOM, "-fill", "fill", (char *) NULL,
	 "black", OFFSET_P2T(TextItem,fillC_), 0, &colorOption},
	{TK_CONFIG_FONT, "-font", (char *) NULL, (char *) NULL,
	 (char*) NULL, OFFSET_P2T(TextItem,font_), 0},
	{TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	 (char *) NULL, 0, 0}
};

//
// Image
//
static Tk_ConfigSpec imageConfigSpecs[] = {
	{TK_CONFIG_CUSTOM, "-image", (char *) NULL, (char *) NULL,
	 "", OFFSET_P2T(ImageItem, szImageName_), 0, &stringOption},
	{TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	 (char *) NULL, 0, 0}
};

//
// Postscript
//
static Tk_ConfigSpec psConfigSpecs[] = {
	{TK_CONFIG_CUSTOM, "-file", (char *) NULL, (char *) NULL,
	 "", OFFSET_P2T(PSItem, szFileName_), 0, &stringOption},
	{TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	 (char *) NULL, 0, 0}
};


//
// This is used for ovals, rects, and other polygons
//
static Tk_ConfigSpec polyConfigSpecs[] = {
	{TK_CONFIG_CUSTOM,  "-fill", (char *) NULL, (char *) NULL,
	 "none", OFFSET_P2T(PolyItem,fillC_),
	 TK_CONFIG_DONT_SET_DEFAULT|TK_CONFIG_NULL_OK,
	 &colorOption},
	{TK_CONFIG_CUSTOM, "-outline", (char *) NULL, (char *) NULL,
	 "black", OFFSET_P2T(PolyItem,outlineC_), TK_CONFIG_NULL_OK,
	 &colorOption},
	{TK_CONFIG_PIXELS, "-width", (char *) NULL, (char *) NULL,
	 "1", OFFSET_P2T(PolyItem, width_), TK_CONFIG_DONT_SET_DEFAULT},
	{TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
	 (char *) NULL, 0, 0}
};

//
// Convert from ArrowType to the names
//
char* aArrowTypeNames[] = {
	"none",
	"first",
	"last",
	"both",
	"",
};

//
// Array of structure so that aConfigSpecs[type] is the correct specs
//
static Tk_ConfigSpec *aConfigSpecs[] = {
	NULL,                       // none
	lineConfigSpecs,            // line
	polyConfigSpecs,            // rect
	polyConfigSpecs,            // oval
	lineConfigSpecs,            // mline
	textConfigSpecs,            // text
	imageConfigSpecs,           // image
	psConfigSpecs,           // image
	NULL                        // invalid
};

//
// To be more consistent we get the XColor structure from name, pass it thru
// Tk_GetColorByValue, and assign that the color we store
//
static int ParseColor(
	ClientData /*clientData*/, // Not used
	Tcl_Interp* interp,     // Used for error reporting.
	Tk_Window tkwin,       // Not used.
	char *value,           // Textual specs arrow shape.
	char *recordPtr,       // Pointer to item record in which to
	// store arrow information.
	int offset             // Offset in record
	)
{
	XColor **ppColor = (XColor**) (recordPtr + offset);
	if (*value=='\0') {
		*ppColor=NULL;
		return TCL_OK;
	}
	Tk_Uid uid = Tk_GetUid(value);
	XColor *pTmpColor = Tk_GetColor(interp, tkwin, uid);
	if (pTmpColor==NULL) {
		Tcl_AppendResult(interp, "bad color \"", value,
				 (char *) NULL);
		return TCL_ERROR;
	}
	*ppColor = Tk_GetColorByValue(tkwin,pTmpColor);
	Tk_FreeColor(pTmpColor);
	return TCL_OK;
}

//
// The complement function for parse color
//
// WARNING: This function is designed to be called by
// PageItem::formatConfigValue
// only, it behaves differently in memory allocations from the standard
// tk stuff! i.e. we use new and delete vs Tcl_Alloc and Tcl_Free
static char *
PrintColor(
	ClientData /*clientData*/,  /* Not used. */
	Tk_Window /*tkwin*/,        /* Window associated with  widget. */
	char *recordPtr,            /* Pointer to item record containing shape
				     * information. */
	int offset,                 /* Offset of arrow information in
				     * record. */
	Tcl_FreeProc **freeProcPtr  /* Store address of procedure to call to
				     * free string here. */
	)
{
	*freeProcPtr = (Tcl_FreeProc*)NULL;
	char *result;
	XColor *colorPtr = *((XColor **) (recordPtr+offset));
	if (colorPtr != NULL) {
		::AllocNCopy(&result, Tk_NameOfColor(colorPtr));
		*freeProcPtr = &Tcl_Free; // just a token for formatConfigValue
	}
	else
		result= "";
	return result;
}



// Copy the string, note that we use new and delete Vs ckalloc and ckfree!

static int
ParseString(ClientData /*clientData*/, Tcl_Interp* /*interp*/,
	    Tk_Window /*tkwin*/, char *value, char *recordPtr, int offset)
{
	char **ppdest = (char**) (recordPtr + offset);
	char *newstr;
	::AllocNCopy(&newstr, value);
	delete *ppdest;
	*ppdest = newstr;
	return TCL_OK;
}

//
// The complement function for ParseString
//
static char *
PrintString(ClientData /*clientData*/, Tk_Window /*tkwin*/, char *recordPtr,
	    int offset, Tcl_FreeProc **freeProcPtr)
{
	*freeProcPtr = (Tcl_FreeProc*)NULL;
	char *result;
	char *value = *((char **) (recordPtr+offset));
	if (value != NULL) {
		::AllocNCopy(&result, value);
		*freeProcPtr = &Tcl_Free; // just a token for formatConfigValue
	} else {
		result="";
	}
	return result;
}

/*
 * LineItem::parseArrowType --
 *
 *	This procedure is called back during option parsing to
 *	parse arrow type information.
 *
 *	The return value is a standard Tcl result:  TCL_OK means
 *	that the arrow shape information was parsed ok, and
 *	TCL_ERROR means it couldn't be parsed.
 *
 * Side effects:
 *	Arrow information in recordPtr is updated.
 *
 */

/* static member function */
int LineItem::parseArrowType(
	ClientData /*clientData*/, // Not used
	Tcl_Interp* interp,     // Used for error reporting.
	Tk_Window /*tkwin*/,       // Not used.
	char *value,           // Textual specs arrow shape.
	char *recordPtr,       // Pointer to item record in which to
	// store arrow information.
	int offset             // Offset in record
	)
{
	LineItem *pLineItem = (LineItem *) recordPtr;

	if (offset != (int)OFFSET_P2T(LineItem,arrow_)) {
		SignalError(("ParseArrowType received bogus offset"));
		return TCL_ERROR;
	}
	int i;
	for (i = ArrowNone; i<ArrowInvalid; i++) {
		if (!strcmp(value, aArrowTypeNames[i]))
			break;
	}
	if (i == ArrowInvalid) {
		Tcl_ResetResult(interp);
		Tcl_AppendResult(interp, "bad arrow Type \"", value,
				 "\": must be either none, both, first or last", (char *) NULL);
		return TCL_ERROR;
	}

	pLineItem->arrow_ = (ArrowType)i;

	return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * LineItem::printArrowType
 *
 *	This procedure is a callback invoked by the configuration
 *	code to return a printable value describing an arrow type
 *
 *--------------------------------------------------------------
 */

/* static member function */
char *
LineItem::printArrowType(
	ClientData /*clientData*/,
	Tk_Window /*tkwin*/,
	char *recordPtr,            /* Pointer to item record containing
				     * current shape information. */
	int offset,                 /* Offset of arrow information in record */
	Tcl_FreeProc ** /*freeProcPtr*/
                                /* Store address of procedure to call to
                                 * free string here. */
	)
{
	if (offset != (int)OFFSET_P2T(LineItem,arrow_)) {
		SignalError(("PrintArrowType received bogus offset"));
		return NULL;
	}
	LineItem *linePtr = (LineItem *) recordPtr;
	if (linePtr->arrow_ > ArrowInvalid) {
		SignalError(("Invalid arrow type!"));
		return NULL;
	}
	return aArrowTypeNames[linePtr->arrow_];
}




char *PageItem::formatConfigValue(MBCanvas *pCanv,
				  Tk_ConfigSpec* pSpec, Bool* pFree)
{
	char *ptr,*result="";
	*pFree=FALSE;
	ptr = (char*)this + pSpec->offset;
	switch (pSpec->type) {
	case TK_CONFIG_BOOLEAN:
		if (*((int *) ptr) == 0) {
			result="0";
		} else {
			result="1";
		}
		break;
	case TK_CONFIG_PIXELS:
	case TK_CONFIG_INT:
		result = new char[MAX_INT_CHAR];
		if (!result) {
			SignalError(("Out of memory!"));
			return NULL;
		}
		sprintf(result, "%d", *((int *) ptr));
		*pFree=TRUE;
		break;
	case TK_CONFIG_MM:
	case TK_CONFIG_DOUBLE:
		result = new char[TCL_DOUBLE_SPACE];
		if (!result) {
			SignalError(("Out of memory!"));
			return NULL;
		}
		Tcl_PrintDouble(Tcl::instance().interp(),
				*((double *) ptr), result);
		*pFree=TRUE;
		break;
	case TK_CONFIG_STRING:
		if ((*(char **) ptr) != NULL) {
			result = *(char **) ptr;
		}
		break;
	case TK_CONFIG_UID: {
		Tk_Uid uid = *((Tk_Uid *) ptr);
		if (uid != NULL) {
			result=uid;
		}
		break;
	}
	case TK_CONFIG_COLOR: {
		XColor *colorPtr = *((XColor **) ptr);
		if (colorPtr != NULL) {
			::AllocNCopy(&result, Tk_NameOfColor(colorPtr));
			*pFree = TRUE;
		}
		break;
	}
	case TK_CONFIG_FONT: {
		Tk_Font tkfont = *((Tk_Font*) ptr);
		if (tkfont != NULL) {
			::AllocNCopy(&result, pCanv->scaleFont(tkfont));
			*pFree = TRUE;
		}
		break;
	}
	case TK_CONFIG_BITMAP: {
		Pixmap pixmap = *((Pixmap *) ptr);
		if (pixmap != None) {
			::AllocNCopy( &result,
				Tk_NameOfBitmap(Tk_Display(
					Tk_MainWindow(
						Tcl::instance().interp())),
						pixmap));
			*pFree = TRUE;
		}
		break;
	}
	case TK_CONFIG_BORDER: {
		Tk_3DBorder border = *((Tk_3DBorder *) ptr);
		if (border != NULL) {
			::AllocNCopy(&result, Tk_NameOf3DBorder(border));
			*pFree = TRUE;
		}
		break;
	}
	case TK_CONFIG_RELIEF:
		::AllocNCopy(&result,Tk_NameOfRelief(*((int *) ptr)));
		*pFree = TRUE;
		break;
	case TK_CONFIG_CURSOR:
	case TK_CONFIG_ACTIVE_CURSOR: {
		Tk_Cursor cursor = *((Tk_Cursor *) ptr);
		if (cursor != None) {
			Tk_Window tkwin =
				Tk_MainWindow(Tcl::instance().interp());
			::AllocNCopy(&result,
				     Tk_NameOfCursor(Tk_Display(tkwin),
						     cursor));
			*pFree=TRUE;
		}
		break;
	}
	case TK_CONFIG_JUSTIFY:
		::AllocNCopy(&result, Tk_NameOfJustify(*((Tk_Justify *) ptr)));
		*pFree=TRUE;
		break;
	case TK_CONFIG_ANCHOR:
		::AllocNCopy(&result, Tk_NameOfAnchor(*((Tk_Anchor *) ptr)));
		*pFree=TRUE;
		break;
	case TK_CONFIG_CAP_STYLE:
		::AllocNCopy(&result, Tk_NameOfCapStyle(*((int *) ptr)));
		*pFree = TRUE;
		break;
	case TK_CONFIG_JOIN_STYLE:
		::AllocNCopy(&result, Tk_NameOfJoinStyle(*((int *) ptr)));
		*pFree = TRUE;
		break;
	case TK_CONFIG_CUSTOM:
	{
		Tcl_FreeProc *pFreeProc=NULL;
		result = (*pSpec->customPtr->printProc)(
			pSpec->customPtr->clientData, (Tk_Window)NULL,
			(char*) this, pSpec->offset,
			(Tcl_FreeProc **)&pFreeProc);
		if (pFreeProc) {
			*pFree = TRUE;
		}
		break;
	}
	default:
		result = "?? unknown type ??";
		assert(false);          // there is a type we couldn't handle
		break;
	}
	return result;
}



char *PageItem::getPropsAsStr(MBCanvas* pCanv)
{
	if (type_>=PgItemInvalid) {
		Trace(ALL,("Error: invalid type!"));
		return NULL;
	}
	Tk_ConfigSpec* pCSpecs=aConfigSpecs[type_];
	if (!aConfigSpecs[type_]) {
		Trace(ALL,("Error: invalid type!"));
		return NULL;
	}
	// format all the ConfigSpecs
	int numSpecs=0;
	// get the number of specs
	for (;pCSpecs->type != TK_CONFIG_END;pCSpecs++)
		if (pCSpecs->type!=TK_CONFIG_SYNONYM) numSpecs++;

	char **argv=new char*[(numSpecs*2)];
	Bool *aFree =new Bool[(numSpecs*2)];
	if (!argv || !aFree) {
		SignalError(("Out of memory!"));
		return NULL;
	}
	char **pArg=argv;
	Bool *pFree=aFree;
	for (pCSpecs=aConfigSpecs[type_]; pCSpecs->type!=TK_CONFIG_END;
	     pCSpecs++) {
		if (pCSpecs->type==TK_CONFIG_SYNONYM) continue;
		*(pArg++) = pCSpecs->argvName;
		*(pFree++) = FALSE;
		*(pArg++) = formatConfigValue(pCanv, pCSpecs, pFree++);
	}
	assert(pArg==argv+(numSpecs*2) && "size mismatch");
	assert(pFree==aFree+(numSpecs*2) && "size mismatch");
	char *szResult=Tcl_Merge(numSpecs*2, argv);
	for (int i=0; i<(numSpecs*2); i++)
		if (aFree[i])
			delete[] argv[i];
	delete[] argv;
	delete[] aFree;
	return szResult;
}


/* static member function*/
char *PageItem::getProp(const char *szTypeName, const char *szPrefix)
{
	PageItemType type= PageItem::strName2Type(szTypeName);
	if (type>=PgItemInvalid) {
		Trace(ALL,("Error: invalid type: %s!",szTypeName));
		return NULL;
	}
	Tk_ConfigSpec* pCSpecs=aConfigSpecs[type];
	if (!aConfigSpecs[type]) {
		Trace(ALL,("Error: invalid type!"));
		return NULL;
	}
	int numSpecs = 0;
	for (;pCSpecs->type != TK_CONFIG_END; pCSpecs++ )
		if (pCSpecs->type!=TK_CONFIG_SYNONYM)
			numSpecs++;
	char **argv = new char*[numSpecs*2];
	char **pArg = argv;
	char *szCmd=NULL;
	Tcl& tcl=Tcl::instance();
	for (pCSpecs = aConfigSpecs[type];
	     pCSpecs->type != TK_CONFIG_END; pCSpecs++)
	{
		if (pCSpecs->type==TK_CONFIG_SYNONYM) continue;

		*(pArg++)=pCSpecs->argvName;
		szCmd = Concat3(szPrefix, " ", pCSpecs->argvName);
		if (!szCmd) return NULL;
		tcl.eval(szCmd);
		char *szProp=tcl.result();
		::AllocNCopy(pArg++, Tcl_Merge(1, &szProp));
		if (**(pArg-1)==cchNull) {
			*(pArg-2) = (char*)cszNull;
		}
		delete[] szCmd;
	}
	assert((pArg==argv+(numSpecs*2)) && "size mismatch");
	char *szResult=Tcl_Concat(numSpecs*2, argv);
	if (szResult==NULL) {
		assert(FALSE);
	}
	return szResult;
}


Bool PageItem::configure(int argc, const char *const*argv)
{
	MB_DefTcl(tcl);
	int retCode= Tk_ConfigureWidget(tcl.interp(),
					Tk_MainWindow(tcl.interp()),
					aConfigSpecs[type_], argc,
					(char**)argv, (char*)this, 0);
	if (retCode != TCL_OK) {
		Tk_FreeOptions(lineConfigSpecs, (char*)this,
			       Tk_Display(Tk_MainWindow(tcl.interp())), 0);
	}
	return (retCode == TCL_OK) ? TRUE : FALSE;
}



XColor *
MB_GetColorByValue(XColor *clr)
{
	Tk_Window tkwin = Tk_MainWindow(MB_Interp);
	return Tk_GetColorByValue(tkwin, clr);
}


void
MB_FreeColor(XColor *clr)
{
	Tk_FreeColor(clr);
}


char *
MB_NameOfFont(Tk_Font tkfont)
{
	return Tk_NameOfFont(tkfont);
}


Tk_Font
MB_GetFont(const char *string)
{
	Tcl_Interp *interp = MB_Interp;
	Tk_Window tkwin = Tk_MainWindow(interp);
	return Tk_GetFont(interp, tkwin, string);
}


void
MB_FreeFont(Tk_Font tkfont)
{
	Tk_FreeFont(tkfont);
}
