# agent-synch.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPAgent
import RTP/Video

Class SynchSrcVideoAgent -superclass {RTPAgent RTP/Video}

SynchSrcVideoAgent public init {app switch spec {callback {}}} {
    $self instvar spec_;

    set spec_ $spec;

    if { $spec != "" } {
	set ab [new AddressBlock $spec]
	set fmt [$ab fmt]
	if { $fmt != {} } { $self add_option videoFormat $fmt }
    } else {
	set ab ""
    }
    $self next $ab $callback
    if { $ab != "" } {
	delete $ab
    }

    $self site-drop-time [$self get_option siteDropTime]

    $self instvar synch_buffers_
    set synch_buffers_ ""

    $self instvar switch_;

    set switch_ $switch;
}

SynchSrcVideoAgent instproc create_synch_src {src} {
    $self instvar switch_;

    set synch_src [$switch_ register_source $self $src];

    return $synch_src;
}

SynchSrcVideoAgent public create_session {} {
    return [new Session/RTP/Video];
}

SynchSrcVideoAgent public activate src {
    $self instvar synch_sources_;

    set s [$self create_synch_src $src];
    lappend synch_sources_ $s;

    global kpatel_debug;
    if {[info exists kpatel_debug]} {
	set logger [new Module/RTPPktLogger];
	$logger target [$s synch_buffer];
	$src handler $logger;
    } else {
	$src handler [$s synch_buffer];
    }
    $src set synch_src_ $s;

    $self next $src;
}

SynchSrcVideoAgent public deactivate src {
puts "In deactivate"
    $self instvar synch_sources_;

    set s [$src set synch_src_];

    set k [lsearch -exact $synch_sources_ $s];
    set synch_sources_ [lreplace $synch_sources_ $k $k];
    set l "";
    if {[$src handler] != [$s synch_buffer]} {
	# Must have a logger.
	set l [$src handler];
    }
    if {$l != ""} {
	delete $l;
    }
    $self instvar switch_

    $switch_ unregister_source $s;

    $self next $src;
}

SynchSrcVideoAgent public reactivate src {
}

