# mgr-tgmb.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


TGMB_Manager instproc new_source { src } {
	$self instvar sources_

	set src_id [$src srcid]
	set cname  [$src cname]
	set sources_($src_id) $cname
	TCP/MediaPad send_srcname $src_id $cname
}


TGMB_Manager instproc cname_update { src newName } {
	$self instvar sources_

	set src_id [$src srcid]
	set sources_($src_id) $newName
	TCP/MediaPad send_srcname $src_id $newName
}


TGMB_Manager instproc create_canvas { page_id } {
	$self instvar canvas_

	if { ![info exists canvas_($page_id)] } {
		set canvas_($page_id) [new TGMB_Canvas $page_id]
		TCP/MediaPad send_newpage $page_id
	}

	return $canvas_($page_id)
}


TGMB_Manager instproc get_canvas { page_id } {
	$self instvar canvas_
	if [info exists canvas_($page_id)] {
		return $canvas_($page_id)
	} else {
		return ""
	}
}


TGMB_Manager instproc get_page_list { } {
	$self instvar canvas_
	return [array names canvas_]
}


TGMB_Manager instproc get_source_list { } {
	$self instvar sources_
	return [array get sources_]
}


TGMB_Manager instproc source_action { args } {
}


TGMB_Manager instproc page_action { args } {
}


TGMB_Canvas set got_updates_recently_ 0
TGMB_Canvas set update_scheduled_ 0


TGMB_Canvas public schedule_update_clients { } {
	$self instvar after_id_ got_updates_recently_ missed_updates_
	if [info exists after_id_] return
	set after_id_ [after 100 "$self do_update_clients"]
	set got_updates_recently_ 0
	set missed_updates_ 0
}


TGMB_Canvas private do_update_clients { } {
	$self instvar after_id_ got_updates_recently_ missed_updates_
	if $got_updates_recently_ {
		set got_updates_recently_ 0
		if {$missed_updates_ > 15 } {
			# it's been a while since we updated
			# let's do so now
			$self actually_update
			return
		}
		incr missed_updates_
		set after_id_ [after 100 "$self do_update_clients"]
	} else {
		$self actually_update
	}
}


TGMB_Canvas private actually_update {} {
	$self instvar after_id_ got_updates_recently_ missed_updates_ \
			update_scheduled_
	TCP/MediaPad send_data_to_everyone $self
	unset after_id_
	set missed_updates_ 0
	set got_updates_recently_ 0
	set update_scheduled_ 0
}




proc extract_file { filename } {
	# read in the original file
	set file [open $filename]
	fconfigure $file -translation binary
	set orig_image ""
	while { ![eof $file] } {
		append orig_image [read $file 1024]
	}
	close $file
	if { [string length $orig_image]==0 } {
		error "Invalid image file: $filename"
	}
	return $orig_image
}
