# mark2graph.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_levels g_infile

proc init {argv} {
    global g_levels g_infile

    if {([llength $argv] != 1) && ([llength $argv] != 6)} {
	puts stdout "Usage: mark2graph <log.mark file> \[<speaker> <left> <center> <right> <generic>\]"
	exit
    }

    set g_infile [lindex $argv 0]

    if {[llength $argv] == 6} {
	set g_levels(speaker) [lindex $argv 1]
	set g_levels(left) [lindex $argv 2]
	set g_levels(center) [lindex $argv 3]
	set g_levels(right) [lindex $argv 4]
	set g_levels(generic) [lindex $argv 5]
    } else {
	set g_levels(speaker) 10
	set g_levels(left) 100
	set g_levels(center) 125
	set g_levels(right) 150
	set g_levels(generic) [200]
    }
}

proc makeOutfile {} {
    global g_levels g_infile

    if {[catch {open $g_infile r} infile]} {
        puts stdout "Cannot open file $g_infile for reading"
        return 0
    }

    # at this point, infile is open

    # always assume starting with speaker
    puts stdout "0 $g_levels(speaker)"
    while {[gets $infile line] >= 0} {
	set sLine [split $line " "]
	set type [lindex $sLine 0]
	set mode [lindex $sLine 1]
	set index [lindex $sLine 2]
	processEntry $index $type $mode
    }

    close $infile
}

proc processEntry {index type mode} {
    global g_levels

#    puts stdout "index=$index, type=$type, mode=$mode"


    switch -exact -- $type {
	start {
	    set prev [expr $index - 1]
	    puts stdout "$prev $g_levels(speaker)"
	    puts stdout "$index $g_levels($mode)"
	}
	end {
	    set after [expr $index + 1]
	    puts stdout "$index $g_levels($mode)"
	    puts stdout "$after $g_levels(speaker)"
	}
    }
}

# main program


init $argv

makeOutfile

