# agent-tracker.tcl --
#
#       Derived from VideoAgent but instead of creating a decoder attaches
#       the video stream to a Tracker object.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import VideoAgent Module/Tracker

Class TrackerAgent -superclass { VideoAgent }

TrackerAgent public init  { app spec frameName {scale_size 8} {callback {}}} {
    $self instvar tracker_ canvas_name_ my_decoder_ scale_size_ app_name_

    eval $self next $app $spec $callback
    set canvas_name_ $frameName
    set app_name_ $app
    set scale_size_ $scale_size
    set my_decoder_ ""
    set tracker_ ""
}


# override this function to use our tracking decoder
TrackerAgent public create_decoder src {
    $self instvar canvas_name_ scale_size_ my_decoder_ app_name_ tracker_

    set c [$self classmap [$src format_name]]

# the stuff below can be used to determine the source of an RTP stream
#   sometimes the tcl stuff messes up and gives you machnick@128.... for
#   getid, sometimes it just gives you 128.... - not sure what the correct
#   behavior should be
#
# it seems to give the machnick@128... version when I start Vic, but don't
#   transmit, start trak, then turn on transmission; perhaps the first
#   packet is different?; it doesn't always do that though...
#
# for now use the C++ version, maybe I just don't understand the difference
#   between addr and getid

#    puts stdout "from C++"
#    set addr [$src addr]
#    set ssrc [$src ssrc]
#    set srcid [$src srcid]
#    set format [$src format_name]
#    puts stdout "addr = $addr"
#    puts stdout "srcid = $srcid"
#    puts stdout "ssrc = $ssrc"
#    puts stdout "format = $format"

#    puts stdout "from Tcl"
#    set temp1 [$src getid]
#    set temp2 [$src format_name]
#    puts stdout "getid returns $temp1"
#    puts stdout "format_name returns $temp2"

    set addr [$src addr]

    if { $tracker_ == ""} {

# FIXME - this is a hack to guarantee which feed it takes
#    the right way to do it would be to pass a table that says for each
#    given source what type of decoder and what camera to use
#  htsr = "169.229.12.88" or "169.229.12.89"
#  garfield = "128.32.131.244"

	if {$addr == "169.229.12.88" || $addr == "128.32.131.244"} {
	    set tracker_ [new Module/Tracker $canvas_name_ $scale_size_ $self]
	    set decoder [new Module/VideoDecoder/Tracker_H261 $tracker_]
	} else {
	    set decoder [new Module/VideoDecoder/Null]
	}
    } else {
	set decoder [new Module/VideoDecoder/Null]
    }
    if { $decoder == "" } {
	# don't support this format
	set decoder [new Module/VideoDecoder/Null]
    }
    #FIXME
    $decoder set agent_ $self
    $decoder set src_ $src

    $self instvar channels_
    $decoder set maxChannel_ $channels_

    set my_decoder_ $decoder

    return $decoder
}

